/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IoMode;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketIoMode
implements IMessage,
IMessageHandler<PacketIoMode, IMessage> {
    private int x;
    private int y;
    private int z;
    private IoMode mode;
    private EnumFacing face;

    public PacketIoMode() {
    }

    public PacketIoMode(IIoConfigurable cont) {
        BlockCoord location = cont.getLocation();
        this.x = location.x;
        this.y = location.y;
        this.z = location.z;
        this.mode = IoMode.NONE;
        this.face = null;
    }

    public PacketIoMode(IIoConfigurable cont, EnumFacing face) {
        BlockCoord location = cont.getLocation();
        this.x = location.x;
        this.y = location.y;
        this.z = location.z;
        this.face = face;
        this.mode = cont.getIoMode(face);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeShort((int)((short)this.mode.ordinal()));
        if (this.face != null) {
            buf.writeShort((int)((short)this.face.ordinal()));
        } else {
            buf.writeShort(-1);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.mode = IoMode.values()[buf.readShort()];
        short ord = buf.readShort();
        this.face = ord < 0 ? null : EnumFacing.values()[ord];
    }

    public IMessage onMessage(PacketIoMode message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TileEntity te = player.field_70170_p.func_175625_s(new BlockPos(message.x, message.y, message.z));
        if (te instanceof IIoConfigurable) {
            IIoConfigurable me = (IIoConfigurable)te;
            if (message.face == null) {
                me.clearAllIoModes();
            } else {
                me.setIoMode(message.face, message.mode);
            }
        }
        return null;
    }
}

