/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.OreDictionaryHelper;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelPickaxe;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeHarvestUtil;
import crazypants.enderio.material.Alloy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemDarkSteelAxe
extends ItemAxe
implements IAdvancedTooltipProvider,
IDarkSteelItem,
EnderCoreMethods.IOverlayRenderAware {
    public static final String NAME = "darkSteel_axe";
    private int logOreId = -1;
    private final MultiHarvestComparator harvestComparator = new MultiHarvestComparator();

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184614_ca();
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() == DarkSteelItems.itemDarkSteelAxe;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelAxe.getStoredPower(player) > requiredPower;
    }

    public static int getStoredPower(EntityPlayer player) {
        if (!ItemDarkSteelAxe.isEquipped(player)) {
            return 0;
        }
        return EnergyUpgrade.getEnergyStored(player.func_184614_ca());
    }

    public static ItemDarkSteelAxe create() {
        ItemDarkSteelAxe res = new ItemDarkSteelAxe();
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected ItemDarkSteelAxe() {
        super(Item.ToolMaterial.DIAMOND);
        this.field_77862_b = ItemDarkSteelSword.MATERIAL;
        this.field_77865_bY = 8.0f;
        this.field_185065_c = -3.0f;
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
    }

    @Override
    public String getItemName() {
        return NAME;
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @Override
    public boolean isItemForRepair(ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Alloy.DARK_STEEL.getOreIngot());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        par3List.add(is);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && player.func_70093_af()) {
            IBlockState bs = player.field_70170_p.func_180495_p(pos);
            Block block = bs.func_177230_c();
            if (this.isLog(bs)) {
                int powerStored = EnergyUpgrade.getEnergyStored(itemstack);
                TreeHarvestUtil harvester = new TreeHarvestUtil();
                HarvestResult res = new HarvestResult();
                harvester.harvest(player.field_70170_p, pos, res);
                ArrayList<BlockPos> sortedTargets = new ArrayList<BlockPos>(res.getHarvestedBlocks());
                this.harvestComparator.refPoint = pos;
                Collections.sort(sortedTargets, this.harvestComparator);
                int maxBlocks = powerStored / Config.darkSteelAxePowerUsePerDamagePointMultiHarvest;
                int numUsedPower = 0;
                for (int i = 0; numUsedPower < maxBlocks && i < sortedTargets.size(); ++i) {
                    if (!this.doMultiHarvest(player, player.field_70170_p, (BlockPos)sortedTargets.get(i), block)) continue;
                    ++numUsedPower;
                }
                return numUsedPower != 0;
            }
        }
        return false;
    }

    private boolean doMultiHarvest(EntityPlayer player, World worldObj, BlockPos bc, Block refBlock) {
        IBlockState bs = worldObj.func_180495_p(bc);
        Block block = bs.func_177230_c();
        bs = bs.func_185899_b((IBlockAccess)worldObj, bc);
        ItemStack held = player.func_184614_ca();
        List itemDrops = block.getDrops((IBlockAccess)worldObj, bc, bs, 0);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)itemDrops, (World)worldObj, (BlockPos)bc, (IBlockState)bs, (int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)held), (float)1.0f, (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)held) != 0 ? 1 : 0) != 0, (EntityPlayer)player);
        worldObj.func_175698_g(bc);
        boolean usedPower = false;
        if (itemDrops != null) {
            for (ItemStack stack : itemDrops) {
                if (!(worldObj.field_73012_v.nextFloat() <= chance)) continue;
                worldObj.func_72838_d((Entity)new EntityItem(worldObj, (double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5, stack.func_77946_l()));
                if (block != refBlock) continue;
                EnergyUpgrade.extractEnergy(player.func_184614_ca(), Config.darkSteelAxePowerUsePerDamagePointMultiHarvest, false);
                usedPower = true;
            }
        }
        return usedPower;
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed evt) {
        if (evt.getEntityPlayer().func_70093_af() && ItemDarkSteelAxe.isEquippedAndPowered(evt.getEntityPlayer(), Config.darkSteelAxePowerUsePerDamagePointMultiHarvest) && this.isLog(evt.getState())) {
            evt.setNewSpeed(evt.getOriginalSpeed() / Config.darkSteelAxeSpeedPenaltyMultiHarvest);
        }
        if (ItemDarkSteelAxe.isEquipped(evt.getEntityPlayer()) && evt.getState().func_185904_a() == Material.field_151584_j) {
            evt.setNewSpeed(6.0f);
        }
    }

    public EnumActionResult func_180614_a(ItemStack item, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, pos, side, hand, hitX, hitY, hitZ);
        }
        return EnumActionResult.PASS;
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelAxePowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(ItemStack stack, int amount) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack);
            return true;
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (ItemDarkSteelPickaxe.isToolEffective(state, stack)) {
            if (Config.darkSteelPickPowerUsePerDamagePoint <= 0 || EnergyUpgrade.getEnergyStored(stack) > 0) {
                return ItemDarkSteelSword.MATERIAL.func_77998_b() + Config.darkSteelAxeEffeciencyBoostWhenPowered;
            }
            return ItemDarkSteelSword.MATERIAL.func_77998_b();
        }
        return super.func_150893_a(stack, state);
    }

    private boolean isLog(IBlockState bs) {
        int[] targetOreId;
        if (this.logOreId == -1) {
            this.logOreId = OreDictionary.getOreID((String)"logWood");
        }
        for (int id : targetOreId = OreDictionary.getOreIDs((ItemStack)new ItemStack(bs.func_177230_c(), 1, bs.func_177230_c().func_176201_c(bs)))) {
            if (this.logOreId != id) continue;
            return true;
        }
        return false;
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnderIO.lang.localize("item.darkSteel_axe.tooltip.multiHarvest"));
            list.add(TextFormatting.WHITE + "+" + Config.darkSteelAxeEffeciencyBoostWhenPowered + " " + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.effPowered"));
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack == null || newStack == null || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    private static class MultiHarvestComparator
    implements Comparator<BlockPos> {
        BlockPos refPoint;

        private MultiHarvestComparator() {
        }

        @Override
        public int compare(BlockPos arg0, BlockPos arg1) {
            double d1 = this.refPoint.func_177954_c((double)arg0.func_177958_n(), (double)arg0.func_177956_o(), (double)arg0.func_177952_p());
            double d2 = this.refPoint.func_177954_c((double)arg1.func_177958_n(), (double)arg1.func_177956_o(), (double)arg1.func_177952_p());
            return MultiHarvestComparator.compare(d1, d2);
        }

        public static int compare(double x, double y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

