/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.buildcraft;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.ICoolant;
import buildcraft.api.fuels.IFuel;
import crazypants.enderio.fluid.FluidFuelRegister;
import crazypants.enderio.fluid.IFluidCoolant;
import crazypants.enderio.fluid.IFluidFuel;
import crazypants.enderio.fluid.IFluidRegister;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BuildCraftFluidRegister
implements IFluidRegister {
    public BuildCraftFluidRegister() throws Exception {
        Class.forName("buildcraft.api.fuels.BuildcraftFuelRegistry");
        FluidFuelRegister.instance.addRegister(this);
    }

    @Override
    public void addCoolant(Fluid fluid, float degreesCoolingPerMB) {
        if (BuildcraftFuelRegistry.coolant != null && BuildcraftFuelRegistry.coolant.getCoolant(fluid) == null) {
            BuildcraftFuelRegistry.coolant.addCoolant(fluid, degreesCoolingPerMB);
        }
    }

    @Override
    public IFluidCoolant getCoolant(Fluid fluid) {
        ICoolant bcCool;
        if (fluid != null && BuildcraftFuelRegistry.coolant != null && (bcCool = BuildcraftFuelRegistry.coolant.getCoolant(fluid)) != null) {
            return new CoolantBC(bcCool);
        }
        return null;
    }

    @Override
    public IFluidCoolant getCoolant(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            return null;
        }
        return this.getCoolant(fluid.getFluid());
    }

    @Override
    public void addFuel(Fluid fluid, int powerPerCycleRF, int totalBurnTime) {
        if (BuildcraftFuelRegistry.fuel != null && BuildcraftFuelRegistry.fuel.getFuel(fluid) == null) {
            BuildcraftFuelRegistry.fuel.addFuel(fluid, powerPerCycleRF, totalBurnTime);
        }
    }

    @Override
    public IFluidFuel getFuel(Fluid fluid) {
        IFuel bcFuel;
        if (fluid == null) {
            return null;
        }
        if (BuildcraftFuelRegistry.fuel != null && (bcFuel = BuildcraftFuelRegistry.fuel.getFuel(fluid)) != null) {
            return new FuelBC(bcFuel);
        }
        return null;
    }

    @Override
    public IFluidFuel getFuel(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            return null;
        }
        return this.getFuel(fluid.getFluid());
    }

    private static class CoolantBC
    extends FluidFuelRegister.CoolantImpl {
        CoolantBC(ICoolant coolant) {
            super(coolant.getFluid(), coolant.getDegreesCoolingPerMB(100.0f));
        }
    }

    private static class FuelBC
    extends FluidFuelRegister.FuelImpl {
        FuelBC(IFuel fuel) {
            super(fuel.getFluid(), fuel.getPowerPerCycle(), fuel.getTotalBurningTime());
        }
    }
}

