/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.diagnostics;

import crazypants.enderio.diagnostics.DiagnosticsRegistry;
import crazypants.enderio.diagnostics.IDiagnosticsTracker;
import java.util.ArrayList;
import java.util.List;

public class ConduitNeighborUpdateTracker
implements IDiagnosticsTracker {
    private final String activityDescription;
    private final List<Object> poses = new ArrayList<Object>();
    private final List<Long> times = new ArrayList<Long>();
    private boolean running = false;

    public ConduitNeighborUpdateTracker(String activityDescription) {
        this.activityDescription = activityDescription;
        DiagnosticsRegistry.register(this);
    }

    @Override
    public String getActivityDescription() {
        return this.activityDescription;
    }

    @Override
    public List<String> getLines() {
        if (this.running) {
            this.stop();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.poses.size(); ++i) {
            Object pos = this.poses.get(i);
            Long time = this.times.get(i);
            result.add(pos + " took " + (time == 0L ? "??? " : time) + "ns");
        }
        if (this.running) {
            result.add("The last entry contains the time to process the crash and will always be significantly higher.");
        }
        return result;
    }

    @Override
    public void start(Object on) {
        this.running = true;
        this.poses.add(on);
        this.times.add(System.nanoTime());
    }

    @Override
    public void stop() {
        long end = System.nanoTime();
        int i = this.times.size() - 1;
        this.times.set(i, end - this.times.get(i));
        this.running = false;
    }

    @Override
    public void discard() {
        DiagnosticsRegistry.discard(this);
    }
}

