/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.RecipeConfigElement;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.Item;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Shapeless
implements RecipeConfigElement {
    private List<Item> items;
    private transient boolean valid;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            if (this.items == null || this.items.isEmpty()) {
                throw new InvalidRecipeConfigException("Not enough items");
            }
            if (this.items.size() > 9) {
                throw new InvalidRecipeConfigException("Too many items");
            }
            this.valid = true;
            for (Item item : this.items) {
                this.valid = this.valid && item.isValid();
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <Shapeless>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (Item item : this.items) {
            item.enforceValidity();
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public Object[] getElements() {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Item item : this.items) {
            elements.add(item.getRecipeObject());
        }
        return elements.toArray();
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("item".equals(name)) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.add(factory.read(new Item(), startElement));
            return true;
        }
        return false;
    }
}

