/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.config.Config;
import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.RecipeConfigElement;
import crazypants.enderio.config.recipes.StaxFactory;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class ConfigReference
implements RecipeConfigElement {
    private String section;
    private String name;
    private boolean value;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.section == null) {
            throw new InvalidRecipeConfigException("Missing section");
        }
        this.section = this.section.toLowerCase(Locale.US);
        if (this.name == null) {
            throw new InvalidRecipeConfigException("Missing name");
        }
        if (!Config.config.hasKey(this.section, this.name)) {
            throw new InvalidRecipeConfigException("Unknown config value '" + this.section + ":" + this.name + "'");
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return Config.config.getCategory(this.section).get(this.name).getBoolean() == this.value;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("section".equals(name)) {
            this.section = value;
            return true;
        }
        if ("name".equals(name)) {
            this.name = value;
            return true;
        }
        if ("value".equals(name)) {
            this.value = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
    }
}

