/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.render.BakedQuadBuilder;
import crazypants.enderio.conduit.render.ConduitBundleRenderManager;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import crazypants.enderio.config.Config;
import crazypants.enderio.paint.YetaUtil;
import crazypants.enderio.render.IBlockStateWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConduitBundleRenderer
extends TileEntitySpecialRenderer<TileConduitBundle> {
    private final List<ConduitRenderer> conduitRenderers = new ArrayList<ConduitRenderer>();
    private final DefaultConduitRenderer dcr = new DefaultConduitRenderer(){

        @Override
        public void initIcons() {
        }
    };

    public void registerRenderer(ConduitRenderer renderer) {
        this.conduitRenderers.add(renderer);
    }

    public void renderTileEntityAt(TileConduitBundle te, double x, double y, double z, float partialTick, int b) {
        TileConduitBundle bundle = te;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (bundle.hasFacade() && bundle.getPaintSource().func_185914_p() && !YetaUtil.isFacadeHidden(bundle, (EntityPlayer)player)) {
            return;
        }
        float brightness = -1.0f;
        boolean hasDynamic = false;
        for (IConduit con : bundle.getConduits()) {
            ConduitRenderer renderer;
            if (!YetaUtil.renderConduit((EntityPlayer)player, con) || !(renderer = this.getRendererForConduit(con)).isDynamic()) continue;
            if (!hasDynamic) {
                hasDynamic = true;
                BlockCoord loc = bundle.getLocation();
                brightness = bundle.getEntity().func_145831_w().func_175642_b(EnumSkyBlock.SKY, loc.getBlockPos());
                RenderUtil.setupLightmapCoords((BlockPos)te.func_174877_v(), (World)te.func_145831_w());
                RenderUtil.bindBlockTexture();
                GlStateManager.func_179108_z();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179103_j((int)7425);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            }
            renderer.renderDynamicEntity(this, bundle, con, x, y, z, partialTick, brightness);
        }
        if (hasDynamic) {
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179133_A();
            GlStateManager.func_179084_k();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179121_F();
        }
    }

    public List<BakedQuad> getGeneralQuads(IBlockStateWrapper state, BlockRenderLayer layer) {
        if (layer != null && layer != BlockRenderLayer.CUTOUT) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        IConduitBundle bundle = (IConduitBundle)state.getTileEntity();
        float brightness = !Config.updateLightingWhenHidingFacades && bundle.hasFacade() ? 1.572888E7f : (float)bundle.getEntity().func_145831_w().func_175642_b(EnumSkyBlock.SKY, bundle.getLocation().getBlockPos());
        this.addConduitQuads(state, bundle, brightness, layer, result);
        return result;
    }

    private void addConduitQuads(IBlockStateWrapper state, IConduitBundle bundle, float brightness, BlockRenderLayer layer, List<BakedQuad> quads) {
        HashSet<EnumFacing> externals = new HashSet<EnumFacing>();
        ArrayList<BoundingBox> wireBounds = new ArrayList<BoundingBox>();
        if (bundle.hasFacade() && state.getYetaDisplayMode().isHideFacades()) {
            wireBounds.add(BoundingBox.UNIT_CUBE);
        }
        for (IConduit con : bundle.getConduits().toArray(new IConduit[0])) {
            if (state.getYetaDisplayMode().renderConduit(con)) {
                ConduitRenderer renderer = this.getRendererForConduit(con);
                renderer.addBakedQuads(this, bundle, con, brightness, layer, quads);
                if (layer == null) continue;
                Set<EnumFacing> extCons = con.getExternalConnections();
                for (EnumFacing dir : extCons) {
                    if (con.getConnectionMode(dir) == ConnectionMode.DISABLED || con.getConnectionMode(dir) == ConnectionMode.NOT_SET) continue;
                    externals.add(dir);
                }
                continue;
            }
            if (con == null) continue;
            Collection<CollidableComponent> components = con.getCollidableComponents();
            for (CollidableComponent component : components) {
                if (layer == null && component.dir != null) continue;
                this.addWireBounds(wireBounds, component);
            }
        }
        List<CollidableComponent> connectors = bundle.getConnectors();
        for (CollidableComponent component : connectors) {
            if (component == null) continue;
            if (component.conduitType != null) {
                IConduit conduit;
                RayTraceResult hit;
                if (layer == null && ((hit = Minecraft.func_71410_x().field_71476_x) == null || !(hit.hitInfo instanceof CollidableComponent) || ((CollidableComponent)hit.hitInfo).conduitType != component.conduitType) || (conduit = bundle.getConduit(component.conduitType)) == null) continue;
                if (state.getYetaDisplayMode().renderConduit(component.conduitType)) {
                    TextureAtlasSprite tex = conduit.getTextureForState(component);
                    if (tex == null) {
                        tex = Minecraft.func_71410_x().func_147117_R().func_174944_f();
                    }
                    BakedQuadBuilder.addBakedQuads(quads, component.bound, tex);
                    continue;
                }
                this.addWireBounds(wireBounds, component);
                continue;
            }
            if (!state.getYetaDisplayMode().getDisplayMode().isAll()) continue;
            TextureAtlasSprite tex = ConduitBundleRenderManager.instance.getConnectorIcon(component.data);
            BakedQuadBuilder.addBakedQuads(quads, component.bound, tex);
        }
        for (BoundingBox wireBound : wireBounds) {
            BakedQuadBuilder.addBakedQuads(quads, wireBound, ConduitBundleRenderManager.instance.getWireFrameIcon());
        }
        for (EnumFacing dir : externals) {
            this.addQuadsForExternalConnection(dir, quads);
        }
        if (quads.isEmpty() && !bundle.hasFacade()) {
            BakedQuadBuilder.addBakedQuads(quads, BoundingBox.UNIT_CUBE.scale(0.1), ConduitBundleRenderManager.instance.getWireFrameIcon());
            BakedQuadBuilder.addBakedQuads(quads, BoundingBox.UNIT_CUBE.scale(0.15), ConduitBundleRenderManager.instance.getWireFrameIcon());
            BakedQuadBuilder.addBakedQuads(quads, BoundingBox.UNIT_CUBE.scale(0.2), ConduitBundleRenderManager.instance.getWireFrameIcon());
            BakedQuadBuilder.addBakedQuads(quads, BoundingBox.UNIT_CUBE.scale(0.25), ConduitBundleRenderManager.instance.getWireFrameIcon());
        }
    }

    private void addWireBounds(List<BoundingBox> wireBounds, CollidableComponent component) {
        if (component.dir != null) {
            double sx = component.dir.func_82601_c() != 0 ? 1.0 : 0.7;
            double sy = component.dir.func_96559_d() != 0 ? 1.0 : 0.7;
            double sz = component.dir.func_82599_e() != 0 ? 1.0 : 0.7;
            wireBounds.add(component.bound.scale(sx, sy, sz));
        } else {
            wireBounds.add(component.bound);
        }
    }

    private void addQuadsForExternalConnection(EnumFacing dir, List<BakedQuad> quads) {
        BoundingBox[] bbs;
        TextureAtlasSprite tex = ConduitBundleRenderManager.instance.getConnectorIcon((Object)ConduitConnectorType.EXTERNAL);
        for (BoundingBox bb : bbs = ConduitGeometryUtil.instance.getExternalConnectorBoundingBoxes(dir)) {
            BakedQuadBuilder.addBakedQuads(quads, bb, tex);
        }
    }

    public ConduitRenderer getRendererForConduit(IConduit conduit) {
        for (ConduitRenderer renderer : this.conduitRenderers) {
            if (!renderer.isRendererForConduit(conduit)) continue;
            return renderer;
        }
        return this.dcr;
    }
}

