/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.conduit.IExtractor;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.machine.RedstoneControlMode;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketExtractMode
extends AbstractConduitPacket<IExtractor>
implements IMessageHandler<PacketExtractMode, IMessage> {
    private EnumFacing dir;
    private RedstoneControlMode mode;
    private DyeColor color;

    public PacketExtractMode() {
    }

    public PacketExtractMode(IExtractor con, EnumFacing dir) {
        super(con.getBundle().getEntity(), con);
        this.dir = dir;
        this.mode = con.getExtractionRedstoneMode(dir);
        this.color = con.getExtractionSignalColor(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.dir == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(this.dir.ordinal());
        }
        buf.writeShort(this.mode.ordinal());
        buf.writeShort(this.color.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ord = buf.readShort();
        this.dir = ord < 0 ? null : EnumFacing.values()[ord];
        this.mode = RedstoneControlMode.values()[buf.readShort()];
        this.color = DyeColor.values()[buf.readShort()];
    }

    public IMessage onMessage(PacketExtractMode message, MessageContext ctx) {
        ((IExtractor)message.getTileCasted(ctx)).setExtractionRedstoneMode(message.mode, message.dir);
        ((IExtractor)message.getTileCasted(ctx)).setExtractionSignalColor(message.dir, message.color);
        IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
        message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
        return null;
    }
}

