/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.ItemConduitFilterContainer;
import crazypants.enderio.conduit.gui.item.SpeciesItemFilterGui;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.SpeciesMode;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpeciesItemFilter
implements IInventory,
IItemFilter {
    private static final boolean DEFAULT_BLACKLIST = false;
    private static final boolean DEFAULT_STICKY = false;
    private static final SpeciesMode DEFAULT_SPECIES_MODE = SpeciesMode.BOTH;
    boolean isBlacklist = false;
    boolean sticky = false;
    SpeciesMode speciesMode = DEFAULT_SPECIES_MODE;
    private ItemStack[] items;
    private String[] primarySpeciesUids;
    private String[] secondarySpeciesUids;

    public void copyFrom(SpeciesItemFilter o) {
        this.isBlacklist = o.isBlacklist;
        this.sticky = o.sticky;
        this.speciesMode = o.speciesMode;
        this.items = o.items;
        this.primarySpeciesUids = o.primarySpeciesUids;
        this.secondarySpeciesUids = o.secondarySpeciesUids;
    }

    public SpeciesItemFilter() {
        this(10);
    }

    private SpeciesItemFilter(int numItems) {
        this.items = new ItemStack[numItems];
        this.primarySpeciesUids = new String[numItems];
        this.secondarySpeciesUids = new String[numItems];
    }

    @Override
    public boolean doesFilterCaptureStack(NetworkedInventory inv, ItemStack item) {
        return this.isSticky() && this.itemMatched(item);
    }

    @Override
    public boolean doesItemPassFilter(NetworkedInventory inv, ItemStack item) {
        return this.doesItemPassFilter(item);
    }

    public boolean doesItemPassFilter(ItemStack item) {
        if (!this.isValid()) {
            return true;
        }
        boolean matched = this.itemMatched(item);
        return this.isBlacklist ? !matched : matched;
    }

    private boolean itemMatched(ItemStack item) {
        if (item == null) {
            return false;
        }
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(item);
        if (speciesRoot == null) {
            return false;
        }
        IIndividual member = speciesRoot.getMember(item);
        if (member == null) {
            return false;
        }
        IGenome genome = member.getGenome();
        String primarySpeciesUid = genome.getPrimary().getUID();
        String secondarySpeciesUid = genome.getSecondary().getUID();
        block5: for (int slot = 0; slot < this.items.length; ++slot) {
            ItemStack slotItem = this.items[slot];
            if (slotItem == null || slotItem.func_77973_b() != item.func_77973_b()) continue;
            switch (this.speciesMode) {
                case BOTH: {
                    if (!this.primarySpeciesUids[slot].equals(primarySpeciesUid) || !this.secondarySpeciesUids[slot].equals(secondarySpeciesUid)) continue block5;
                    return true;
                }
                case PRIMARY: {
                    if (!this.primarySpeciesUids[slot].equals(primarySpeciesUid)) continue block5;
                    return true;
                }
                case SECONDARY: {
                    if (!this.secondarySpeciesUids[slot].equals(secondarySpeciesUid)) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        for (ItemStack item : this.items) {
            if (item == null || AlleleManager.alleleRegistry.getSpeciesRoot(item) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    public void setBlacklist(boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public SpeciesMode getSpeciesMode() {
        return this.speciesMode;
    }

    public void setSpeciesMode(SpeciesMode mode) {
        this.speciesMode = mode;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74757_a("isBlacklist", this.isBlacklist);
        nbtRoot.func_74757_a("sticky", this.sticky);
        nbtRoot.func_74774_a("speciesMode", (byte)this.speciesMode.ordinal());
        int i = 0;
        for (ItemStack item : this.items) {
            if (item != null) {
                nbtRoot.func_74782_a("item" + i, (NBTBase)item.serializeNBT());
            }
            ++i;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemFilterGui getGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        ItemConduitFilterContainer cont = new ItemConduitFilterContainer(itemConduit, gui.getDir(), isInput);
        SpeciesItemFilterGui itemFilterGui = new SpeciesItemFilterGui(gui, cont, !isInput);
        itemFilterGui.createFilterSlots();
        return itemFilterGui;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot) {
        this.isBlacklist = nbtRoot.func_74767_n("isBlacklist");
        this.sticky = nbtRoot.func_74767_n("sticky");
        this.speciesMode = SpeciesMode.values()[nbtRoot.func_74771_c("speciesMode") & 0xFF];
        int numItems = 10;
        this.items = new ItemStack[numItems];
        this.primarySpeciesUids = new String[numItems];
        this.secondarySpeciesUids = new String[numItems];
        for (int i = 0; i < numItems; ++i) {
            NBTBase tag = nbtRoot.func_74781_a("item" + i);
            ItemStack itemStack = null;
            if (tag instanceof NBTTagCompound) {
                itemStack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tag));
            }
            this.setItem(i, itemStack);
        }
    }

    @Nullable
    private ItemStack setItem(int slot, @Nullable ItemStack itemStack) {
        IIndividual member;
        ISpeciesRoot speciesRoot;
        if (slot < 0 || slot >= this.items.length) {
            return null;
        }
        ItemStack prevStack = this.items[slot];
        if (prevStack != null) {
            this.primarySpeciesUids[slot] = null;
            this.secondarySpeciesUids[slot] = null;
        }
        this.items[slot] = itemStack;
        if (itemStack != null && (speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(itemStack)) != null && (member = speciesRoot.getMember(itemStack)) != null) {
            IGenome genome = member.getGenome();
            this.primarySpeciesUids[slot] = genome.getPrimary().getUID();
            this.secondarySpeciesUids[slot] = genome.getSecondary().getUID();
        }
        return prevStack;
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readFromNBT(tag);
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.items.length) {
            return null;
        }
        return this.items[i];
    }

    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack item = this.setItem(fromSlot, null);
        if (item == null) {
            return null;
        }
        item.field_77994_a = 0;
        return item;
    }

    public void func_70299_a(int i, @Nullable ItemStack itemstack) {
        if (itemstack != null) {
            ItemStack copy = itemstack.func_77946_l();
            copy.field_77994_a = 0;
            this.setItem(i, copy);
        } else {
            this.setItem(i, null);
        }
    }

    public ItemStack func_70304_b(int index) {
        return this.setItem(index, null);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.items.length; ++i) {
            this.setItem(i, null);
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return "Species Item Filter";
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(@Nonnull EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(@Nonnull EntityPlayer e) {
    }

    public void func_174886_c(@Nonnull EntityPlayer e) {
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    @Override
    public void createGhostSlots(List<GhostSlot> slots, int xOffset, int yOffset, Runnable cb) {
        int index = 0;
        int numRows = 2;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < 5; ++col) {
                int x = xOffset + col * 18;
                int y = yOffset + row * 20;
                slots.add(new ItemFilterGhostSlot(index, x, y, cb));
                ++index;
            }
        }
    }

    @Override
    public int getSlotCount() {
        return this.func_70302_i_();
    }

    public boolean isDefault() {
        return !this.isValid() && !this.isBlacklist && this.speciesMode == DEFAULT_SPECIES_MODE && !this.sticky;
    }

    public String toString() {
        return "SpeciesItemFilter [speciesMode=" + (Object)((Object)this.speciesMode) + ", items=" + Arrays.toString(this.items) + "]";
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    class ItemFilterGhostSlot
    extends GhostSlot {
        private final int slot;
        private final Runnable cb;

        ItemFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.x = x;
            this.y = y;
            this.slot = slot;
            this.cb = cb;
        }

        public void putStack(ItemStack stack) {
            if (stack != null && AlleleManager.alleleRegistry.getSpeciesRoot(stack) != null) {
                stack = stack.func_77946_l();
                stack.field_77994_a = 1;
                SpeciesItemFilter.this.setItem(this.slot, stack);
            } else {
                SpeciesItemFilter.this.setItem(this.slot, null);
            }
            this.cb.run();
        }

        public ItemStack getStack() {
            return SpeciesItemFilter.this.func_70301_a(this.slot);
        }
    }
}

