/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.BasicItemFilterGui;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.ItemConduitFilterContainer;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.DamageMode;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.util.Prep;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFilter
implements IInventory,
IItemFilter {
    private static final boolean DEFAULT_BLACKLIST = false;
    private static final boolean DEFAULT_META = true;
    private static final boolean DEFAULT_MBT = true;
    private static final boolean DEFAULT_ORE_DICT = false;
    private static final boolean DEFAULT_STICKY = false;
    boolean isBlacklist = false;
    boolean matchMeta = true;
    boolean matchNBT = true;
    boolean useOreDict = false;
    boolean sticky = false;
    DamageMode damageMode = DamageMode.DISABLED;
    ItemStack[] items;
    final List<int[]> oreIds;
    private boolean isAdvanced;
    @Nonnull
    private static final NBTTagCompound EMPTY_NBT = new NBTTagCompound();

    public void copyFrom(ItemFilter o) {
        this.isBlacklist = o.isBlacklist;
        this.matchMeta = o.matchMeta;
        this.matchNBT = o.matchNBT;
        this.useOreDict = o.useOreDict;
        this.sticky = o.sticky;
        this.damageMode = o.damageMode;
        this.items = o.items;
        this.oreIds.clear();
        this.oreIds.addAll(o.oreIds);
        this.isAdvanced = o.isAdvanced;
    }

    public ItemFilter() {
        this(5, false);
    }

    public ItemFilter(boolean advanced) {
        this(advanced ? 10 : 5, advanced);
    }

    private ItemFilter(int numItems, boolean isAdvanced) {
        this.isAdvanced = isAdvanced;
        this.items = new ItemStack[numItems];
        this.oreIds = new ArrayList<int[]>(numItems);
        for (int i = 0; i < numItems; ++i) {
            this.oreIds.add(null);
        }
    }

    @Override
    public boolean doesFilterCaptureStack(NetworkedInventory inv, ItemStack item) {
        return this.isSticky() && this.itemMatched(item);
    }

    @Override
    public boolean doesItemPassFilter(@Nullable NetworkedInventory inv, ItemStack item) {
        return !this.isValid() || this.isBlacklist != this.itemMatched(item);
    }

    private boolean itemMatched(ItemStack item) {
        if (this.damageMode.passesFilter(item)) {
            boolean canPassFilter = this.damageMode != DamageMode.DISABLED;
            for (int i = 0; i < this.items.length; ++i) {
                ItemStack filterStack = this.items[i];
                if (!Prep.isValid(filterStack)) continue;
                if (!(item.func_77973_b() != filterStack.func_77973_b() || this.matchMeta && item.func_77981_g() && item.func_77960_j() != filterStack.func_77960_j() || this.matchNBT && !this.isNBTMatch(item, filterStack))) {
                    return true;
                }
                if (this.useOreDict && this.isOreDicMatch(i, item)) {
                    return true;
                }
                canPassFilter = false;
            }
            return canPassFilter;
        }
        return false;
    }

    private boolean isOreDicMatch(int filterItemIndex, ItemStack item) {
        int[] ids1 = this.getCachedIds(filterItemIndex);
        if (ids1 == null || ids1.length == 0) {
            return false;
        }
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)item);
        if (ids2 == null || ids2.length == 0) {
            return false;
        }
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNBTMatch(ItemStack filter, ItemStack item) {
        return this.getTag(filter).equals((Object)this.getTag(item));
    }

    @Nonnull
    private NBTTagCompound getTag(ItemStack item) {
        if (Prep.isInvalid(item) || !item.func_77942_o()) {
            return EMPTY_NBT;
        }
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt == null || nbt.func_82582_d()) {
            return EMPTY_NBT;
        }
        if (nbt.func_74764_b("GEN")) {
            nbt = nbt.func_74737_b();
            nbt.func_82580_o("GEN");
        }
        return nbt;
    }

    private int[] getCachedIds(int filterItemIndex) {
        int[] res = this.oreIds.get(filterItemIndex);
        if (res == null) {
            ItemStack item = this.items[filterItemIndex];
            if (item == null) {
                res = new int[]{};
            } else {
                res = OreDictionary.getOreIDs((ItemStack)item);
                if (res == null) {
                    res = new int[]{};
                }
            }
            this.oreIds.set(filterItemIndex, res);
        }
        return res;
    }

    @Override
    public boolean isValid() {
        if (this.damageMode != DamageMode.DISABLED) {
            return true;
        }
        for (ItemStack item : this.items) {
            if (item == null) continue;
            return true;
        }
        return false;
    }

    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    public void setBlacklist(boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    public boolean isMatchMeta() {
        return this.matchMeta;
    }

    public void setMatchMeta(boolean matchMeta) {
        this.matchMeta = matchMeta;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNbt) {
        this.matchNBT = matchNbt;
    }

    public boolean isUseOreDict() {
        return this.useOreDict;
    }

    public void setUseOreDict(boolean useOreDict) {
        this.useOreDict = useOreDict;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public DamageMode getDamageMode() {
        return this.damageMode;
    }

    public void setDamageMode(DamageMode damageMode) {
        this.damageMode = damageMode;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74757_a("isBlacklist", this.isBlacklist);
        nbtRoot.func_74757_a("matchMeta", this.matchMeta);
        nbtRoot.func_74757_a("matchNBT", this.matchNBT);
        nbtRoot.func_74757_a("useOreDict", this.useOreDict);
        nbtRoot.func_74757_a("sticky", this.sticky);
        nbtRoot.func_74757_a("isAdvanced", this.isAdvanced);
        nbtRoot.func_74774_a("damageMode", (byte)this.damageMode.ordinal());
        int i = 0;
        for (ItemStack item : this.items) {
            NBTTagCompound itemTag = new NBTTagCompound();
            if (item != null) {
                item.func_77955_b(itemTag);
                nbtRoot.func_74782_a("item" + i, (NBTBase)itemTag);
            }
            ++i;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemFilterGui getGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        ItemConduitFilterContainer cont = new ItemConduitFilterContainer(itemConduit, gui.getDir(), isInput);
        BasicItemFilterGui basicItemFilterGui = new BasicItemFilterGui(gui, cont, !isInput);
        basicItemFilterGui.createFilterSlots();
        return basicItemFilterGui;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot) {
        int i;
        this.isBlacklist = nbtRoot.func_74767_n("isBlacklist");
        this.matchMeta = nbtRoot.func_74767_n("matchMeta");
        this.matchNBT = nbtRoot.func_74767_n("matchNBT");
        this.useOreDict = nbtRoot.func_74767_n("useOreDict");
        this.sticky = nbtRoot.func_74767_n("sticky");
        this.isAdvanced = nbtRoot.func_74767_n("isAdvanced");
        this.damageMode = nbtRoot.func_74764_b("damageMode") ? DamageMode.values()[nbtRoot.func_74771_c("damageMode") & 0xFF] : DamageMode.DISABLED;
        int numItems = this.isAdvanced ? 10 : 5;
        this.items = new ItemStack[numItems];
        this.oreIds.clear();
        for (i = 0; i < numItems; ++i) {
            this.oreIds.add(null);
        }
        for (i = 0; i < numItems; ++i) {
            NBTBase tag = nbtRoot.func_74781_a("item" + i);
            this.items[i] = tag instanceof NBTTagCompound ? ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tag)) : null;
        }
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readFromNBT(tag);
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.items.length) {
            return null;
        }
        return this.items[i];
    }

    public ItemStack func_70298_a(int fromSlot, int amount) {
        this.oreIds.set(fromSlot, null);
        ItemStack item = this.items[fromSlot];
        this.items[fromSlot] = null;
        if (item == null) {
            return null;
        }
        item.field_77994_a = 0;
        return item;
    }

    public void func_70299_a(int i, @Nullable ItemStack itemstack) {
        if (itemstack != null) {
            this.items[i] = itemstack.func_77946_l();
            this.items[i].field_77994_a = 0;
        } else {
            this.items[i] = null;
        }
        this.oreIds.set(i, null);
    }

    public ItemStack func_70304_b(int index) {
        if (index < 0 || index >= this.items.length) {
            return null;
        }
        ItemStack res = this.items[index];
        this.items[index] = null;
        return res;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = null;
        }
    }

    public String func_70005_c_() {
        return "Item Filter";
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer e) {
    }

    public void func_174886_c(EntityPlayer e) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public void createGhostSlots(List<GhostSlot> slots, int xOffset, int yOffset, Runnable cb) {
        int topY = yOffset;
        int leftX = xOffset;
        int index = 0;
        int numRows = this.isAdvanced ? 2 : 1;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < 5; ++col) {
                int x = leftX + col * 18;
                int y = topY + row * 20;
                slots.add(new ItemFilterGhostSlot(index, x, y, cb));
                ++index;
            }
        }
    }

    @Override
    public int getSlotCount() {
        return this.func_70302_i_();
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public boolean isDefault() {
        return !this.isAdvanced && !this.isValid() && !this.isBlacklist && this.matchMeta && this.matchNBT && !this.useOreDict && !this.sticky;
    }

    public String toString() {
        return "ItemFilter [isAdvanced=" + this.isAdvanced + ", items=" + Arrays.toString(this.items) + "]";
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    class ItemFilterGhostSlot
    extends GhostSlot {
        private final int slot;
        private final Runnable cb;

        ItemFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.x = x;
            this.y = y;
            this.slot = slot;
            this.cb = cb;
        }

        public void putStack(ItemStack stack) {
            if (stack != null) {
                stack = stack.func_77946_l();
                stack.field_77994_a = 1;
            }
            ItemFilter.this.items[this.slot] = stack;
            this.cb.run();
        }

        public ItemStack getStack() {
            return ItemFilter.this.items[this.slot];
        }
    }
}

