/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.ExistingItemFilterGui;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ExistingItemFilter
implements IItemFilter {
    boolean matchMeta = true;
    boolean useOreDict = false;
    boolean convertOreDict = false;
    boolean matchNBT = false;
    boolean sticky = false;
    private boolean blacklist = false;
    List<ItemStack> snapshot = null;

    @Override
    public boolean doesItemPassFilter(NetworkedInventory ni, ItemStack item) {
        if (item == null) {
            return false;
        }
        if (this.snapshot != null) {
            return this.isStackInSnapshot(item) == !this.blacklist;
        }
        if (ni != null && ni.getInventory() != null) {
            return this.isStackInInventory(ni, item) == !this.blacklist;
        }
        return false;
    }

    private boolean isStackInInventory(NetworkedInventory ni, ItemStack item) {
        IItemHandler inventory = ni.getInventory();
        if (inventory != null) {
            int numSlots = inventory.getSlots();
            for (int i = 0; i < numSlots; ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (!this.stackEqual(item, stack)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isStackInSnapshot(ItemStack item) {
        for (ItemStack stack : this.snapshot) {
            if (!this.stackEqual(item, stack)) continue;
            return true;
        }
        return false;
    }

    boolean stackEqual(ItemStack toInsert, ItemStack existing) {
        if (toInsert == null || existing == null) {
            return false;
        }
        boolean matched = false;
        if (this.useOreDict) {
            matched = this.isSameOreRegistered(existing, toInsert);
        }
        if (!matched) {
            boolean bl = matched = Item.func_150891_b((Item)toInsert.func_77973_b()) == Item.func_150891_b((Item)existing.func_77973_b());
            if (matched && this.matchMeta) {
                boolean bl2 = matched = toInsert.func_77952_i() == existing.func_77952_i();
            }
            if (matched && this.matchNBT) {
                matched = ItemStack.func_77970_a((ItemStack)toInsert, (ItemStack)existing);
            }
        }
        return matched;
    }

    private boolean isSameOreRegistered(ItemStack existing, ItemStack toInsert) {
        int[] existingIds = OreDictionary.getOreIDs((ItemStack)existing);
        int[] toInsertIds = OreDictionary.getOreIDs((ItemStack)toInsert);
        boolean matched = false;
        for (int i = 0; i < existingIds.length && !matched; ++i) {
            int existingId = existingIds[i];
            matched = existingId != -1 && this.contains(toInsertIds, existingId);
        }
        return matched;
    }

    private boolean contains(int[] ar, int val) {
        for (int i : ar) {
            if (i != val) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesFilterCaptureStack(NetworkedInventory inv, ItemStack item) {
        boolean res = this.sticky && this.doesItemPassFilter(inv, item);
        return res;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void createGhostSlots(List<GhostSlot> slots, int xOffset, int yOffset, Runnable cb) {
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    public void setSnapshot(NetworkedInventory ni) {
        this.snapshot = new ArrayList<ItemStack>();
        this.mergeSnapshot(ni);
    }

    public void mergeSnapshot(NetworkedInventory ni) {
        IItemHandler inventory;
        if (this.snapshot == null) {
            this.snapshot = new ArrayList<ItemStack>();
        }
        if ((inventory = ni.getInventory()) != null) {
            int numSlots = inventory.getSlots();
            for (int i = 0; i < numSlots; ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack == null || this.isStackInSnapshot(stack)) continue;
                this.snapshot.add(stack);
            }
        }
    }

    public boolean mergeSnapshot(IInventory inventory) {
        if (this.snapshot == null) {
            this.snapshot = new ArrayList<ItemStack>();
        }
        int size = inventory.func_70302_i_();
        boolean added = false;
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || this.isStackInSnapshot(stack)) continue;
            this.snapshot.add(stack);
            added = true;
        }
        return added;
    }

    public List<ItemStack> getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(List<ItemStack> snapshot) {
        this.snapshot = snapshot;
    }

    public boolean isMatchMeta() {
        return this.matchMeta;
    }

    public void setMatchMeta(boolean matchMeta) {
        this.matchMeta = matchMeta;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNbt) {
        this.matchNBT = matchNbt;
    }

    public boolean isUseOreDict() {
        return this.useOreDict;
    }

    public void setUseOreDict(boolean useOreDict) {
        this.useOreDict = useOreDict;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public void setBlacklist(boolean value) {
        this.blacklist = value;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemFilterGui getGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        return new ExistingItemFilterGui(gui, itemConduit, isInput);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot) {
        this.readSettingsFromNBT(nbtRoot);
        if (nbtRoot.func_74764_b("snapshot")) {
            this.snapshot = new ArrayList<ItemStack>();
            NBTTagList itemList = (NBTTagList)nbtRoot.func_74781_a("snapshot");
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = itemList.func_150305_b(i);
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
                if (itemStack == null) continue;
                this.snapshot.add(itemStack);
            }
        } else {
            this.snapshot = null;
        }
    }

    protected void readSettingsFromNBT(NBTTagCompound nbtRoot) {
        this.matchMeta = nbtRoot.func_74767_n("matchMeta");
        this.matchNBT = nbtRoot.func_74767_n("matchNBT");
        this.useOreDict = nbtRoot.func_74767_n("useOreDict");
        this.sticky = nbtRoot.func_74767_n("sticky");
        this.blacklist = nbtRoot.func_74767_n("blacklist");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        this.writeSettingToNBT(nbtRoot);
        if (this.snapshot != null) {
            NBTTagList itemList = new NBTTagList();
            for (ItemStack item : this.snapshot) {
                if (item == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                item.func_77955_b(itemTag);
                itemList.func_74742_a((NBTBase)itemTag);
            }
            nbtRoot.func_74782_a("snapshot", (NBTBase)itemList);
        }
    }

    protected void writeSettingToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74757_a("matchMeta", this.matchMeta);
        nbtRoot.func_74757_a("matchNBT", this.matchNBT);
        nbtRoot.func_74757_a("useOreDict", this.useOreDict);
        nbtRoot.func_74757_a("sticky", this.sticky);
        nbtRoot.func_74757_a("blacklist", this.blacklist);
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        NBTTagCompound settingsTag = new NBTTagCompound();
        this.writeSettingToNBT(settingsTag);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)settingsTag, (ByteBuf)buf);
        buf.writeInt(this.snapshot == null ? 0 : this.snapshot.size());
        if (this.snapshot == null) {
            return;
        }
        for (ItemStack item : this.snapshot) {
            NBTTagCompound itemRoot = new NBTTagCompound();
            item.func_77955_b(itemRoot);
            NetworkUtil.writeNBTTagCompound((NBTTagCompound)itemRoot, (ByteBuf)buf);
        }
    }

    @Override
    public void readFromByteBuf(ByteBuf buf) {
        NBTTagCompound settingsTag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readSettingsFromNBT(settingsTag);
        int numItems = buf.readInt();
        if (numItems == 0) {
            this.snapshot = null;
            return;
        }
        this.snapshot = new ArrayList<ItemStack>(numItems);
        for (int i = 0; i < numItems; ++i) {
            NBTTagCompound itemTag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            if (item == null) continue;
            this.snapshot.add(item);
        }
    }
}

