/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.recipe.LivingArmourDowngradeRecipe;
import WayofTime.bloodmagic.api.registry.LivingArmourDowngradeRecipeRegistry;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class RitualLivingArmourDowngrade
extends Ritual {
    public static final String DOWNGRADE_RANGE = "containmentRange";
    private int internalTimer = 0;

    public RitualLivingArmourDowngrade() {
        super("ritualDowngrade", 0, 10000, "ritual.BloodMagic.downgradeRitual");
        this.addBlockRange(DOWNGRADE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-3, 0, -3), 7));
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos masterPos = masterRitualStone.getBlockPos();
        AreaDescriptor downgradeRange = this.getBlockRange(DOWNGRADE_RANGE);
        boolean isActivatorPresent = false;
        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, downgradeRange.getAABB(masterRitualStone.getBlockPos()))) {
            if (!player.func_110124_au().toString().equals(masterRitualStone.getOwner())) continue;
            isActivatorPresent = true;
            ItemStack keyStack = this.getStackFromItemFrame(world, masterPos, masterRitualStone.getDirection());
            if (keyStack == null) {
                return;
            }
            List<ITextComponent> textList = LivingArmourDowngradeRecipeRegistry.getDialogForProcessTick(keyStack, this.internalTimer);
            if (textList != null) {
                ChatUtil.sendChat(player, textList.toArray(new ITextComponent[textList.size()]));
            }
            ++this.internalTimer;
            if (player.func_70093_af()) {
                double distance2 = masterPos.func_177972_a(EnumFacing.UP).func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                if (distance2 > 1.0) {
                    return;
                }
                BlockPos chestPos = masterPos.func_177967_a(masterRitualStone.getDirection(), 2).func_177972_a(EnumFacing.UP);
                TileEntity tile = world.func_175625_s(chestPos);
                if (tile == null) {
                    return;
                }
                IItemHandler inv = Utils.getInventory(tile, null);
                if (inv != null) {
                    ArrayList<ItemStack> recipeList = new ArrayList<ItemStack>();
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        ItemStack invStack = inv.getStackInSlot(i);
                        if (invStack == null) continue;
                        recipeList.add(invStack);
                    }
                    LivingArmourDowngradeRecipe recipe = LivingArmourDowngradeRecipeRegistry.getMatchingRecipe(keyStack, recipeList, world, masterPos);
                    if (recipe != null) {
                        ItemStack chestStack;
                        LivingArmour armour;
                        LivingArmourUpgrade upgrade = recipe.getRecipeOutput();
                        if (LivingArmour.hasFullSet(player) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null && armour.canApplyUpgrade(player, upgrade) && armour.upgradeArmour(player, upgrade)) {
                            ItemLivingArmour.setLivingArmour(chestStack, armour);
                            recipe.consumeInventory(inv);
                            EntityLightningBolt lightning = new EntityLightningBolt(world, (double)chestPos.func_177958_n(), (double)chestPos.func_177956_o(), (double)chestPos.func_177952_p(), true);
                            world.func_72838_d((Entity)lightning);
                            masterRitualStone.setActive(false);
                        }
                    }
                }
            }
            return;
        }
        if (!isActivatorPresent) {
            this.internalTimer = 0;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.internalTimer = tag.func_74762_e("internalTimer");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("internalTimer", this.internalTimer);
    }

    public ItemStack getStackFromItemFrame(World world, BlockPos masterPos, EnumFacing direction) {
        BlockPos offsetPos = new BlockPos(0, 3, 0);
        offsetPos = offsetPos.func_177967_a(direction, 2);
        AxisAlignedBB bb = new AxisAlignedBB(masterPos.func_177971_a((Vec3i)offsetPos));
        List frames = world.func_72872_a(EntityItemFrame.class, bb);
        for (EntityItemFrame frame : frames) {
            if (frame.func_82335_i() == null) continue;
            return frame.func_82335_i();
        }
        return null;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addRune(components, 0, 0, -1, EnumRuneType.AIR);
        this.addRune(components, 0, 0, -2, EnumRuneType.DUSK);
        this.addRune(components, 0, 1, -3, EnumRuneType.DUSK);
        this.addRune(components, 0, 2, -3, EnumRuneType.BLANK);
        this.addRune(components, 0, 3, -3, EnumRuneType.BLANK);
        this.addRune(components, 0, 1, -4, EnumRuneType.FIRE);
        for (int i = 1; i <= 3; ++i) {
            this.addRune(components, 0, 0, i, EnumRuneType.AIR);
        }
        for (int sgn = -1; sgn <= 1; sgn += 2) {
            this.addRune(components, sgn, 0, 4, EnumRuneType.AIR);
            this.addRune(components, sgn * 2, 0, 2, EnumRuneType.AIR);
            this.addRune(components, sgn * 3, 0, 2, EnumRuneType.AIR);
            this.addRune(components, sgn * 3, 0, 3, EnumRuneType.AIR);
            this.addRune(components, sgn * 1, 0, 0, EnumRuneType.EARTH);
            this.addRune(components, sgn * 1, 0, 1, EnumRuneType.EARTH);
            this.addRune(components, sgn * 2, 0, -1, EnumRuneType.FIRE);
            this.addRune(components, sgn * 2, 0, -2, EnumRuneType.FIRE);
            this.addRune(components, sgn * 3, 0, -2, EnumRuneType.FIRE);
            this.addRune(components, sgn * 3, 0, -3, EnumRuneType.FIRE);
            this.addRune(components, sgn * 3, 0, -4, EnumRuneType.FIRE);
            this.addRune(components, sgn * 1, 1, -1, EnumRuneType.AIR);
            this.addRune(components, sgn * 1, 1, -2, EnumRuneType.AIR);
            this.addRune(components, sgn * 1, 1, -4, EnumRuneType.FIRE);
            this.addRune(components, sgn * 2, 1, -4, EnumRuneType.FIRE);
            this.addRune(components, sgn * 1, 0, -3, EnumRuneType.EARTH);
            this.addRune(components, sgn * 1, 0, -4, EnumRuneType.EARTH);
            this.addRune(components, sgn * 1, 0, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn * 1, 1, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn * 1, 2, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn * 1, 3, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn * 1, 3, -4, EnumRuneType.EARTH);
        }
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualLivingArmourDowngrade();
    }
}

