/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.upgrade;

import WayofTime.bloodmagic.api.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class LivingArmourUpgradeJump
extends LivingArmourUpgrade {
    public static final int[] costs = new int[]{3, 6, 11, 23, 37, 50, 70, 100, 140, 200};
    public static final double[] jumpModifier = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.7, 0.9, 1.1, 1.3, 1.5};
    public static final double[] fallModifier = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.75, 0.8, 0.85};

    public LivingArmourUpgradeJump(int level) {
        super(level);
    }

    public double getJumpModifier() {
        return jumpModifier[this.level];
    }

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.upgrade.jump";
    }

    @Override
    public int getMaxTier() {
        return 10;
    }

    @Override
    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
        double motionY;
        if (!world.field_72995_K && (motionY = player.field_70181_x) < 0.0) {
            player.field_70143_R = (float)Math.max(0.0, (double)player.field_70143_R + motionY * fallModifier[this.level]);
        }
    }

    @Override
    public int getCostOfUpgrade() {
        return costs[this.level];
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public String getUnlocalizedName() {
        return tooltipBase + "jump";
    }
}

