/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemSigilVoid
extends ItemSigilBase {
    public ItemSigilVoid() {
        super("void", 50);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K && !this.isUnusable(stack)) {
            RayTraceResult rayTrace = this.func_77621_a(world, player, true);
            if (rayTrace != null) {
                ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)rayTrace);
                if (ret != null) {
                    return ret;
                }
                if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                    BlockPos blockpos = rayTrace.func_178782_a();
                    if (!world.func_175660_a(player, blockpos)) {
                        return super.func_77659_a(stack, world, player, hand);
                    }
                    if (!player.func_175151_a(blockpos.func_177972_a(rayTrace.field_178784_b), rayTrace.field_178784_b, stack)) {
                        return super.func_77659_a(stack, world, player, hand);
                    }
                    if (!player.func_175151_a(blockpos, rayTrace.field_178784_b, stack)) {
                        return super.func_77659_a(stack, world, player, hand);
                    }
                    if (world.func_180495_p(blockpos).func_177230_c().func_149688_o(world.func_180495_p(blockpos)).func_76224_d() && NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, this.getLpUsed())) {
                        world.func_175698_g(blockpos);
                        return super.func_77659_a(stack, world, player, hand);
                    }
                }
            } else {
                return super.func_77659_a(stack, world, player, hand);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.setUnusable(stack, !NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, this.getLpUsed()));
            }
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (PlayerHelper.isFakePlayer(player)) {
            return EnumActionResult.FAIL;
        }
        if (world.field_72995_K || player.func_70093_af() || this.isUnusable(stack)) {
            return EnumActionResult.FAIL;
        }
        if (!world.canMineBlockBody(player, blockPos)) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile instanceof IFluidHandler) {
            FluidStack amount = ((IFluidHandler)tile).drain(side, 1000, false);
            if (amount != null && amount.amount > 0 && NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage(player, this.getLpUsed())) {
                ((IFluidHandler)tile).drain(side, 1000, true);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        BlockPos newPos = blockPos.func_177972_a(side);
        if (!player.func_175151_a(newPos, side, stack)) {
            return EnumActionResult.FAIL;
        }
        if (world.func_180495_p(newPos).func_177230_c() instanceof IFluidBlock && NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage(player, this.getLpUsed())) {
            world.func_175698_g(newPos);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }
}

