/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.item.sigil.ItemSigilToggleableBase;
import WayofTime.bloodmagic.registry.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemSigilPhantomBridge
extends ItemSigilToggleableBase {
    private Map<EntityPlayer, Pair<Double, Double>> prevPositionMap = new HashMap<EntityPlayer, Pair<Double, Double>>();
    private double expansionFactor = 2.0;
    private int range = 3;

    public ItemSigilPhantomBridge() {
        super("phantomBridge", 100);
    }

    @Override
    public void onSigilUpdate(ItemStack stack, World world, EntityPlayer player, int itemSlot, boolean isSelected) {
        double playerVelZ;
        Pair<Double, Double> prevPosition;
        double playerVelX;
        double totalVel;
        if (PlayerHelper.isFakePlayer(player)) {
            return;
        }
        if (!this.prevPositionMap.containsKey(player)) {
            this.prevPositionMap.put(player, (Pair<Double, Double>)Pair.of((Object)player.field_70165_t, (Object)player.field_70161_v));
        }
        if (!(player.field_70122_E || player.func_184218_aH() || player.func_70093_af())) {
            this.prevPositionMap.put(player, (Pair<Double, Double>)Pair.of((Object)player.field_70165_t, (Object)player.field_70161_v));
            return;
        }
        int verticalOffset = -1;
        if (player.func_70093_af()) {
            --verticalOffset;
        }
        if ((totalVel = Math.sqrt((playerVelX = player.field_70165_t - (Double)(prevPosition = this.prevPositionMap.get(player)).getLeft()) * playerVelX + (playerVelZ = player.field_70161_v - (Double)prevPosition.getRight()) * playerVelZ)) > 2.0) {
            playerVelX = 0.0;
            playerVelZ = 0.0;
            totalVel = 0.0;
        }
        BlockPos playerPos = player.func_180425_c();
        int posX = playerPos.func_177958_n();
        int posY = playerPos.func_177956_o();
        int posZ = playerPos.func_177952_p();
        double offsetPosX = (double)posX + this.expansionFactor * playerVelX;
        double offsetPosZ = (double)posZ + this.expansionFactor * playerVelZ;
        double avgX = ((double)posX + offsetPosX) / 2.0;
        double avgZ = ((double)posZ + offsetPosZ) / 2.0;
        double C = 2.0 * ((double)this.range + this.expansionFactor * totalVel) + 1.0;
        int truncC = (int)C;
        for (int ix = -truncC; ix <= truncC; ++ix) {
            for (int iz = -truncC; iz <= truncC; ++iz) {
                BlockPos blockPos;
                if (ItemSigilPhantomBridge.computeEllipse((double)ix + avgX, (double)iz + avgZ, posX, posZ, offsetPosX, offsetPosZ) > C || !world.func_175623_d(blockPos = new BlockPos(ix + posX, posY + verticalOffset, iz + posZ))) continue;
                world.func_175656_a(blockPos, ModBlocks.PHANTOM_BLOCK.func_176223_P());
            }
        }
        this.prevPositionMap.put(player, (Pair<Double, Double>)Pair.of((Object)player.field_70165_t, (Object)player.field_70161_v));
    }

    public static double computeEllipse(double x, double z, double focusX1, double focusZ1, double focusX2, double focusZ2) {
        return Math.sqrt((x - focusX1) * (x - focusX1) + (z - focusZ1) * (z - focusZ1)) + Math.sqrt((x - focusX2) * (x - focusX2) + (z - focusZ2) * (z - focusZ2));
    }
}

