/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.mob;

import WayofTime.bloodmagic.entity.ai.EntityAIMimicReform;
import WayofTime.bloodmagic.entity.mob.EntityDemonBase;
import WayofTime.bloodmagic.registry.ModBlocks;
import WayofTime.bloodmagic.tile.TileMimic;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityMimic
extends EntityDemonBase {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityMimic.class, (DataSerializer)DataSerializers.field_187191_a);
    public boolean dropItemsOnBreak = true;
    public NBTTagCompound tileTag = new NBTTagCompound();
    public int metaOfReplacedBlock = 0;
    public int playerCheckRadius = 5;

    public EntityMimic(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.9f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISpiderAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMimicReform(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AISpiderTarget<EntityPlayer>(this, EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, new AISpiderTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("dropItemsOnBreak", this.dropItemsOnBreak);
        tag.func_74782_a("tileTag", (NBTBase)this.tileTag);
        tag.func_74768_a("metaOfReplacedBlock", this.metaOfReplacedBlock);
        tag.func_74768_a("playerCheckRadius", this.playerCheckRadius);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.dropItemsOnBreak = tag.func_74767_n("dropItemsOnBreak");
        this.tileTag = tag.func_74775_l("tileTag");
        this.metaOfReplacedBlock = tag.func_74762_e("metaOfReplacedBlock");
        this.playerCheckRadius = tag.func_74762_e("playerCheckRadius");
    }

    public ItemStack getMimicItemStack() {
        return this.func_184582_a(EntityEquipmentSlot.CHEST);
    }

    public void setMimicItemStack(ItemStack stack) {
        this.func_184201_a(EntityEquipmentSlot.CHEST, stack);
    }

    public boolean spawnHeldBlockOnDeath(World world, BlockPos pos) {
        return world.func_175623_d(pos) && TileMimic.replaceMimicWithBlockActual(world, pos, this.getMimicItemStack(), this.tileTag, this.metaOfReplacedBlock);
    }

    public boolean spawnMimicBlockAtPosition(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            IBlockState mimicState = ModBlocks.MIMIC.func_176203_a(4);
            world.func_180501_a(pos, mimicState, 3);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileMimic) {
                TileMimic mimic = (TileMimic)tile;
                mimic.metaOfReplacedBlock = this.metaOfReplacedBlock;
                mimic.tileTag = this.tileTag;
                mimic.func_70299_a(0, this.getMimicItemStack());
                mimic.dropItemsOnBreak = this.dropItemsOnBreak;
                mimic.refreshTileEntity();
            }
            return true;
        }
        return false;
    }

    public void initializeMimic(ItemStack heldStack, NBTTagCompound tileTag, boolean dropItemsOnBreak, int metaOfReplacedBlock, int playerCheckRadius, BlockPos homePosition) {
        this.setMimicItemStack(heldStack);
        this.tileTag = tileTag;
        this.dropItemsOnBreak = dropItemsOnBreak;
        this.metaOfReplacedBlock = metaOfReplacedBlock;
        this.playerCheckRadius = playerCheckRadius;
        this.func_175449_a(homePosition, 2);
    }

    public boolean reformIntoMimicBlock(BlockPos centerPos) {
        int horizontalRadius = 1;
        int verticalRadius = 1;
        for (int hR = 0; hR <= horizontalRadius; ++hR) {
            for (int vR = 0; vR <= verticalRadius; ++vR) {
                for (int i = -hR; i <= hR; ++i) {
                    for (int k = -hR; k <= hR; ++k) {
                        for (int j = -vR; j <= vR; j += 2 * vR + (vR > 0 ? 0 : 1)) {
                            if (Math.abs(i) != hR && Math.abs(k) != hR) continue;
                            BlockPos newPos = centerPos.func_177982_a(i, j, k);
                            if (!this.spawnMimicBlockAtPosition(this.func_130014_f_(), newPos)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.func_130014_f_().field_72995_K) {
            BlockPos centerPos = this.func_180425_c();
            int horizontalRadius = 1;
            int verticalRadius = 1;
            for (int hR = 0; hR <= horizontalRadius; ++hR) {
                for (int vR = 0; vR <= verticalRadius; ++vR) {
                    for (int i = -hR; i <= hR; ++i) {
                        for (int k = -hR; k <= hR; ++k) {
                            for (int j = -vR; j <= vR; j += 2 * vR + (vR > 0 ? 0 : 1)) {
                                if (Math.abs(i) != hR && Math.abs(k) != hR) continue;
                                BlockPos newPos = centerPos.func_177982_a(i, j, k);
                                if (!this.spawnHeldBlockOnDeath(this.func_130014_f_(), newPos)) continue;
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    public double func_70042_X() {
        return this.field_70131_O * 0.5f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_175659_aa() == EnumDifficulty.PEACEFUL && this.reformIntoMimicBlock(this.func_180425_c())) {
            this.func_70106_y();
        }
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187821_fM;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() != MobEffects.field_76436_u && super.func_70687_e(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public float func_70047_e() {
        return 0.65f;
    }

    static class AISpiderTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AISpiderTarget(EntityMimic spider, Class<T> classTarget) {
            super((EntityCreature)spider, classTarget, true);
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }

    static class AISpiderAttack
    extends EntityAIAttackMelee {
        public AISpiderAttack(EntityMimic spider) {
            super((EntityCreature)spider, 1.0, true);
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

