/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compress;

import WayofTime.bloodmagic.api.compress.CompressionHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BaseCompressionHandler
extends CompressionHandler {
    private final ItemStack required;
    private final ItemStack result;
    private final int leftover;

    public BaseCompressionHandler(ItemStack requested, ItemStack result, int leftover) {
        this.required = requested;
        this.result = result;
        this.leftover = leftover;
    }

    public ItemStack getResultStack() {
        return this.result.func_77946_l();
    }

    public ItemStack getRequiredStack() {
        return this.required.func_77946_l();
    }

    @Override
    public ItemStack compressInventory(ItemStack[] inv, World world) {
        int remaining = this.getRemainingNeeded(inv);
        if (remaining <= 0) {
            this.drainInventory(inv);
            return this.getResultStack();
        }
        return null;
    }

    public int getRemainingNeeded(ItemStack[] inv) {
        return this.iterateThroughInventory(inv, false);
    }

    public int drainInventory(ItemStack[] inv) {
        return this.iterateThroughInventory(inv, true);
    }

    public int iterateThroughInventory(ItemStack[] inv, boolean doDrain) {
        int needed = this.required.field_77994_a;
        int kept = this.getLeftover();
        int i = -1;
        for (ItemStack invStack : inv) {
            int remainingFromStack;
            ++i;
            if (invStack == null || !invStack.func_77969_a(this.required) || !(invStack.func_77978_p() == null ? this.required.func_77978_p() == null : invStack.func_77978_p().equals((Object)this.required.func_77978_p()))) continue;
            int stackSize = invStack.field_77994_a;
            int used = 0;
            if (kept > 0) {
                remainingFromStack = Math.max(stackSize - kept, 0);
                used += stackSize - remainingFromStack;
            }
            if ((kept -= used) <= 0 && needed > 0) {
                remainingFromStack = Math.max(stackSize - used - needed, 0);
                if (doDrain) {
                    invStack.field_77994_a = remainingFromStack + used;
                    if (invStack.field_77994_a <= 0) {
                        inv[i] = null;
                    }
                }
                needed -= stackSize - used - remainingFromStack;
            }
            if (needed > 0) continue;
            return 0;
        }
        return needed;
    }

    public int getLeftover() {
        return this.leftover;
    }
}

