/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.event;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SoulNetworkEvent
extends Event {
    public final String ownerUUID;
    public int syphon;

    public SoulNetworkEvent(String ownerUUID, int syphon) {
        this.ownerUUID = ownerUUID;
        this.syphon = syphon;
    }

    @Cancelable
    public static class ItemDrainNetworkEvent
    extends PlayerDrainNetworkEvent {
        @Nullable
        public final ItemStack itemStack;
        public float damageAmount;

        public ItemDrainNetworkEvent(EntityPlayer player, String ownerNetwork, @Nullable ItemStack itemStack, int drainAmount) {
            super(player, ownerNetwork, drainAmount);
            this.itemStack = itemStack;
            this.damageAmount = (float)drainAmount / 100.0f;
        }
    }

    @Cancelable
    public static class PlayerDrainNetworkEvent
    extends SoulNetworkEvent {
        public final EntityPlayer player;
        public boolean shouldDamage = false;

        public PlayerDrainNetworkEvent(EntityPlayer player, String ownerNetwork, int drainAmount) {
            super(ownerNetwork, drainAmount);
            this.player = player;
        }
    }

    @Cancelable
    public static class ItemDrainInContainerEvent
    extends SoulNetworkEvent {
        public ItemStack stack;

        public ItemDrainInContainerEvent(ItemStack stack, String ownerName, int syphon) {
            super(ownerName, syphon);
            this.stack = stack;
        }
    }
}

