/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockStack {
    private final Block block;
    private final int meta;
    private final IBlockState state;

    public BlockStack(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        this.state = block.func_176203_a(meta);
    }

    public BlockStack(Block block) {
        this(block, 0);
    }

    public static BlockStack getStackFromPos(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return new BlockStack(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.block, 1, this.meta);
    }

    public String toString() {
        return this.getBlock().getRegistryName() + ":" + this.getMeta();
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public IBlockState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockStack)) {
            return false;
        }
        BlockStack other = (BlockStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Block this$block = this.getBlock();
        Block other$block = other.getBlock();
        if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
            return false;
        }
        return this.getMeta() == other.getMeta();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockStack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Block $block = this.getBlock();
        result = result * 59 + ($block == null ? 43 : $block.hashCode());
        result = result * 59 + this.getMeta();
        return result;
    }
}

