/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.alchemyArray;

import WayofTime.bloodmagic.api.alchemyCrafting.AlchemyArrayEffect;
import WayofTime.bloodmagic.tile.TileAlchemyArray;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class AlchemyArrayEffectSkeletonTurret
extends AlchemyArrayEffect {
    private EntitySkeleton turret;
    public static Predicate<EntityMob> checkSkeleton = new Predicate<EntityMob>(){

        public boolean apply(EntityMob input) {
            return !(input instanceof EntitySkeleton);
        }
    };

    public AlchemyArrayEffectSkeletonTurret(String key) {
        super(key);
    }

    @Override
    public boolean update(TileEntity tile, int ticksActive) {
        double z;
        double y;
        double x;
        double distance;
        BlockPos pos = tile.func_174877_v();
        if (this.turret != null && !this.turret.field_70128_L && (distance = Math.sqrt((x = (double)pos.func_177958_n() + 0.5 - this.turret.field_70165_t) * x + (y = (double)pos.func_177956_o() + 1.0 - this.turret.field_70163_u) * y + (z = (double)pos.func_177952_p() + 0.5 - this.turret.field_70161_v) * z)) < 2.0) {
            return false;
        }
        World world = tile.func_145831_w();
        List skeletonsInRange = world.func_72872_a(EntitySkeleton.class, this.getBounds(pos));
        for (EntitySkeleton entity : skeletonsInRange) {
            if (entity.field_70128_L) continue;
            this.modifyAITargetTasks(entity);
            this.turret = entity;
            break;
        }
        return false;
    }

    public AxisAlignedBB getBounds(BlockPos pos) {
        return new AxisAlignedBB(pos).func_72314_b((double)this.getRange(), (double)this.getRange(), (double)this.getRange());
    }

    public float getRange() {
        return 0.0f;
    }

    private boolean modifyAITargetTasks(EntitySkeleton entity) {
        this.cancelCurrentTargetTasks((EntityLiving)entity);
        entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityMob.class, 10, true, false, checkSkeleton));
        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        return true;
    }

    private void cancelCurrentTargetTasks(EntityLiving entity) {
        Iterator iterator = entity.field_70715_bh.field_75782_a.iterator();
        ArrayList<EntityAITasks.EntityAITaskEntry> currentTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (entityaitaskentry == null) continue;
            currentTasks.add(entityaitaskentry);
        }
        for (EntityAITasks.EntityAITaskEntry task : currentTasks) {
            entity.field_70715_bh.func_85156_a(task.field_75733_a);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public AlchemyArrayEffect getNewCopy() {
        return new AlchemyArrayEffectSkeletonTurret(this.key);
    }

    private static class AttractTask
    extends EntityAIBase {
        private EntityLiving mob;
        private BlockPos coord;
        private FakePlayer target;
        private int updatesSincePathing;
        private boolean started = false;

        private AttractTask(EntityLiving mob, FakePlayer target, BlockPos coord) {
            this.mob = mob;
            this.coord = coord;
            this.target = target;
        }

        public boolean func_75250_a() {
            return this.func_75253_b();
        }

        public void func_75251_c() {
            this.started = false;
            this.updatesSincePathing = 0;
        }

        public boolean func_75253_b() {
            boolean res = false;
            TileEntity te = this.mob.func_130014_f_().func_175625_s(this.coord);
            if (te instanceof TileAlchemyArray) {
                res = true;
            }
            return res;
        }

        public boolean func_75252_g() {
            return true;
        }

        public void func_75246_d() {
            if (!this.started || this.updatesSincePathing > 20) {
                this.started = true;
                boolean speed = true;
                boolean res = this.mob.func_70661_as().func_75497_a((Entity)this.target, (double)speed);
                if (!res) {
                    this.mob.func_70661_as().func_75492_a(this.target.field_70165_t, this.target.field_70163_u + 1.0, this.target.field_70161_v, (double)speed);
                }
                this.updatesSincePathing = 0;
            } else {
                ++this.updatesSincePathing;
            }
        }
    }
}

