/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.ModItems;

public class ItemRelic
extends ItemMod
implements IRelic {
    private static final String TAG_SOULBIND_NAME = "soulbind";
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";
    private Achievement achievement;

    public ItemRelic(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            this.updateRelic(stack, (EntityPlayer)entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        this.addBindInfo(tooltip, stack, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void addBindInfo(List<String> list, ItemStack stack, EntityPlayer player) {
        if (GuiScreen.func_146272_n()) {
            if (!this.hasUUID(stack)) {
                ItemRelic.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicUnbound", (Object[])new Object[0]), list);
            } else {
                ItemRelic.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicSoulbound", (Object[])new Object[]{this.getSoulbindUsername(stack)}), list);
                if (!this.getSoulbindUUID(stack).equals(player.func_110124_au())) {
                    ItemRelic.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.notYourSagittarius", (Object[])new Object[]{this.getSoulbindUsername(stack)}), list);
                }
            }
            if (stack.func_77973_b() == ModItems.aesirRing) {
                ItemRelic.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.dropIkea", (Object[])new Object[0]), list);
            }
            if (stack.func_77973_b() == ModItems.dice) {
                ItemRelic.addStringToTooltip("", list);
                String name = stack.func_77977_a() + ".poem";
                for (int i = 0; i < 4; ++i) {
                    ItemRelic.addStringToTooltip(TextFormatting.ITALIC + I18n.func_135052_a((String)(name + i), (Object[])new Object[0]), list);
                }
            }
        } else {
            ItemRelic.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), list);
        }
    }

    public boolean shouldDamageWrongPlayer() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    static void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public void updateRelic(ItemStack stack, EntityPlayer player) {
        if (stack == null || !(stack.func_77973_b() instanceof IRelic)) {
            return;
        }
        boolean rightPlayer = true;
        if (this.hasUUID(stack)) {
            if (UsernameCache.containsUUID((UUID)this.getSoulbindUUID(stack))) {
                this.bindToUsername(UsernameCache.getLastKnownUsername((UUID)this.getSoulbindUUID(stack)), stack);
            } else {
                this.bindToUsername("", stack);
            }
            rightPlayer = this.getSoulbindUUID(stack).equals(player.func_110124_au());
        } else if ("".equals(this.getSoulbindUsername(stack))) {
            this.bindToUUID(player.func_110124_au(), stack);
            player.func_71064_a((StatBase)((IRelic)stack.func_77973_b()).getBindAchievement(), 1);
        } else if (player.func_70005_c_().equals(this.getSoulbindUsername(stack))) {
            this.bindToUUID(player.func_110124_au(), stack);
        } else {
            rightPlayer = false;
        }
        if (!(rightPlayer || player.field_70173_aa % 10 != 0 || stack.func_77973_b() instanceof ItemRelic && !((ItemRelic)stack.func_77973_b()).shouldDamageWrongPlayer())) {
            player.func_70097_a(ItemRelic.damageSource(), 2.0f);
        }
    }

    public boolean isRightPlayer(EntityPlayer player, ItemStack stack) {
        if (this.hasUUID(stack)) {
            return this.getSoulbindUUID(stack).equals(player.func_110124_au());
        }
        return this.getSoulbindUsername(stack).equals(player.func_70005_c_());
    }

    public static DamageSource damageSource() {
        return new DamageSource("botania-relic");
    }

    @Override
    public void bindToUsername(String playerName, ItemStack stack) {
        ItemNBTHelper.setString(stack, TAG_SOULBIND_NAME, playerName);
    }

    @Override
    public String getSoulbindUsername(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_SOULBIND_NAME, "");
    }

    @Override
    public void bindToUUID(UUID uuid, ItemStack stack) {
        ItemNBTHelper.setString(stack, TAG_SOULBIND_UUID, uuid.toString());
    }

    @Override
    public UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance(stack, TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString(stack, TAG_SOULBIND_UUID, ""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry(stack, TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    @Override
    public boolean hasUUID(ItemStack stack) {
        return this.getSoulbindUUID(stack) != null;
    }

    @Override
    public Achievement getBindAchievement() {
        return this.achievement;
    }

    @Override
    public void setBindAchievement(Achievement achievement) {
        this.achievement = achievement;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }
}

