/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.render.IModelRegister;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManasteelShovel
extends ItemSpade
implements IManaUsingItem,
ISortableTool,
IModelRegister {
    private static final int MANA_PER_DAMAGE = 60;

    public ItemManasteelShovel() {
        this(BotaniaAPI.manasteelToolMaterial, "manasteelShovel");
    }

    public ItemManasteelShovel(Item.ToolMaterial mat, String name) {
        super(mat);
        this.func_77637_a(BotaniaCreativeTab.INSTANCE);
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)new ResourceLocation("Botania", name));
        this.func_77655_b(name);
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item.", "item.botania:");
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, @Nonnull EntityLivingBase par3EntityLivingBase) {
        ToolCommons.damageItem(par1ItemStack, 1, par3EntityLivingBase, 60);
        return true;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        if (state.func_185887_b(world, pos) != 0.0f) {
            ToolCommons.damageItem(stack, 1, entity, 60);
        }
        return true;
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull ItemStack stack, EntityPlayer player, @Nonnull World world, BlockPos pos, EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_175151_a(pos, side, stack)) {
            return EnumActionResult.PASS;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return EnumActionResult.FAIL;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            ToolCommons.damageItem(stack, 1, (EntityLivingBase)player, 60);
            return EnumActionResult.SUCCESS;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (side != EnumFacing.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos.func_177984_a()) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_185774_da)) {
            Block block1 = Blocks.field_185774_da;
            if (block == block1) {
                block1 = Blocks.field_150458_ak;
            }
            world.func_184133_a(null, pos, block1.func_185467_w().func_185844_d(), SoundCategory.BLOCKS, (block1.func_185467_w().func_185843_a() + 1.0f) / 2.0f, block1.func_185467_w().func_185847_b() * 0.8f);
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            world.func_175656_a(pos, block1.func_176223_P());
            ToolCommons.damageItem(stack, 1, (EntityLivingBase)player, 60);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (!world.field_72995_K && player instanceof EntityPlayer && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool(stack, (EntityPlayer)player, 120, true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 0 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ISortableTool.ToolType getSortingType(ItemStack stack) {
        return ISortableTool.ToolType.SHOVEL;
    }

    @Override
    public int getSortingPriority(ItemStack stack) {
        return ToolCommons.getToolPriority(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

