/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public final class PlayerHelper {
    public static boolean hasAnyHeldItem(EntityPlayer player) {
        return player.func_184614_ca() != null || player.func_184592_cb() != null;
    }

    public static boolean hasHeldItem(EntityPlayer player, Item item) {
        return player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == item || player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() == item;
    }

    public static boolean hasHeldItemClass(EntityPlayer player, Item template) {
        return PlayerHelper.hasHeldItemClass(player, template.getClass());
    }

    public static boolean hasHeldItemClass(EntityPlayer player, Class<?> template) {
        return player.func_184614_ca() != null && template.isAssignableFrom(player.func_184614_ca().func_77973_b().getClass()) || player.func_184592_cb() != null && template.isAssignableFrom(player.func_184592_cb().func_77973_b().getClass());
    }

    public static ItemStack getFirstHeldItem(EntityPlayer player, Item item) {
        ItemStack main = player.func_184614_ca();
        ItemStack offhand = player.func_184592_cb();
        if (main != null && item == main.func_77973_b()) {
            return main;
        }
        if (offhand != null && item == offhand.func_77973_b()) {
            return offhand;
        }
        return null;
    }

    public static ItemStack getFirstHeldItemClass(EntityPlayer player, Class<?> template) {
        ItemStack main = player.func_184614_ca();
        ItemStack offhand = player.func_184592_cb();
        if (main != null && template.isAssignableFrom(main.func_77973_b().getClass())) {
            return main;
        }
        if (offhand != null && template.isAssignableFrom(offhand.func_77973_b().getClass())) {
            return offhand;
        }
        return null;
    }

    public static ItemStack getAmmo(EntityPlayer player, Predicate<ItemStack> ammoFunc) {
        if (ammoFunc.test(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (ammoFunc.test(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!ammoFunc.test(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    public static boolean hasAmmo(EntityPlayer player, Predicate<ItemStack> ammoFunc) {
        return PlayerHelper.getAmmo(player, ammoFunc) != null;
    }

    public static void consumeAmmo(EntityPlayer player, Predicate<ItemStack> ammoFunc) {
        ItemStack ammo = PlayerHelper.getAmmo(player, ammoFunc);
        if (ammo != null) {
            --ammo.field_77994_a;
            if (ammo.field_77994_a == 0) {
                player.field_71071_by.func_184437_d(ammo);
            }
        }
    }

    public static boolean hasItem(EntityPlayer player, Predicate<ItemStack> itemFunc) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (!itemFunc.test(player.field_71071_by.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    private PlayerHelper() {
    }
}

