/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor.slabs;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.client.render.IModelRegister;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.lexicon.LexiconData;

public abstract class BlockModSlab
extends BlockSlab
implements ILexiconable,
IModelRegister {
    private final String name;
    private final boolean doubleSlab;
    private static final PropertyEnum<DummyEnum> DUMMY = PropertyEnum.func_177709_a((String)"dummy", DummyEnum.class);

    public BlockModSlab(boolean full, Material mat, String name) {
        super(mat);
        this.name = name;
        this.func_149663_c(name);
        this.setRegistryName(new ResourceLocation("Botania", name));
        this.doubleSlab = full;
        if (!full) {
            this.func_149647_a(BotaniaCreativeTab.INSTANCE);
            this.field_149783_u = true;
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a(DUMMY, (Comparable)((Object)DummyEnum.SINGLETON)));
        GameRegistry.register((IForgeRegistryEntry)this);
        if (!this.func_176552_j()) {
            ModFluffBlocks.slabsToRegister.add((Block)this);
        }
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, this.func_176551_l()});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (this.doubleSlab) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)(meta == 8 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public int func_176201_c(IBlockState state) {
        if (this.doubleSlab) {
            return 0;
        }
        return state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 8 : 0;
    }

    public abstract BlockSlab getFullBlock();

    public abstract BlockSlab getSingleBlock();

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this.getSingleBlock());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.getSingleBlock());
    }

    public ItemStack func_180643_i(@Nonnull IBlockState par1) {
        return new ItemStack((Block)this.getSingleBlock());
    }

    @Nonnull
    public String func_150002_b(int i) {
        return this.name;
    }

    public final boolean func_176552_j() {
        return this.doubleSlab;
    }

    @Nonnull
    public final IProperty func_176551_l() {
        return DUMMY;
    }

    @Nonnull
    public final Comparable<?> func_185674_a(@Nonnull ItemStack stack) {
        return DummyEnum.SINGLETON;
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.decorativeBlocks;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        if (!this.doubleSlab) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{DUMMY}).func_178441_a());
            ModelHandler.registerBlockToState((Block)this, 0, this.func_176223_P());
        } else {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{DUMMY, BlockSlab.field_176554_a}).func_178441_a());
        }
    }

    private static enum DummyEnum implements IStringSerializable
    {
        SINGLETON{

            @Nonnull
            public String func_176610_l() {
                return this.name().toLowerCase(Locale.ROOT);
            }
        };

    }
}

