/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.render.IModelRegister;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public abstract class BlockModDoubleFlower
extends BlockDoublePlant
implements ILexiconable,
IModelRegister {
    private static final int COUNT = 8;
    private final boolean second;

    public BlockModDoubleFlower(boolean second) {
        this.second = second;
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        String name = "doubleFlower" + (second ? 2 : 1);
        this.func_180632_j(this.pickDefaultState());
        this.setRegistryName(new ResourceLocation("Botania", name));
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockWithMetadataAndName((Block)this), (ResourceLocation)this.getRegistryName());
        this.func_149663_c(name);
        this.func_149711_c(0.0f);
        this.func_149675_a(false);
        this.func_149647_a(BotaniaCreativeTab.INSTANCE);
    }

    @Nonnull
    public abstract BlockStateContainer func_180661_e();

    protected abstract IBlockState pickDefaultState();

    public abstract int func_176201_c(IBlockState var1);

    @Nonnull
    public abstract IBlockState func_176203_a(int var1);

    public Item func_180660_a(IBlockState state, @Nonnull Random rand, int fortune) {
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos pos, IBlockState state, boolean fuckifiknow) {
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, @Nonnull EntityPlayer player) {
        if (state.func_177229_b((IProperty)field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (!player.field_71075_bZ.field_75098_d) {
                    world.func_175698_g(pos.func_177977_b());
                } else {
                    world.func_175698_g(pos.func_177977_b());
                }
            }
        } else if (player.field_71075_bZ.field_75098_d && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
        player.func_71029_a(StatList.func_188055_a((Block)this));
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, @Nonnull BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateBelow = world.func_180495_p(pos.func_177977_b());
        if (stateBelow.func_177230_c() == this && stateBelow.func_177229_b((IProperty)field_176492_b) == BlockDoublePlant.EnumBlockHalf.LOWER && state.func_177229_b((IProperty)field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            ret.add(new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos.func_177977_b()))));
        }
        if (state.func_177229_b((IProperty)field_176492_b) == BlockDoublePlant.EnumBlockHalf.LOWER) {
            ret.add(new ItemStack((Block)this, 1, this.func_176201_c(state)));
        }
        return ret;
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        return ImmutableList.of();
    }

    public void func_149666_a(@Nonnull Item item, CreativeTabs tab, @Nonnull List<ItemStack> stacks) {
        for (int i = 0; i < 8; ++i) {
            stacks.add(new ItemStack(item, 1, i));
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        int hex = ((EnumDyeColor)state.func_177229_b(this.second ? BotaniaStateProps.DOUBLEFLOWER_VARIANT_2 : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1)).func_176768_e().field_76291_p;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (rand.nextDouble() < ConfigHandler.flowerParticleFrequency) {
            Botania.proxy.sparkleFX((double)pos.func_177958_n() + 0.3 + (double)rand.nextFloat() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)rand.nextFloat() * 0.5, (double)pos.func_177952_p() + 0.3 + (double)rand.nextFloat() * 0.5, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, rand.nextFloat(), 5);
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.flowers;
    }

    @Nonnull
    public IBlockState func_176221_a(IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        IBlockState iblockstate;
        if (state.func_177229_b((IProperty)field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER && (iblockstate = worldIn.func_180495_p(pos.func_177977_b())).func_177230_c() == this) {
            PropertyEnum<EnumDyeColor> prop = this.second ? BotaniaStateProps.DOUBLEFLOWER_VARIANT_2 : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1;
            state = state.func_177226_a(prop, iblockstate.func_177229_b(prop));
        }
        return state.func_177226_a((IProperty)field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.SUNFLOWER).func_177226_a((IProperty)field_181084_N, (Comparable)EnumFacing.SOUTH);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
        PropertyEnum<EnumDyeColor> prop = this.second ? BotaniaStateProps.DOUBLEFLOWER_VARIANT_2 : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1;
        return new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, ((EnumDyeColor)state.func_177229_b(prop)).ordinal() - (this.second ? 8 : 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoublePlant.field_176493_a, BlockDoublePlant.field_181084_N}).func_178441_a());
    }
}

