/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileLightRelay;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockLightLauncher
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockLightLauncher() {
        super(Material.field_151575_d, "lightLauncher");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.POWERED});
    }

    @Override
    protected IBlockState pickDefaultState() {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED) != false ? 8 : 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(meta == 8));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        boolean power = world.func_175687_A(pos) > 0 || world.func_175687_A(pos.func_177984_a()) > 0;
        boolean powered = (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED);
        if (power && !powered) {
            this.pickUpEntities(world, pos);
            world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!power && powered) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    private void pickUpEntities(World world, BlockPos pos) {
        ArrayList<TileLightRelay> relays = new ArrayList<TileLightRelay>();
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileLightRelay relay;
            TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
            if (!(tile instanceof TileLightRelay) || (relay = (TileLightRelay)tile).getNextDestination() == null) continue;
            relays.add(relay);
        }
        if (!relays.isEmpty()) {
            AxisAlignedBB aabb = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
            List entities = world.func_72872_a(EntityLivingBase.class, aabb);
            entities.addAll(world.func_72872_a(EntityItem.class, aabb));
            if (!entities.isEmpty()) {
                for (Entity entity : entities) {
                    TileLightRelay relay = (TileLightRelay)relays.get(world.field_73012_v.nextInt(relays.size()));
                    relay.mountEntity(entity);
                }
            }
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.luminizerTransport;
    }
}

