/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;

public class MultiblockBlockAccess
implements IBlockAccess {
    private IBlockAccess originalBlockAccess;
    private boolean hasBlockAccess = false;
    private BlockPos anchorPos;
    protected Multiblock multiblock;

    @Nonnull
    public IBlockState func_180495_p(@Nonnull BlockPos pos) {
        MultiblockComponent comp = this.getComponent(pos);
        if (comp != null) {
            return comp.getBlockState();
        }
        if (this.hasBlockAccess) {
            return this.originalBlockAccess.func_180495_p(pos);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        MultiblockComponent comp = this.getComponent(pos);
        if (comp != null) {
            return comp.getTileEntity();
        }
        if (this.hasBlockAccess) {
            return this.originalBlockAccess.func_175625_s(pos);
        }
        return null;
    }

    public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
        if (this.hasBlockAccess) {
            return this.originalBlockAccess.func_175626_b(pos, lightValue);
        }
        return 0xF00000;
    }

    public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
        return 0;
    }

    @Nonnull
    public WorldType func_175624_G() {
        return WorldType.field_77137_b;
    }

    public boolean func_175623_d(@Nonnull BlockPos pos) {
        MultiblockComponent comp = this.getComponent(pos);
        if (comp != null) {
            return false;
        }
        if (this.hasBlockAccess) {
            return this.originalBlockAccess.func_175623_d(pos);
        }
        return true;
    }

    @Nonnull
    public Biome func_180494_b(@Nonnull BlockPos pos) {
        if (this.hasBlockAccess) {
            return this.originalBlockAccess.func_180494_b(pos);
        }
        return null;
    }

    public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
        if (this.hasBlockAccess) {
            return this.originalBlockAccess.isSideSolid(pos, side, _default);
        }
        return _default;
    }

    public void update(IBlockAccess access, Multiblock mb, BlockPos anchorPos) {
        this.originalBlockAccess = access;
        this.multiblock = mb;
        this.anchorPos = anchorPos;
        this.hasBlockAccess = access != null;
    }

    private MultiblockComponent getComponent(BlockPos pos) {
        return this.multiblock.getComponentForLocation(pos.func_177971_a((Vec3i)new BlockPos(-this.anchorPos.func_177958_n(), -this.anchorPos.func_177956_o(), -this.anchorPos.func_177952_p())));
    }
}

