/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.balyware.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.tile.TileToolRack;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class BlockToolRack
extends BlockKitchen {
    private static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.25, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.875, 0.25, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.25, 0.0, 0.125, 1.0, 1.0)};

    public BlockToolRack() {
        super(Material.field_151575_d);
        this.setRegistryName("cookingforblockheads", "toolRack");
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.5f);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileToolRack();
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BOUNDING_BOXES[facing.func_176745_a() - 2];
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177972_a(EnumFacing.WEST), EnumFacing.EAST) || world.isSideSolid(pos.func_177972_a(EnumFacing.EAST), EnumFacing.WEST) || world.isSideSolid(pos.func_177972_a(EnumFacing.NORTH), EnumFacing.SOUTH) || world.isSideSolid(pos.func_177972_a(EnumFacing.SOUTH), EnumFacing.NORTH);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemBlock) {
            return true;
        }
        if (hitY > 0.25f) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            float hit = hitX;
            switch (facing) {
                case NORTH: {
                    hit = hitX;
                    break;
                }
                case SOUTH: {
                    hit = 1.0f - hitX;
                    break;
                }
                case WEST: {
                    hit = 1.0f - hitZ;
                    break;
                }
                case EAST: {
                    hit = hitZ;
                }
            }
            int hitSlot = hit > 0.5f ? 0 : 1;
            TileToolRack tileToolRack = (TileToolRack)world.func_175625_s(pos);
            if (tileToolRack != null) {
                if (heldItem != null) {
                    ItemStack oldToolItem = tileToolRack.getItemHandler().getStackInSlot(hitSlot);
                    ItemStack toolItem = heldItem.func_77979_a(1);
                    if (oldToolItem != null) {
                        if (!player.field_71071_by.func_70441_a(oldToolItem)) {
                            player.func_71019_a(oldToolItem, false);
                        }
                        tileToolRack.getItemHandler().setStackInSlot(hitSlot, toolItem);
                    } else {
                        tileToolRack.getItemHandler().setStackInSlot(hitSlot, toolItem);
                    }
                } else {
                    ItemStack itemStack = tileToolRack.getItemHandler().getStackInSlot(hitSlot);
                    if (itemStack != null) {
                        tileToolRack.getItemHandler().setStackInSlot(hitSlot, null);
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, itemStack);
                    }
                }
                return true;
            }
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileToolRack tileEntity = (TileToolRack)world.func_175625_s(pos);
        if (tileEntity != null) {
            ItemUtils.dropContent(world, pos, (IItemHandler)tileEntity.getItemHandler());
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        for (String s : I18n.func_135052_a((String)("tooltip." + this.getRegistryName() + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }
}

