/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.balyware.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.tile.TileFridge;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockFridge
extends BlockKitchen {
    public static final PropertyEnum<FridgeType> TYPE = PropertyEnum.func_177709_a((String)"type", FridgeType.class);
    public static final PropertyBool FLIPPED = PropertyBool.func_177716_a((String)"flipped");

    public BlockFridge() {
        super(Material.field_151573_f);
        this.setRegistryName("cookingforblockheads", "fridge");
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE, FLIPPED});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing facing;
        switch (meta & 7) {
            case 0: {
                facing = EnumFacing.EAST;
                break;
            }
            case 1: {
                facing = EnumFacing.WEST;
                break;
            }
            case 2: {
                facing = EnumFacing.SOUTH;
                break;
            }
            default: {
                facing = EnumFacing.NORTH;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                meta = 0;
                break;
            }
            case WEST: {
                meta = 1;
                break;
            }
            case SOUTH: {
                meta = 2;
                break;
            }
            default: {
                meta = 3;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)FLIPPED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = world.func_180495_p(pos.func_177984_a()).func_177230_c() == this ? state.func_177226_a(TYPE, (Comparable)((Object)FridgeType.LARGE)) : (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this ? state.func_177226_a(TYPE, (Comparable)((Object)FridgeType.INVISIBLE)) : state.func_177226_a(TYPE, (Comparable)((Object)FridgeType.SMALL)));
        return state;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileFridge();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileFridge tileFridge;
        if (heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR) {
            if (this.recolorBlock(world, pos, side, EnumDyeColor.func_176766_a((int)heldItem.func_77952_i()))) {
                --heldItem.field_77994_a;
            }
            return true;
        }
        if (side == state.func_177229_b((IProperty)FACING) && (tileFridge = (TileFridge)world.func_175625_s(pos)) != null) {
            if (player.func_70093_af()) {
                tileFridge.getBaseFridge().getDoorAnimator().toggleForcedOpen();
                return true;
            }
            if (heldItem != null && tileFridge.getBaseFridge().getDoorAnimator().isForcedOpen()) {
                heldItem = ItemHandlerHelper.insertItemStacked((IItemHandler)tileFridge.getCombinedItemHandler(), (ItemStack)heldItem, (boolean)false);
                player.func_184611_a(hand, heldItem);
                return true;
            }
        }
        if (!world.field_72995_K) {
            if (heldItem != null && Block.func_149634_a((Item)heldItem.func_77973_b()) == ModBlocks.fridge) {
                return false;
            }
            player.openGui((Object)CookingForBlockheads.instance, 4, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        boolean below = world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.fridge;
        boolean above = world.func_180495_p(pos.func_177984_a()).func_177230_c() == ModBlocks.fridge;
        return !(below && above || below && world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == ModBlocks.fridge || above && world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == ModBlocks.fridge || !super.func_176196_c(world, pos));
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        double blockRotation = (double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5;
        boolean flipped = Math.abs(blockRotation - (double)((int)blockRotation)) < 0.5;
        super.func_180633_a(world, pos, state.func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(!flipped)), placer, stack);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileFridge tileEntity = (TileFridge)world.func_175625_s(pos);
        if (tileEntity != null) {
            ItemUtils.dropContent(world, pos, tileEntity.getItemHandler());
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        for (String s : I18n.func_135052_a((String)("tooltip." + this.getRegistryName() + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.cookingforblockheads:dyeable", (Object[])new Object[0]));
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileFridge) {
            TileFridge tileFridge = (TileFridge)tileEntity;
            tileFridge.setFridgeColor(color);
            TileFridge neighbourFridge = tileFridge.findNeighbourFridge();
            if (neighbourFridge != null) {
                neighbourFridge.setFridgeColor(color);
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ItemModelMesher mesher) {
        super.registerModels(mesher);
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
                TileEntity tileEntity;
                if (world != null && pos != null && (tileEntity = world.func_175625_s(pos)) instanceof TileFridge) {
                    return ((TileFridge)tileEntity).getBaseFridge().getFridgeColor().func_176768_e().field_76291_p;
                }
                return -1;
            }
        }, new Block[]{this});
    }

    public static enum FridgeType implements IStringSerializable
    {
        SMALL,
        LARGE,
        INVISIBLE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

