/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.cookingforblockheads.CommonProxy;
import net.blay09.mods.cookingforblockheads.CookingConfig;
import net.blay09.mods.cookingforblockheads.CowJarHandler;
import net.blay09.mods.cookingforblockheads.InternalMethods;
import net.blay09.mods.cookingforblockheads.ModRecipes;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.ToastErrorHandler;
import net.blay09.mods.cookingforblockheads.api.ToastOutputHandler;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.compat.VanillaAddon;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.network.handler.GuiHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="cookingforblockheads", acceptedMinecraftVersions="[1.9.4]", dependencies="after:mousetweaks[2.8,)")
public class CookingForBlockheads {
    public static final String MOD_ID = "cookingforblockheads";
    private static final Logger logger = LogManager.getLogger();
    public static CreativeTabs creativeTab = new CreativeTabs("cookingforblockheads"){

        public Item func_78016_d() {
            return ModItems.recipeBook;
        }

        public int func_151243_f() {
            return 1;
        }
    };
    @Mod.Instance
    public static CookingForBlockheads instance;
    @SidedProxy(clientSide="net.blay09.mods.cookingforblockheads.client.ClientProxy", serverSide="net.blay09.mods.cookingforblockheads.CommonProxy")
    public static CommonProxy proxy;
    private final List<ItemStack> nonFoodRecipes = Lists.newArrayList();
    public final CowJarHandler cowJarHandler = new CowJarHandler();
    private Configuration config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        CookingConfig.load(this.config);
        CookingForBlockheadsAPI.setupAPI(new InternalMethods());
        ModBlocks.load();
        ModItems.load();
        proxy.preInit(event);
        if (this.config.hasChanged()) {
            this.config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (CookingConfig.cowJarEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)this.cowJarHandler);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkHandler.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"net.blay09.mods.cookingforblockheads.compat.TheOneProbeAddon");
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"net.blay09.mods.cookingforblockheads.compat.WailaProvider.register");
        ModRecipes.load(this.config);
        proxy.init(event);
    }

    @Mod.EventHandler
    public void imc(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            switch (message.key) {
                case "RegisterTool": {
                    if (message.getMessageType() == ItemStack.class) {
                        CookingForBlockheadsAPI.addToolItem(message.getItemStackValue());
                        break;
                    }
                    logger.error("IMC API Error: RegisterTool expected message of type ItemStack");
                    break;
                }
                case "RegisterWaterItem": {
                    if (message.getMessageType() == ItemStack.class) {
                        CookingForBlockheadsAPI.addWaterItem(message.getItemStackValue());
                        break;
                    }
                    logger.error("IMC API Error: RegisterWaterItem expected message of type ItemStack");
                    break;
                }
                case "RegisterMilkItem": {
                    if (message.getMessageType() == ItemStack.class) {
                        CookingForBlockheadsAPI.addMilkItem(message.getItemStackValue());
                        break;
                    }
                    logger.error("IMC API Error: RegisterMilkItem expected message of type ItemStack");
                    break;
                }
                case "RegisterToast": {
                    ItemStack outputItem;
                    ItemStack inputItem;
                    if (message.getMessageType() == NBTTagCompound.class) {
                        inputItem = ItemStack.func_77949_a((NBTTagCompound)message.getNBTValue().func_74775_l("Input"));
                        outputItem = ItemStack.func_77949_a((NBTTagCompound)message.getNBTValue().func_74775_l("Output"));
                        if (inputItem != null && outputItem != null) {
                            CookingForBlockheadsAPI.addToastHandler(inputItem, new ToastOutputHandler(){

                                @Override
                                public ItemStack getToasterOutput(ItemStack itemStack) {
                                    return outputItem;
                                }
                            });
                            break;
                        }
                        logger.error("IMC API Error: RegisterToast expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                        break;
                    }
                    logger.error("IMC API Error: RegisterToast expected message of type NBT");
                    break;
                }
                case "RegisterToastError": {
                    ItemStack inputItem;
                    if (message.getMessageType() == NBTTagCompound.class) {
                        inputItem = ItemStack.func_77949_a((NBTTagCompound)message.getNBTValue().func_74775_l("Input"));
                        final String langKey = message.getNBTValue().func_74779_i("Message");
                        if (inputItem != null && !langKey.isEmpty()) {
                            CookingForBlockheadsAPI.addToastHandler(inputItem, new ToastErrorHandler(){

                                @Override
                                public ITextComponent getToasterHint(EntityPlayer player, ItemStack itemStack) {
                                    return new TextComponentTranslation(langKey, new Object[0]);
                                }
                            });
                            break;
                        }
                        logger.error("IMC API Error: RegisterToastError expected message of type NBT with structure {Input : ItemStack, Message : String}");
                        break;
                    }
                    logger.error("IMC API Error: RegisterToastError expected message of type NBT");
                    break;
                }
                case "RegisterOvenFuel": {
                    ItemStack inputItem;
                    if (message.getMessageType() == NBTTagCompound.class) {
                        inputItem = ItemStack.func_77949_a((NBTTagCompound)message.getNBTValue().func_74775_l("Input"));
                        if (inputItem != null && message.getNBTValue().func_150297_b("FuelValue", 99)) {
                            CookingForBlockheadsAPI.addOvenFuel(inputItem, message.getNBTValue().func_74762_e("FuelValue"));
                            break;
                        }
                        logger.error("IMC API Error: RegisterOvenFuel expected message of type NBT with structure {Input : ItemStack, FuelValue : numeric}");
                        break;
                    }
                    logger.error("IMC API Error: RegisterOvenFuel expected message of type NBT");
                    break;
                }
                case "RegisterOvenRecipe": {
                    ItemStack outputItem;
                    ItemStack inputItem;
                    if (message.getMessageType() == NBTTagCompound.class) {
                        inputItem = ItemStack.func_77949_a((NBTTagCompound)message.getNBTValue().func_74775_l("Input"));
                        outputItem = ItemStack.func_77949_a((NBTTagCompound)message.getNBTValue().func_74775_l("Output"));
                        if (inputItem != null && outputItem != null) {
                            CookingForBlockheadsAPI.addOvenRecipe(inputItem, outputItem);
                            break;
                        }
                        logger.error("IMC API Error: RegisterOvenRecipe expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                        break;
                    }
                    logger.error("IMC API Error: RegisterOvenRecipe expected message of type NBT");
                    break;
                }
                case "RegisterNonFoodRecipe": {
                    if (message.getMessageType() == ItemStack.class) {
                        this.nonFoodRecipes.add(message.getItemStackValue());
                        break;
                    }
                    logger.error("IMC API Error: RegisterNonFoodRecipe expected message of type ItemStack");
                    break;
                }
                case "RegisterCowClass": {
                    if (message.getMessageType() == String.class) {
                        try {
                            Class<?> clazz = Class.forName(message.getStringValue());
                            this.cowJarHandler.registerCowClass(clazz);
                        }
                        catch (ClassNotFoundException e) {
                            logger.error("Could not register cow class " + message.getStringValue() + ": " + e.getMessage());
                            e.printStackTrace();
                        }
                        break;
                    }
                    logger.error("IMC API Error: RegisterCowClass expected message of type String");
                }
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (this.config.getBoolean("Vanilla Minecraft", "modules", true, "Sink Support, Ingredient Recipes")) {
            new VanillaAddon();
        }
        if (this.config.getBoolean("Pam's HarvestCraft", "modules", true, "Tool Support, Oven Recipes, Oven Fuel, Ingredient Recipes, Toast")) {
            event.buildSoftDependProxy("harvestcraft", "net.blay09.mods.cookingforblockheads.compat.HarvestCraftAddon", new Object[0]);
        }
        if (this.config.getBoolean("More Foods", "modules", true, "Tool Support, Ingredient Recipes, Toast")) {
            event.buildSoftDependProxy("morefood", "net.blay09.mods.cookingforblockheads.compat.MoreFoodsAddon", new Object[0]);
        }
        if (this.config.getBoolean("Extra Food", "modules", true, "Tool Support, Ingredient Recipes, Toast")) {
            event.buildSoftDependProxy("ExtraFood", "net.blay09.mods.cookingforblockheads.compat.ExtraFoodAddon", new Object[0]);
        }
        if (this.config.getBoolean("Food Expansion", "modules", true, "Ingredient Recipes")) {
            event.buildSoftDependProxy("fe", "net.blay09.mods.cookingforblockheads.compat.FoodExpansionAddon", new Object[0]);
        }
        event.buildSoftDependProxy("AppleCore", "net.blay09.mods.cookingforblockheads.compat.AppleCoreAddon", new Object[0]);
        event.buildSoftDependProxy("MineTweaker3", "net.blay09.mods.cookingforblockheads.compat.MineTweakerAddon", new Object[0]);
        CookingRegistry.initFoodRegistry();
    }

    @SubscribeEvent
    public void onFoodRegistryInit(FoodRegistryInitEvent event) {
        for (ItemStack itemStack : this.nonFoodRecipes) {
            event.registerNonFoodRecipe(itemStack);
        }
    }
}

