/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.Reference;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.items.DynamicCell;

public class TileIndustrialElectrolyzer
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
ISidedInventory,
IRecipeCrafterProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(8, "TileIndustrialElectrolyzer", 64, (TileEntity)this);
    public RecipeCrafter crafter;

    public TileIndustrialElectrolyzer() {
        super(2);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4, 5};
        this.crafter = new RecipeCrafter(Reference.industrialElectrolyzerRecipe, (TileEntity)this, 2, 4, this.inventory, inputs, outputs);
    }

    public void updateEntity() {
        super.updateEntity();
        this.crafter.updateEntity();
        this.charge(6);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.INDUSTRIAL_ELECTROLYZER, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray = nArray2;
            nArray2[5] = 5;
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArray3[4] = 4;
            nArray = nArray3;
            nArray3[5] = 5;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotIndex, ItemStack stack, EnumFacing side) {
        if (slotIndex > 1) {
            return false;
        }
        if (slotIndex == 1) {
            return ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)DynamicCell.getEmptyCell(1), (boolean)true, (boolean)true);
        }
        return !ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)DynamicCell.getEmptyCell(1), (boolean)true, (boolean)true);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2 || slotIndex == 3 || slotIndex == 4 || slotIndex == 5;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return 1000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 128.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("industrialelectrolyzer").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).filterSlot(1, 50, 51, stack -> ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)DynamicCell.getEmptyCell(1), (boolean)true, (boolean)true)).filterSlot(0, 80, 51, stack -> !ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)DynamicCell.getEmptyCell(1), (boolean)true, (boolean)true)).outputSlot(2, 50, 19).outputSlot(3, 70, 19).outputSlot(4, 90, 19).outputSlot(5, 110, 19).energySlot(6, 18, 51).syncEnergyValue().syncCrafterValue().addInventory().create();
    }
}

