/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import com.google.common.base.CaseFormat;
import java.security.InvalidParameterException;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.init.ModItems;
import techreborn.items.ItemTRNoDestroy;

public class ItemPlates
extends ItemTRNoDestroy {
    public static String[] types = new String[]{"iron", "gold", "carbon", "wood", "redstone", "diamond", "emerald", "PLACEHOLDER_ITEM", "coal", "obsidian", "lazurite"};

    public ItemPlates() {
        this.func_77655_b("techreborn.plate");
        this.func_77627_a(true);
        this.func_77637_a(TechRebornCreativeTabMisc.instance);
    }

    public static ItemStack getPlateByName(String name, int count) {
        name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            if (types[i].equals("PLACEHOLDER_ITEM")) {
                throw new InvalidParameterException("The dust " + name + " could not be found.");
            }
            return new ItemStack(ModItems.PLATES, count, i);
        }
        throw new InvalidParameterException("The plate " + name + " could not be found.");
    }

    public static ItemStack getPlateByName(String name) {
        return ItemPlates.getPlateByName(name, 1);
    }

    public static void registerType(String plateType) {
        for (String type : types) {
            if (!type.equals(plateType)) continue;
            return;
        }
        int plateIndex = types.length;
        String[] newTypes = new String[plateIndex + 1];
        System.arraycopy(types, 0, newTypes, 0, types.length);
        types = newTypes;
        newTypes[plateIndex] = plateType;
        String oreName = "plate" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, plateType);
        OreDictionary.registerOre((String)oreName, (ItemStack)new ItemStack(ModItems.PLATES, 1, plateIndex));
    }

    public String func_77667_c(ItemStack itemStack) {
        int meta = itemStack.func_77952_i();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.func_77658_a() + "." + types[meta];
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < types.length; ++meta) {
            if (types[meta].equals("PLACEHOLDER_ITEM")) continue;
            list.add(new ItemStack(item, 1, meta));
        }
    }
}

