/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.transformers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import reborncore.common.BaseTileBlock;
import reborncore.common.blocks.IRotationTexture;
import techreborn.client.TechRebornCreativeTab;

public abstract class BlockTransformer
extends BaseTileBlock
implements IRotationTexture,
ITexturedBlock {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)Facings.ALL);
    protected final String prefix = "techreborn:blocks/machines/energy/";
    public String name;

    public BlockTransformer(String name) {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149663_c("techreborn." + name.toLowerCase());
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.name = name;
    }

    protected BlockStateContainer func_180661_e() {
        FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)Facings.ALL);
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState sate = worldIn.func_180495_p(pos.func_177978_c());
            Block block = sate.func_177230_c();
            IBlockState state1 = worldIn.func_180495_p(pos.func_177968_d());
            Block block1 = state1.func_177230_c();
            IBlockState state2 = worldIn.func_180495_p(pos.func_177976_e());
            Block block2 = state2.func_177230_c();
            IBlockState state3 = worldIn.func_180495_p(pos.func_177974_f());
            Block block3 = state3.func_177230_c();
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j(state) && !block1.func_149730_j(state1)) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j(state1) && !block.func_149730_j(state)) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j(state2) && !block3.func_149730_j(state2)) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j(state3) && !block2.func_149730_j(state2)) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        if (placer.field_70125_A < -50.0f) {
            facing = EnumFacing.DOWN;
        } else if (placer.field_70125_A > 50.0f) {
            facing = EnumFacing.UP;
        }
        this.setFacing(facing, worldIn, pos);
    }

    protected List<ItemStack> dropInventory(IBlockAccess world, BlockPos pos, ItemStack itemToDrop) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            System.out.print("Null");
            return null;
        }
        if (!(tileEntity instanceof IInventory)) {
            System.out.print("Not INstance");
            return null;
        }
        IInventory inventory = (IInventory)tileEntity;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack != null && itemStack.field_77994_a > 0 && itemStack.func_77973_b() instanceof ItemBlock && (((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockFluidBase || ((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockStaticLiquid || ((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockDynamicLiquid)) continue;
            items.add(itemStack.func_77946_l());
        }
        items.add(itemToDrop.func_77946_l());
        return items;
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
        return facingInt;
    }

    public IBlockState func_176203_a(int meta) {
        boolean active = false;
        EnumFacing facing = this.getSideFromint(meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void setFacing(EnumFacing facing, World world, BlockPos pos) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    public EnumFacing getSideFromint(int i) {
        if (i == 0) {
            return EnumFacing.NORTH;
        }
        if (i == 1) {
            return EnumFacing.SOUTH;
        }
        if (i == 2) {
            return EnumFacing.EAST;
        }
        if (i == 3) {
            return EnumFacing.WEST;
        }
        if (i == 4) {
            return EnumFacing.UP;
        }
        if (i == 5) {
            return EnumFacing.DOWN;
        }
        return EnumFacing.NORTH;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        if (facing == EnumFacing.UP) {
            return 4;
        }
        if (facing == EnumFacing.DOWN) {
            return 5;
        }
        return 0;
    }

    public String getFrontOff() {
        return "techreborn:blocks/machines/energy/" + this.name.toLowerCase().replace("transformer", "") + "_transformer_front";
    }

    public String getFrontOn() {
        return "techreborn:blocks/machines/energy/" + this.name.toLowerCase().replace("transformer", "") + "_transformer_front";
    }

    public String getSide() {
        return "techreborn:blocks/machines/energy/" + this.name.toLowerCase().replace("transformer", "") + "_transformer_side";
    }

    public String getTop() {
        return "techreborn:blocks/machines/energy/" + this.name.toLowerCase().replace("transformer", "") + "_transformer_side";
    }

    public String getBottom() {
        return "techreborn:blocks/machines/energy/" + this.name.toLowerCase().replace("transformer", "") + "_transformer_side";
    }

    public String getTextureNameFromState(IBlockState blockState, EnumFacing facing) {
        if (this instanceof IRotationTexture) {
            BlockTransformer rotationTexture = this;
            if (this.getFacing(blockState) == facing) {
                return rotationTexture.getFrontOff();
            }
            if (facing == EnumFacing.UP) {
                return rotationTexture.getTop();
            }
            if (facing == EnumFacing.DOWN) {
                return rotationTexture.getBottom();
            }
            return rotationTexture.getSide();
        }
        return "techreborn:blocks/machine/machine_side";
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public int amountOfStates() {
        return 6;
    }

    public static enum Facings implements Predicate<EnumFacing>,
    Iterable<EnumFacing>
    {
        ALL;


        public EnumFacing[] facings() {
            return new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN};
        }

        public EnumFacing random(Random rand) {
            EnumFacing[] aenumfacing = this.facings();
            return aenumfacing[rand.nextInt(aenumfacing.length)];
        }

        public boolean apply(EnumFacing p_apply_1_) {
            return p_apply_1_ != null;
        }

        @Override
        public Iterator<EnumFacing> iterator() {
            return Iterators.forArray((Object[])this.facings());
        }
    }
}

