/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.LightMathHelper;
import java.util.Arrays;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class QuadHelper {
    public static BakedQuad buildBoxQuad(VertexFormat format, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, TextureAtlasSprite texture) {
        Vec3d c = new Vec3d((double)((x2 + x3) / 2.0f), (double)((y2 + y3) / 2.0f), (double)((z2 + z3) / 2.0f));
        Vec3d a = new Vec3d((double)x0, (double)y0, (double)z0).func_178788_d(c);
        Vec3d b = new Vec3d((double)x1, (double)y1, (double)z1).func_178788_d(c);
        Vec3d normal = a.func_72431_c(b);
        EnumFacing side = EnumFacing.func_176737_a((float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c));
        return QuadHelper.buildQuad(format, TRSRTransformation.identity(), side, -1, x0, y0, z0, u0, v0, x1, y1, z1, u1, v1, x2, y2, z2, u2, v2, x3, y3, z3, u3, v3, texture);
    }

    public static BakedQuad buildQuad(VertexFormat format, TRSRTransformation transform, EnumFacing side, int tint, float x0, float y0, float z0, float u0, float v0, int c0, float x1, float y1, float z1, float u1, float v1, int c1, float x2, float y2, float z2, float u2, float v2, int c2, float x3, float y3, float z3, float u3, float v3, int c3, TextureAtlasSprite texture) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        QuadHelper.putQuad(format, transform, side, tint, x0, y0, z0, u0, v0, c0, x1, y1, z1, u1, v1, c1, x2, y2, z2, u2, v2, c2, x3, y3, z3, u3, v3, c3, builder, texture);
        return builder.build();
    }

    private static void putQuad(VertexFormat format, TRSRTransformation transform, EnumFacing side, int tint, float x0, float y0, float z0, float u0, float v0, int c0, float x1, float y1, float z1, float u1, float v1, int c1, float x2, float y2, float z2, float u2, float v2, int c2, float x3, float y3, float z3, float u3, float v3, int c3, UnpackedBakedQuad.Builder builder, TextureAtlasSprite texture) {
        builder.setTexture(texture);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        QuadHelper.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0, c0);
        QuadHelper.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1, c1);
        QuadHelper.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2, c2);
        QuadHelper.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3, c3);
    }

    public static BakedQuad applyMatrixTransform(BakedQuad input, Matrix4f rotation) {
        int[] vertexData = Arrays.copyOf(input.func_178209_a(), 28);
        Vector4f vec = new Vector4f();
        for (int i = 0; i < 4; ++i) {
            vec.x = Float.intBitsToFloat(vertexData[i * 7 + 0]);
            vec.y = Float.intBitsToFloat(vertexData[i * 7 + 1]);
            vec.z = Float.intBitsToFloat(vertexData[i * 7 + 2]);
            vec.w = 1.0f;
            rotation.transform((Tuple4f)vec);
            vertexData[i * 7 + 0] = Float.floatToRawIntBits(vec.x);
            vertexData[i * 7 + 1] = Float.floatToRawIntBits(vec.y);
            vertexData[i * 7 + 2] = Float.floatToRawIntBits(vec.z);
        }
        return new BakedQuad(vertexData, input.func_178211_c(), input.func_178210_d(), input.func_187508_a(), input.shouldApplyDiffuseLighting(), input.getFormat());
    }

    public static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, TRSRTransformation transform, EnumFacing side, float x, float y, float z, float u, float v, int c) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    vec.x = x;
                    vec.y = y;
                    vec.z = z;
                    vec.w = 1.0f;
                    transform.getMatrix().transform((Tuple4f)vec);
                    builder.put(e, new float[]{vec.x, vec.y, vec.z, vec.w});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{(float)ColorHelper.getR(c) / 255.0f, (float)ColorHelper.getG(c) / 255.0f, (float)ColorHelper.getB(c) / 255.0f, (float)ColorHelper.getA(c) / 255.0f});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static TRSRTransformation rotate(float angle, Vector3f axis, TRSRTransformation transform) {
        Matrix4f matrix = transform.getMatrix();
        return new TRSRTransformation(QuadHelper.rotate(angle, axis, matrix, matrix));
    }

    public static Matrix4f rotate(float angle, Vector3f axis, Matrix4f src, Matrix4f dest) {
        return QuadHelper.rotate(angle, axis.x, axis.y, axis.z, src, dest);
    }

    public static Matrix4f translate(Matrix4f m, float x, float y, float z) {
        m.m03 += x;
        m.m13 += y;
        m.m23 += z;
        return m;
    }

    public static Matrix4f scale(Matrix4f m, float scale) {
        m.m00 *= scale;
        m.m01 *= scale;
        m.m02 *= scale;
        m.m10 *= scale;
        m.m11 *= scale;
        m.m12 *= scale;
        m.m20 *= scale;
        m.m21 *= scale;
        m.m22 *= scale;
        m.m03 *= scale;
        m.m13 *= scale;
        m.m23 *= scale;
        return m;
    }

    public static Matrix4f rotate(float angle, float x_axis, float y_axis, float z_axis, Matrix4f src, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        float oneminusc = 1.0f - c;
        float xy = x_axis * y_axis;
        float yz = y_axis * z_axis;
        float xz = x_axis * z_axis;
        float xs = x_axis * s;
        float ys = y_axis * s;
        float zs = z_axis * s;
        float f00 = x_axis * x_axis * oneminusc + c;
        float f01 = xy * oneminusc + zs;
        float f02 = xz * oneminusc - ys;
        float f10 = xy * oneminusc - zs;
        float f11 = y_axis * y_axis * oneminusc + c;
        float f12 = yz * oneminusc + xs;
        float f20 = xz * oneminusc + ys;
        float f21 = yz * oneminusc - xs;
        float f22 = z_axis * z_axis * oneminusc + c;
        float t00 = src.m00 * f00 + src.m10 * f01 + src.m20 * f02;
        float t01 = src.m01 * f00 + src.m11 * f01 + src.m21 * f02;
        float t02 = src.m02 * f00 + src.m12 * f01 + src.m22 * f02;
        float t03 = src.m03 * f00 + src.m13 * f01 + src.m23 * f02;
        float t10 = src.m00 * f10 + src.m10 * f11 + src.m20 * f12;
        float t11 = src.m01 * f10 + src.m11 * f11 + src.m21 * f12;
        float t12 = src.m02 * f10 + src.m12 * f11 + src.m22 * f12;
        float t13 = src.m03 * f10 + src.m13 * f11 + src.m23 * f12;
        float t20 = src.m00 * f20 + src.m10 * f21 + src.m20 * f22;
        float t21 = src.m01 * f20 + src.m11 * f21 + src.m21 * f22;
        float t22 = src.m02 * f20 + src.m12 * f21 + src.m22 * f22;
        float t23 = src.m03 * f20 + src.m13 * f21 + src.m23 * f22;
        dest.m00 = t00;
        dest.m01 = t01;
        dest.m02 = t02;
        dest.m03 = t03;
        dest.m10 = t10;
        dest.m11 = t11;
        dest.m12 = t12;
        dest.m13 = t13;
        dest.m20 = t20;
        dest.m21 = t21;
        dest.m22 = t22;
        dest.m23 = t23;
        return dest;
    }

    public static BakedQuad buildQuad(VertexFormat format, TRSRTransformation transform, EnumFacing face, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, TextureAtlasSprite texture) {
        return QuadHelper.buildQuad(format, transform, face, tint, x0, y0, z0, u0, v0, x1, y1, z1, u1, v1, x2, y2, z2, u2, v2, x3, y3, z3, u3, v3, -1, texture);
    }

    public static BakedQuad buildQuad(VertexFormat format, TRSRTransformation transform, EnumFacing face, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, int color, TextureAtlasSprite texture) {
        return QuadHelper.buildQuad(format, transform, face, tint, x0, y0, z0, u0, v0, color, x1, y1, z1, u1, v1, color, x2, y2, z2, u2, v2, color, x3, y3, z3, u3, v3, color, texture);
    }

    public static BakedQuad reverse(BakedQuad input) {
        int[] vertexData = input.func_178209_a();
        int[] v = new int[28];
        int col = input.func_178210_d() == EnumFacing.UP ? -8355712 : (input.func_178210_d() == EnumFacing.DOWN ? -1 : 0);
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(vertexData, (3 - i) * 7, v, i * 7, 7);
            if (col == 0) continue;
            v[i * 7 + 3] = col;
        }
        return new BakedQuad(v, input.func_178211_c(), input.func_178210_d(), input.func_187508_a(), input.shouldApplyDiffuseLighting(), input.getFormat());
    }

    public static float getFaceBrightness(float x, float y, float z) {
        float[] norm = LightMathHelper.norm(x, y, z);
        return QuadHelper.getFaceBrightnessNorm(norm[0], norm[1], norm[2]);
    }

    public static float getFaceBrightnessNorm(float a, float b, float c) {
        return a * a * 0.6f + b * b * 0.75f + 0.25f * b + c * c * 0.8f;
    }

    public static int getFaceShadeColor(float x, float y, float z) {
        float f = QuadHelper.getFaceBrightness(x, y, z);
        int i = MathHelper.func_76125_a((int)((int)(f * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | i << 8 | i;
    }

    @SideOnly(value=Side.CLIENT)
    public static BakedQuad createBakedQuad(UV[] vecs, String texture, boolean addShading, int tint) {
        Vector3f a = new Vector3f();
        Vector3f b = new Vector3f();
        Vector3f c = new Vector3f();
        Vector3f.sub((Vector3f)vecs[1].toVector3f(), (Vector3f)vecs[0].toVector3f(), (Vector3f)a);
        Vector3f.sub((Vector3f)vecs[2].toVector3f(), (Vector3f)vecs[0].toVector3f(), (Vector3f)b);
        Vector3f.cross((Vector3f)a, (Vector3f)b, (Vector3f)c);
        EnumFacing facing = EnumFacing.func_176737_a((float)c.x, (float)c.y, (float)c.z);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Textures.sprites.get((Object)texture);
        if (sprite == null) {
            sprite = Textures.MISSING_SPRITE;
        }
        int col = addShading ? QuadHelper.getFaceShadeColor(c.x, c.y, c.z) : -1;
        int[] vertex = new int[28];
        for (int i = 0; i < 4; ++i) {
            vertex[i * 7] = Float.floatToRawIntBits(vecs[i].x);
            vertex[i * 7 + 1] = Float.floatToRawIntBits(vecs[i].y);
            vertex[i * 7 + 2] = Float.floatToRawIntBits(vecs[i].z);
            vertex[i * 7 + 3] = col;
            vertex[i * 7 + 4] = Float.floatToRawIntBits(sprite.func_94214_a((double)(vecs[i].u * 16.0f)));
            vertex[i * 7 + 5] = Float.floatToRawIntBits(sprite.func_94207_b((double)(16.0f - vecs[i].v * 16.0f)));
        }
        ForgeHooksClient.fillNormal((int[])vertex, (EnumFacing)facing);
        return new BakedQuad(vertex, tint, facing, sprite, false, DefaultVertexFormats.field_176599_b);
    }

    public static void rotate(float ang, javax.vecmath.Vector3f orbit_axis, Matrix4f mat) {
        QuadHelper.rotate(ang, orbit_axis.x, orbit_axis.y, orbit_axis.z, mat, mat);
    }
}

