/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;

public abstract class ArrayAccess<T>
implements Iterable<T> {
    public abstract void set(int var1, T var2);

    public abstract T get(int var1);

    public abstract int length();

    public static class WrapList<T>
    extends ArrayAccess<T> {
        final List<T> list;

        public WrapList(List<T> list) {
            this.list = list;
        }

        @Override
        public void set(int i, T t) {
            this.list.set(i, t);
        }

        @Override
        public T get(int i) {
            return this.list.get(i);
        }

        @Override
        public int length() {
            return this.list.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }
    }

    public static class WrapArray<T>
    extends ArrayAccess<T> {
        final T[] array;

        public WrapArray(T[] array) {
            this.array = array;
        }

        @Override
        public void set(int i, T t) {
            this.array[i] = t;
        }

        @Override
        public T get(int i) {
            return this.array[i];
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.forArray((Object[])this.array);
        }
    }
}

