/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.blocks.BlockAdvInteractor;
import com.rwtema.extrautils2.compatibility.BlockCompat;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.ItemCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.fakeplayer.XUFakePlayer;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoiceEnum;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.StackDump;
import com.rwtema.extrautils2.itemhandler.XUTileItemStackHandler;
import com.rwtema.extrautils2.tile.TileAdvInteractor;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.datastructures.ThreadLocalBoolean;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileUse
extends TileAdvInteractor {
    private final ItemStackHandler contents = this.registerNBT("contents", new XUTileItemStackHandler(9, this));
    private final StackDump extraStacks = this.registerNBT("extrastacks", new StackDump());
    private final NBTSerializable.NBTBoolean sneak = this.registerNBT("sneak", new NBTSerializable.NBTBoolean(false));
    NBTSerializable.NBTEnum<Button> button = this.registerNBT("button", new NBTSerializable.NBTEnum<Button>(Button.RIGHT_CLICK));
    NBTSerializable.NBTEnum<Mode> mode = this.registerNBT("mode", new NBTSerializable.NBTEnum<Mode>(Mode.GENERIC_CLICK));
    NBTSerializable.NBTEnum<Select> select = this.registerNBT("select", new NBTSerializable.NBTEnum<Select>(Select.RANDOM_SLOT));
    private XUFakePlayer fakePlayer;

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return Iterables.concat(InventoryHelper.getItemHandlerIterator((IItemHandler)this.contents), (Iterable)this.extraStacks, InventoryHelper.getItemHandlerIterator((IItemHandler)this.upgrades));
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.contents;
    }

    @Override
    public void operate() {
        int i;
        ItemStack copy;
        InventoryPlayer inventory;
        block47: {
            if (!this.extraStacks.stacks.isEmpty()) {
                this.extraStacks.attemptDump((IItemHandler)this.contents);
                return;
            }
            XUBlockState state = this.getBlockState();
            EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            int slotNo = 0;
            ItemStack stack = null;
            block1 : switch ((Select)((Object)this.select.value)) {
                case UPPER_LEFT_SLOT_ONLY: {
                    slotNo = 0;
                    stack = this.contents.getStackInSlot(slotNo);
                    break;
                }
                case RANDOM_SLOT: {
                    int j;
                    int[] ind = new int[9];
                    Random rand = this.field_145850_b.field_73012_v;
                    int i22 = 1;
                    while (i22 < ind.length) {
                        j = rand.nextInt(1 + i22);
                        ind[i22] = ind[j];
                        ind[j] = i22++;
                    }
                    int[] i22 = ind;
                    j = i22.length;
                    for (int k = 0; k < j; ++k) {
                        int i3;
                        slotNo = i3 = i22[k];
                        stack = this.contents.getStackInSlot(i3);
                        if (StackHelper.isNonNull(stack)) break block1;
                    }
                    break;
                }
            }
            if (this.fakePlayer == null) {
                this.fakePlayer = new XUFakePlayer((WorldServer)this.field_145850_b, this.owner, Lang.getItemName(this.getXUBlock()));
            }
            this.fakePlayer.setLocationEdge(pos, side);
            this.fakePlayer.clearInventory();
            inventory = this.fakePlayer.field_71071_by;
            for (int i4 = 0; i4 < 9; ++i4) {
                inventory.func_70299_a(i4, StackHelper.safeCopy(this.contents.getStackInSlot(i4)));
            }
            inventory.field_70461_c = slotNo;
            this.fakePlayer.updateAttributes();
            this.fakePlayer.func_70095_a(this.sneak.value);
            copy = inventory.func_70301_a(slotNo);
            IBlockState blockState = this.field_145850_b.func_180495_p(pos);
            float hitX = (float)(this.fakePlayer.field_70165_t - (double)pos.func_177958_n());
            float hitY = (float)(this.fakePlayer.field_70163_u - (double)pos.func_177956_o());
            float hitZ = (float)(this.fakePlayer.field_70161_v - (double)pos.func_177952_p());
            try {
                block5 : switch ((Mode)((Object)this.mode.value)) {
                    case GENERIC_CLICK: {
                        if (!StackHelper.isNonNull(copy)) break;
                        switch ((Button)((Object)this.button.value)) {
                            case LEFT_CLICK: {
                                this.fakePlayer.field_71134_c.func_180784_a(pos, side);
                                for (i = 0; i < 20; ++i) {
                                    this.fakePlayer.field_71134_c.func_73075_a();
                                }
                                this.fakePlayer.field_71134_c.func_180785_a(pos);
                                this.fakePlayer.field_71134_c.func_180238_e();
                                break block5;
                            }
                            case RIGHT_CLICK: {
                                this.fakePlayer.field_71134_c.func_187250_a((EntityPlayer)this.fakePlayer, this.field_145850_b, copy, EnumHand.MAIN_HAND);
                            }
                        }
                        break;
                    }
                    case PLACE_BLOCK: {
                        int i5;
                        IBlockState placedState;
                        if (this.button.value != Button.RIGHT_CLICK || !StackHelper.isNonNull(copy) || !blockState.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, pos)) break;
                        if (copy.func_77973_b() instanceof ItemSeedFood) {
                            ItemCompat.invokeOnItemUse(copy, (EntityPlayer)this.fakePlayer, this.field_145850_b, pos.func_177977_b(), EnumHand.MAIN_HAND, EnumFacing.UP, hitX, hitY, hitZ);
                            break;
                        }
                        if (!(copy.func_77973_b() instanceof ItemBlock)) break;
                        ItemBlock itemBlock = (ItemBlock)copy.func_77973_b();
                        if (!this.field_145850_b.field_72995_K && itemBlock.placeBlockAt(copy, (EntityPlayer)this.fakePlayer, this.field_145850_b, pos, side, hitX, hitY, hitZ, placedState = BlockCompat.invokeGetStateForPlacement(itemBlock.field_150939_a, this.field_145850_b, pos, side, hitX, hitY, hitZ, i5 = itemBlock.func_77647_b(copy.func_77960_j()), (EntityPlayer)this.fakePlayer, EnumHand.MAIN_HAND, stack))) {
                            StackHelper.decrease(copy);
                        }
                        break;
                    }
                    case USE_ITEM_ON_BLOCK: {
                        switch ((Button)((Object)this.button.value)) {
                            case LEFT_CLICK: {
                                PlayerInteractEvent.LeftClickBlock event2 = ForgeHooks.onLeftClickBlock((EntityPlayer)this.fakePlayer, (BlockPos)pos, (EnumFacing)side, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)this.fakePlayer, (double)2.0));
                                if (event2.isCanceled() || event2.getUseItem() == Event.Result.DENY) break;
                                EventHandler.cancelClickBlock.set(true);
                                this.fakePlayer.field_71134_c.func_180784_a(pos, side);
                                EventHandler.cancelClickBlock.set(false);
                                for (int i6 = 0; i6 < 20; ++i6) {
                                    this.fakePlayer.field_71134_c.func_73075_a();
                                }
                                this.fakePlayer.field_71134_c.func_180785_a(pos);
                                this.fakePlayer.field_71134_c.func_180238_e();
                                break block5;
                            }
                            case RIGHT_CLICK: {
                                PlayerInteractEvent.RightClickBlock event;
                                if (!StackHelper.isNonNull(copy) || (event = BlockCompat.onRightClickBlock((EntityPlayer)this.fakePlayer, EnumHand.MAIN_HAND, copy, pos, side, ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)this.fakePlayer, (double)2.0))).isCanceled() || event.getUseItem() == Event.Result.DENY || ItemCompat.invokeOnItemUseFirst(copy, (EntityPlayer)this.fakePlayer, this.field_145850_b, pos, side, hitX, hitY, hitZ, EnumHand.MAIN_HAND) != EnumActionResult.PASS) break;
                                copy.func_179546_a((EntityPlayer)this.fakePlayer, this.field_145850_b, pos, EnumHand.MAIN_HAND, side, hitX, hitY, hitZ);
                            }
                        }
                        break;
                    }
                    case ACTIVATE_BLOCK_WITH_ITEM: {
                        switch ((Button)((Object)this.button.value)) {
                            case LEFT_CLICK: {
                                PlayerInteractEvent.LeftClickBlock event2 = ForgeHooks.onLeftClickBlock((EntityPlayer)this.fakePlayer, (BlockPos)pos, (EnumFacing)side, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)this.fakePlayer, (double)2.0));
                                if (event2.isCanceled() || event2.getUseBlock() == Event.Result.DENY) break;
                                blockState.func_177230_c().func_180649_a(this.field_145850_b, pos, (EntityPlayer)this.fakePlayer);
                                this.field_145850_b.func_175719_a(null, pos, side);
                                break block5;
                            }
                            case RIGHT_CLICK: {
                                PlayerInteractEvent.RightClickBlock event = BlockCompat.onRightClickBlock((EntityPlayer)this.fakePlayer, EnumHand.MAIN_HAND, copy, pos, side, ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)this.fakePlayer, (double)2.0));
                                if (event.isCanceled() || event.getUseBlock() == Event.Result.DENY) break;
                                CompatHelper.activateBlock(blockState.func_177230_c(), this.field_145850_b, pos, blockState, (EntityPlayer)this.fakePlayer, EnumHand.MAIN_HAND, copy, side, hitX, hitY, hitZ);
                            }
                        }
                        break;
                    }
                    case USE_ITEM: {
                        if (!StackHelper.isNonNull(copy) || this.button.value != Button.RIGHT_CLICK) break;
                        this.fakePlayer.field_71134_c.func_187250_a((EntityPlayer)this.fakePlayer, this.field_145850_b, copy, EnumHand.MAIN_HAND);
                        break;
                    }
                    case ENTITY: {
                        BlockAdvInteractor.Use.rayTraceFlag.set(true);
                        Vec3d start = new Vec3d(this.fakePlayer.field_70165_t, this.fakePlayer.field_70163_u + (double)this.fakePlayer.func_70047_e(), this.fakePlayer.field_70161_v);
                        Vec3d vec3d1 = this.fakePlayer.getVectorForRotationPublic(this.fakePlayer.field_70125_A, this.fakePlayer.field_70177_z);
                        Vec3d end = start.func_72441_c(vec3d1.field_72450_a * 3.0, vec3d1.field_72448_b * 3.0, vec3d1.field_72449_c * 3.0);
                        RayTraceResult trace = this.fakePlayer.field_70170_p.func_147447_a(start, end, false, false, true);
                        BlockAdvInteractor.Use.rayTraceFlag.set(false);
                        if (trace != null && trace.field_72307_f != null) {
                            end = trace.field_72307_f;
                        }
                        Entity entity = null;
                        List list = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(pos));
                        if (list.isEmpty()) break;
                        double d6 = 0.0;
                        Entity fallback = null;
                        for (Entity ent : list) {
                            double d7;
                            if (!ent.func_70067_L() || ent.field_70145_X || this.button.value == Button.LEFT_CLICK && (entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow)) continue;
                            fallback = ent;
                            AxisAlignedBB axisalignedbb = ent.func_174813_aQ().func_186662_g((double)0.3f);
                            RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(start, end);
                            if (raytraceresult1 == null || !((d7 = start.func_72436_e(raytraceresult1.field_72307_f)) < d6) && d6 != 0.0) continue;
                            entity = ent;
                            d6 = d7;
                        }
                        if (entity == null) {
                            entity = fallback;
                        }
                        if (entity == null) break;
                        switch ((Button)((Object)this.button.value)) {
                            case LEFT_CLICK: {
                                if (!(entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow)) {
                                    this.fakePlayer.updateCooldown();
                                    this.fakePlayer.func_71059_n(entity);
                                    break block5;
                                }
                                break block47;
                            }
                            case RIGHT_CLICK: {
                                CompatHelper.interactOn((EntityPlayer)this.fakePlayer, entity, EnumHand.MAIN_HAND, copy);
                            }
                        }
                    }
                }
            }
            catch (Exception throwable) {
                this.fakePlayer.clearInventory();
                this.fakePlayer.func_70095_a(false);
                throw new RuntimeException("Error while interacting with block " + blockState + " with " + copy + ". Method:" + this.mode.value + "  Button:" + this.button.value, throwable);
            }
        }
        if (StackHelper.isNonNull(copy)) {
            this.fakePlayer.func_184811_cZ().func_185145_a(copy.func_77973_b(), 0);
            this.fakePlayer.updateCooldown();
        }
        for (i = 0; i < 9; ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (StackHelper.isNonNull(slot) && StackHelper.isEmpty(slot)) {
                slot = StackHelper.empty();
            }
            inventory.func_70299_a(i, StackHelper.empty());
            this.contents.setStackInSlot(i, StackHelper.safeCopy(slot));
        }
        for (i = 9; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (!StackHelper.isNonNull(stackInSlot) || StackHelper.getStacksize(stackInSlot) <= 0 || !StackHelper.isNonNull(stackInSlot = InventoryHelper.insert((IItemHandler)this.contents, stackInSlot, false))) continue;
            this.extraStacks.addStack(stackInSlot);
        }
        inventory.func_174888_l();
        this.fakePlayer.func_70095_a(false);
        this.fakePlayer.updateAttributes();
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerUser(player);
    }

    private class ContainerUser
    extends DynamicContainerTile {
        public ContainerUser(EntityPlayer player) {
            super(TileUse.this);
            this.addTitle("User");
            this.crop();
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    this.addWidget(new WidgetSlotItemHandler((IItemHandler)TileUse.this.contents, x + y * 3, 58 + 18 * x, this.height + 4 + 18 * y));
                }
            }
            this.addWidget(TileAdvInteractor.getRSWidget(140, this.height + 4 + 18, TileUse.this.redstone_state, TileUse.this.pulses));
            this.addWidget(TileUse.this.upgrades.getSpeedUpgradeSlot(140, this.height + 4 + 36));
            this.crop();
            WidgetClickMCButtonChoiceEnum<Enum> w = new WidgetClickMCButtonChoiceEnum<Mode>(4, this.height, TileUse.this.mode);
            this.addWidget(w);
            this.crop();
            w = new WidgetClickMCButtonChoiceEnum<Button>(4, this.height, TileUse.this.button);
            this.addWidget(w);
            this.crop();
            w = new WidgetClickMCButtonChoiceEnum<Select>(4, this.height, TileUse.this.select);
            this.addWidget(w);
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }

    private static class EventHandler {
        static ThreadLocalBoolean cancelClickBlock = new ThreadLocalBoolean(false);

        private EventHandler() {
        }

        @SubscribeEvent
        public void appropriateType(PlayerInteractEvent.LeftClickBlock event) {
            if (((Boolean)cancelClickBlock.get()).booleanValue()) {
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    static enum Mode {
        GENERIC_CLICK,
        PLACE_BLOCK,
        USE_ITEM_ON_BLOCK,
        ACTIVATE_BLOCK_WITH_ITEM,
        USE_ITEM,
        ENTITY;

    }

    static enum Button {
        RIGHT_CLICK,
        LEFT_CLICK;

    }

    static enum Select {
        RANDOM_SLOT,
        UPPER_LEFT_SLOT_ONLY;

    }
}

