/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.eventhandlers.ItemCaptureHandler;
import com.rwtema.extrautils2.fakeplayer.XUFakePlayer;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.PublicWrapper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.itemhandler.StackDump;
import com.rwtema.extrautils2.itemhandler.XUTileItemStackHandler;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.tile.TileAdvInteractor;
import com.rwtema.extrautils2.utils.Lang;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileMine
extends TileAdvInteractor {
    private static final ItemStack genericDigger = new ItemStack(Items.field_151046_w, 1);
    private final ItemStackHandler contents = this.registerNBT("contents", new XUTileItemStackHandler(9, this));
    public final IItemHandler publicHandler = new PublicWrapper.Extract((IItemHandlerModifiable)this.contents);
    private final StackDump extraStacks = this.registerNBT("extrastacks", new StackDump());
    private ItemStack diggerTool;
    private final SingleStackHandler enchants = this.registerNBT("enchants", new SingleStackHandler(){

        @Override
        protected int getStackLimit(@Nonnull ItemStack stack) {
            if (stack.func_77973_b() != Items.field_151134_bR) {
                return 0;
            }
            Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
            if (map.isEmpty()) {
                return 0;
            }
            for (Enchantment enchantment : map.keySet()) {
                if (!enchantment.func_92089_a(genericDigger)) continue;
                return 1;
            }
            return 0;
        }

        @Override
        protected void onContentsChanged() {
            TileMine.this.func_70296_d();
            TileMine.this.diggerTool = null;
        }
    });
    private XUFakePlayer fakePlayer;

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return Iterables.concat(InventoryHelper.getItemHandlerIterator((IItemHandler)this.contents), (Iterable)this.extraStacks, InventoryHelper.getItemHandlerIterator((IItemHandler)this.enchants));
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.publicHandler;
    }

    @Override
    public void operate() {
        IBlockState blockState;
        if (!this.extraStacks.stacks.isEmpty()) {
            this.extraStacks.attemptDump((IItemHandler)this.contents);
            return;
        }
        XUBlockState state = this.getBlockState();
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
        BlockPos offset = this.func_174877_v().func_177972_a(side);
        if (this.field_145850_b.func_175623_d(offset)) {
            return;
        }
        if (this.fakePlayer == null) {
            this.fakePlayer = new XUFakePlayer((WorldServer)this.field_145850_b, this.owner, Lang.getItemName(this.getXUBlock()));
        }
        if (StackHelper.isNull(this.diggerTool)) {
            this.diggerTool = genericDigger.func_77946_l();
            ItemStack enchantsStack = this.enchants.getStack();
            if (StackHelper.isNonNull(enchantsStack)) {
                EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)enchantsStack), (ItemStack)this.diggerTool);
            }
        }
        if ((blockState = this.field_145850_b.func_180495_p(offset)).func_185904_a().func_76224_d()) {
            return;
        }
        float hardness = blockState.func_185903_a((EntityPlayer)this.fakePlayer, this.field_145850_b, offset);
        if (hardness == 0.0f) {
            return;
        }
        this.fakePlayer.func_184611_a(EnumHand.MAIN_HAND, this.diggerTool.func_77946_l());
        this.fakePlayer.setLocationEdge(offset, side);
        ItemCaptureHandler.startCapturing();
        this.fakePlayer.field_71134_c.func_180237_b(offset);
        LinkedList<ItemStack> stacks = ItemCaptureHandler.stopCapturing();
        for (ItemStack stack : stacks) {
            InventoryHelper.insertWithRunoff((IItemHandler)this.contents, stack, this.extraStacks);
        }
        this.fakePlayer.func_184611_a(EnumHand.MAIN_HAND, StackHelper.empty());
        InventoryPlayer inventory = this.fakePlayer.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!StackHelper.isNonNull(stack) || StackHelper.getStacksize(stack) <= 0) continue;
            InventoryHelper.insertWithRunoff((IItemHandler)this.contents, stack, this.extraStacks);
        }
        this.fakePlayer.clearInventory();
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMiner(player);
    }

    private class ContainerMiner
    extends DynamicContainerTile {
        public ContainerMiner(EntityPlayer player) {
            super(TileMine.this);
            this.addTitle("Miner");
            this.crop();
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    this.addWidget(new WidgetSlotItemHandler((IItemHandler)TileMine.this.contents, x + y * 3, 58 + 18 * x, this.height + 4 + 18 * y));
                }
            }
            this.addWidget(new WidgetSlotItemHandler(TileMine.this.enchants, 0, this.height + 4 + 18, 4){

                @Override
                @SideOnly(value=Side.CLIENT)
                public List<String> getToolTip() {
                    if (!this.func_75216_d()) {
                        return ImmutableList.of((Object)Lang.translate("Enchanted Book"));
                    }
                    return null;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                    super.renderBackground(manager, gui, guiLeft, guiTop);
                    if (!this.func_75216_d()) {
                        ItemStack stack = ItemIngredients.Type.ENCHANTED_BOOK_SKELETON.newStack();
                        gui.renderStack(stack, guiLeft + this.getX() + 1, guiTop + this.getY() + 1, "");
                    }
                }
            });
            this.addWidget(TileAdvInteractor.getRSWidget(140, this.height + 4 + 18, TileMine.this.redstone_state, TileMine.this.pulses));
            this.addWidget(TileMine.this.upgrades.getSpeedUpgradeSlot(140, this.height + 4 + 36));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }
}

