/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.HashMultimap;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.NullRecipe;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonBoolean;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrowTimer;
import com.rwtema.extrautils2.gui.backend.WidgetRawData;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.ConcatItemHandler;
import com.rwtema.extrautils2.itemhandler.IItemHandlerCompat;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.itemhandler.PublicWrapper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerFilter;
import com.rwtema.extrautils2.itemhandler.StackDump;
import com.rwtema.extrautils2.itemhandler.XUCrafter;
import com.rwtema.extrautils2.itemhandler.XUTileItemStackHandler;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.tile.RedstoneState;
import com.rwtema.extrautils2.tile.TileAdvInteractor;
import com.rwtema.extrautils2.tile.TileCrafter;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.ArrayAccess;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileAnalogCrafter
extends TilePower
implements ITickable,
IDynamicHandler {
    private static final byte NO_FACE = -1;
    private static final byte ANY_FACE = 7;
    private static final int TICK_TIME = 4;
    private final SingleStackHandler output = this.registerNBT("output", new SingleStackHandler(){

        @Override
        protected void onContentsChanged() {
            TileAnalogCrafter.this.func_70296_d();
        }
    });
    private final StackDump extraStacks = this.registerNBT("extrastacks", new StackDump());
    private final SingleStackHandlerFilter.ItemFilter[] filters;
    private final NBTSerializable.Int progress = this.registerNBT("progress", new NBTSerializable.Int());
    private final NBTSerializable.Int max_progress = this.registerNBT("max_progress", new NBTSerializable.Int(-1));
    private final NBTSerializable.NBTBoolean sticky = this.registerNBT("sticky", new NBTSerializable.NBTBoolean(false));
    private final NBTSerializable.NBTBoolean spread = this.registerNBT("spread", new NBTSerializable.NBTBoolean(false));
    public NBTSerializable.NBTEnum<RedstoneState> redstone_state = this.registerNBT("redstone", new NBTSerializable.NBTEnum<RedstoneState>(RedstoneState.OPERATE_ALWAYS));
    public NBTSerializable.NBTBoolean powered = this.registerNBT("powered", new NBTSerializable.NBTBoolean());
    public NBTSerializable.Int pulses = this.registerNBT("pulses", new NBTSerializable.Int());
    NBTSerializable.NBTByteArray slot_sides = this.registerNBT("slot_sides", new NBTSerializable.NBTByteArray(new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7}));
    XUCrafter crafter = new XUCrafter();
    IRecipe curRecipe;
    private final ItemStackHandler contents = this.registerNBT("contents", new XUTileItemStackHandler(9, this){

        protected int getStackLimit(int slot, @ItemStackNonNull ItemStack stack) {
            if (!TileAnalogCrafter.this.filters[slot].matches(stack) || TileAnalogCrafter.this.slot_sides.array[slot] == -1) {
                return 0;
            }
            return super.getStackLimit(slot, stack);
        }

        public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
            super.setStackInSlot(slot, stack);
            TileAnalogCrafter.this.curRecipe = null;
        }

        @ItemStackNonNull
        public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
            if (!simulate && StackHelper.isNonNull(stack) && StackHelper.isNull(this.getStackInSlot(slot))) {
                TileAnalogCrafter.this.curRecipe = null;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @ItemStackNonNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = super.extractItem(slot, amount, simulate);
            if (!simulate && StackHelper.isNonNull(stack) && StackHelper.isNull(this.getStackInSlot(slot))) {
                TileAnalogCrafter.this.curRecipe = null;
            }
            return stack;
        }
    });
    private IItemHandler[] sideHandlers;
    private PublicWrapper.Extract extractHandler = new PublicWrapper.Extract(this.output);

    public TileAnalogCrafter() {
        this.filters = new SingleStackHandlerFilter.ItemFilter[9];
        for (int i = 0; i < 9; ++i) {
            this.filters[i] = new SingleStackHandlerFilter.ItemFilter(){

                @Override
                protected void onContentsChanged() {
                    TileAnalogCrafter.this.func_70296_d();
                }
            };
        }
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        if (facing == null) {
            return this.contents;
        }
        return this.getSideHandler(facing.ordinal());
    }

    public IItemHandler getSideHandler(int face) {
        IItemHandler sideHandler;
        IItemHandler[] sideHandlers = this.sideHandlers;
        if (sideHandlers == null) {
            this.sideHandlers = sideHandlers = new IItemHandlerCompat[6];
        }
        if ((sideHandler = sideHandlers[face]) == null) {
            TIntHashSet slots = new TIntHashSet();
            for (int i = 0; i < 9; ++i) {
                byte side = this.slot_sides.array[i];
                if (side != face && side != 7) continue;
                slots.add(i);
            }
            if (slots.isEmpty()) {
                sideHandlers[face] = this.extractHandler;
            } else {
                final int[] slotArray = slots.toArray();
                sideHandler = ConcatItemHandler.concatNonNull(new IItemHandlerModifiableCompat(){

                    @Override
                    public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
                        TileAnalogCrafter.this.contents.setStackInSlot(slotArray[slot], stack);
                    }

                    @Override
                    public int getSlots() {
                        return slotArray.length;
                    }

                    @Override
                    @ItemStackNonNull
                    public ItemStack getStackInSlot(int slot) {
                        return TileAnalogCrafter.this.contents.getStackInSlot(slotArray[slot]);
                    }

                    @Override
                    @ItemStackNonNull
                    public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
                        return TileAnalogCrafter.this.contents.insertItem(slotArray[slot], stack, simulate);
                    }

                    @Override
                    @ItemStackNonNull
                    public ItemStack extractItem(int slot, int amount, boolean simulate) {
                        return StackHelper.empty();
                    }
                }, this.extractHandler);
            }
            sideHandlers[face] = sideHandler;
        }
        return sideHandler;
    }

    private IRecipe getRecipe() {
        if (this.curRecipe != null) {
            return this.curRecipe;
        }
        this.crafter.loadStacks((IItemHandler)this.contents);
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            try {
                if (recipe.func_77570_a() > 9 || !recipe.func_77569_a((InventoryCrafting)this.crafter, this.field_145850_b)) continue;
                this.curRecipe = recipe;
                return recipe;
            }
            catch (Exception err) {
                throw new RuntimeException("Caught exception while querying recipe " + TileCrafter.errLog(recipe), err);
            }
        }
        if (this.curRecipe == null) {
            this.curRecipe = NullRecipe.INSTANCE;
        }
        return this.curRecipe;
    }

    @Override
    public float getPower() {
        return Float.NaN;
    }

    @Override
    public void onPowerChanged() {
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.extraStacks.hasStacks()) {
            this.extraStacks.attemptDump(this.output);
        }
        if (this.field_145850_b.func_82737_E() % 4L != 0L) {
            return;
        }
        IRecipe recipe = this.getRecipe();
        if (recipe == NullRecipe.INSTANCE) {
            this.progress.value = 0;
            this.max_progress.value = -1;
            return;
        }
        if (this.spread.value) {
            this.trySpreadItems();
        }
        switch ((RedstoneState)((Object)this.redstone_state.value)) {
            case OPERATE_REDSTONE_ON: {
                if (this.powered.value) break;
                this.max_progress.value = 0;
                this.progress.value = 0;
                return;
            }
            case OPERATE_REDSTONE_OFF: {
                if (!this.powered.value) break;
                this.max_progress.value = 0;
                this.progress.value = 0;
                return;
            }
            case OPERATE_REDSTONE_PULSE: {
                if (this.pulses.value != 0) break;
                this.max_progress.value = 0;
                this.progress.value = 0;
                return;
            }
        }
        if (this.sticky.value) {
            for (int i = 0; i < this.contents.getSlots(); ++i) {
                ItemStack stackInSlot = this.contents.getStackInSlot(i);
                if (!StackHelper.isNonNull(stackInSlot) || StackHelper.getStacksize(stackInSlot) != 1 || stackInSlot.func_77976_d() <= 1) continue;
                this.progress.value = 0;
                this.max_progress.value = 0;
                return;
            }
        }
        this.crafter.loadStacks((IItemHandler)this.contents);
        if (!recipe.func_77569_a((InventoryCrafting)this.crafter, this.field_145850_b)) {
            return;
        }
        ItemStack craftingResult = recipe.func_77572_b((InventoryCrafting)this.crafter);
        if (StackHelper.isNull(craftingResult) || StackHelper.isNonNull(this.output.insertItem(0, craftingResult, true))) {
            this.max_progress.value = 0;
            this.progress.value = 0;
            return;
        }
        if (this.max_progress.value <= 0) {
            this.max_progress.value = StackHelper.getStacksize(craftingResult) * 4 * 5;
        }
        this.progress.value += 4;
        if (this.progress.value >= this.max_progress.value) {
            if (this.pulses.value > 0) {
                --this.pulses.value;
            }
            this.progress.value = 0;
            this.output.insertItem(0, craftingResult, false);
            ArrayAccess<ItemStack> remainingStacks = CompatHelper.getArray10List11(CraftingManager.func_77594_a().func_180303_b((InventoryCrafting)this.crafter, this.field_145850_b));
            for (int i = 0; i < remainingStacks.length(); ++i) {
                ItemStack curStack = this.crafter.func_70301_a(i);
                ItemStack remainStack = remainingStacks.get(i);
                if (StackHelper.isNonNull(curStack)) {
                    this.contents.extractItem(i, 1, false);
                }
                if (!StackHelper.isNonNull(remainStack) || !StackHelper.isNonNull(remainStack = this.contents.insertItem(i, remainStack, false))) continue;
                this.extraStacks.addStack(remainStack);
            }
        }
    }

    private void trySpreadItems() {
        HashMultimap slotMap = HashMultimap.create();
        for (int i = 0; i < 9; ++i) {
            ItemRef itemRef;
            ItemStack stackInSlot = this.contents.getStackInSlot(i);
            if (StackHelper.isNull(stackInSlot) || stackInSlot.func_77976_d() == 1 || (itemRef = ItemRef.wrap(stackInSlot)) == ItemRef.NULL) continue;
            slotMap.put((Object)itemRef, (Object)i);
        }
        if (slotMap.isEmpty()) {
            return;
        }
        for (ItemRef ref : slotMap.keySet()) {
            ItemStack biggestStack;
            ItemStack smallestStack;
            int t;
            Set set = slotMap.get((Object)ref);
            if (set.size() <= 1) continue;
            int biggestSlot = -1;
            int biggestSize = -1;
            int smallestSlot = -1;
            int smallestSize = Integer.MAX_VALUE;
            for (Integer slot : set) {
                ItemStack stackInSlot = this.contents.getStackInSlot(slot.intValue());
                if (StackHelper.isNull(stackInSlot)) continue;
                int stacksize = StackHelper.getStacksize(stackInSlot);
                if (biggestSize < stacksize) {
                    biggestSize = stacksize;
                    biggestSlot = slot;
                }
                if (smallestSize <= stacksize) continue;
                smallestSize = stacksize;
                smallestSlot = slot;
            }
            if (smallestSlot == biggestSlot || (t = biggestSize - smallestSize) < 2 || !ItemHandlerHelper.canItemStacksStack((ItemStack)(smallestStack = this.contents.getStackInSlot(smallestSlot)), (ItemStack)(biggestStack = this.contents.getStackInSlot(biggestSlot)))) continue;
            StackHelper.increase(smallestStack);
            StackHelper.decrease(biggestStack);
            this.func_70296_d();
        }
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        boolean newPower;
        boolean wasPowered = this.powered.value;
        boolean bl = newPower = worldIn.func_175687_A(pos) > 0;
        if (newPower != wasPowered) {
            this.powered.value = newPower;
            if (newPower && this.redstone_state.value == RedstoneState.OPERATE_REDSTONE_PULSE) {
                ++this.pulses.value;
            }
        }
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerAnalogCrafter(this, player);
    }

    public static class ContainerAnalogCrafter
    extends DynamicContainerTile {
        static final TByteObjectHashMap<float[]> side_colors = new TByteObjectHashMap();

        public ContainerAnalogCrafter(final TileAnalogCrafter tile, EntityPlayer player) {
            super(tile);
            this.addTitle(Lang.getItemName((Block)XU2Entries.analogCrafter.value));
            this.crop();
            int u = this.height;
            int l2 = 4;
            this.addWidget(new WidgetProgressArrowTimer(l2 + 54 + 4, u + 18){

                @Override
                protected float getTime() {
                    return ((TileAnalogCrafter)tile).progress.value;
                }

                @Override
                protected float getMaxTime() {
                    return ((TileAnalogCrafter)tile).max_progress.value;
                }
            });
            this.addWidget(new WidgetSlotItemHandler(tile.extractHandler, 0, l2 + 54 + 22 + 8, u + 18));
            this.addWidget(new WidgetRawData(){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    packet.writeBytes(tile.slot_sides.array);
                }

                @Override
                public void handleDescriptionPacket(XUPacketBuffer packet) {
                    packet.data.readBytes(tile.slot_sides.array);
                }
            });
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    final int i = x + y * 3;
                    this.addWidget(new WidgetSlotItemHandler((IItemHandler)tile.contents, i, l2 + x * 18, u + y * 18){

                        @Override
                        public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                            float[] cols = (float[])side_colors.get(tile.slot_sides.array[i]);
                            if (cols != null) {
                                GlStateManager.func_179131_c((float)cols[0], (float)cols[1], (float)cols[2], (float)1.0f);
                            }
                            super.renderBackground(manager, gui, guiLeft, guiTop);
                            if (cols != null) {
                                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            }
                        }
                    });
                    WidgetClickMCButtonChoices<Byte> button = new WidgetClickMCButtonChoices<Byte>(l2 + 8 + 54 + 22 + 8 + 18 + 18 * x, u + y * 18){

                        @Override
                        protected void onSelectedServer(Byte marker) {
                            tile.slot_sides.array[i] = marker;
                        }

                        @Override
                        public Byte getSelectedValue() {
                            return tile.slot_sides.array[i];
                        }
                    };
                    button.addChoice(Byte.valueOf((byte)-1), "x", Lang.translate("Disabled"));
                    for (EnumFacing facing : EnumFacing.values()) {
                        button.addChoice(Byte.valueOf((byte)facing.ordinal()), facing.func_176742_j().substring(0, 1).toLowerCase(Locale.ENGLISH), Lang.translate(StringHelper.capFirst(facing.func_176742_j()) + " Only"));
                    }
                    button.addChoice(Byte.valueOf((byte)7), "a", Lang.translate("Accessible from all Sides"));
                    this.addWidget(button);
                }
            }
            this.crop();
            WidgetClickMCButtonBoolean.NBTBoolean w = new WidgetClickMCButtonBoolean.NBTBoolean(4, this.height + 4, tile.sticky, Lang.translate("Sticky"), Lang.translate("Keep at least one item in each slot (does not apply to items that do not stack)"));
            this.addWidget(w);
            this.addWidget(new WidgetClickMCButtonBoolean.NBTBoolean(w.getX() + w.getW() + 4, this.height + 4, tile.spread, Lang.translate("Spread Items"), Lang.translate("Distribute input items evenly among existing stacks")));
            this.crop();
            this.addWidget(TileAdvInteractor.getRSWidget(4, this.height + 4, tile.redstone_state, tile.pulses));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }

        static {
            side_colors.put((byte)-1, (Object)new float[]{0.7f, 0.7f, 0.7f});
            side_colors.put((byte)7, (Object)new float[]{1.0f, 1.0f, 1.0f});
            side_colors.put((byte)0, (Object)new float[]{1.0f, 0.7f, 1.0f});
            side_colors.put((byte)1, (Object)new float[]{0.7f, 1.0f, 1.0f});
            side_colors.put((byte)2, (Object)new float[]{1.0f, 0.7f, 0.7f});
            side_colors.put((byte)3, (Object)new float[]{0.7f, 0.7f, 1.0f});
            side_colors.put((byte)4, (Object)new float[]{0.7f, 1.0f, 0.7f});
            side_colors.put((byte)5, (Object)new float[]{1.0f, 1.0f, 0.7f});
        }
    }
}

