/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.api.machine.RecipeBuilder;
import com.rwtema.extrautils2.compatibility.StackHelper;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class GenericMachineRecipe
implements IMachineRecipe {
    protected final Machine machine;
    protected final Map<MachineSlotItem, List<ItemStack>> inputItemStackMap;
    protected final Map<MachineSlotFluid, List<String>> inputFluidStackMap;
    protected final Map<MachineSlotItem, List<ItemStack>> outputItemStackMap;
    protected final Map<MachineSlotFluid, String> outputFluidStackMap;
    protected final TObjectIntMap<MachineSlot> inputAmountMap;
    protected final TObjectIntMap<MachineSlot> outputAmountMap;
    protected final TObjectFloatHashMap<MachineSlot> outputProbabilities;
    protected boolean hasMultipleOutputs;
    protected int energyOutput;
    protected int processingTime;

    public GenericMachineRecipe(Machine machine, Map<MachineSlotItem, List<ItemStack>> inputItemStackMap, Map<MachineSlotFluid, List<String>> inputFluidStackMap, Map<MachineSlotItem, List<ItemStack>> outputItemStackMap, Map<MachineSlotFluid, String> outputFluidStackMap, TObjectIntMap<MachineSlot> inputAmountMap, TObjectIntMap<MachineSlot> outputAmountMap, int processingTime, int energyOutput, TObjectFloatHashMap<MachineSlot> outputProbabilities) {
        this.machine = machine;
        this.inputItemStackMap = ImmutableMap.copyOf(inputItemStackMap);
        this.inputFluidStackMap = ImmutableMap.copyOf(inputFluidStackMap);
        this.outputItemStackMap = ImmutableMap.copyOf(outputItemStackMap);
        this.outputFluidStackMap = ImmutableMap.copyOf(outputFluidStackMap);
        this.outputAmountMap = outputAmountMap;
        this.processingTime = processingTime;
        this.energyOutput = energyOutput;
        this.inputAmountMap = inputAmountMap;
        this.hasMultipleOutputs = !outputItemStackMap.values().stream().allMatch(itemStacks -> itemStacks.size() <= 1 && itemStacks instanceof ImmutableList);
        this.outputProbabilities = outputProbabilities;
    }

    @Override
    public List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>> getJEIInputItemExamples() {
        if (!this.inputItemStackMap.isEmpty() && this.inputItemStackMap.values().stream().noneMatch(itemStacks -> itemStacks != null && !itemStacks.isEmpty())) {
            return ImmutableList.of();
        }
        if (!this.outputItemStackMap.isEmpty() && this.outputItemStackMap.values().stream().noneMatch(itemStacks -> itemStacks != null && !itemStacks.isEmpty())) {
            return ImmutableList.of();
        }
        if (!this.inputFluidStackMap.isEmpty() && this.inputFluidStackMap.values().stream().noneMatch(s -> s != null && s.stream().anyMatch(t -> t != null && FluidRegistry.isFluidRegistered((String)t)))) {
            return ImmutableList.of();
        }
        if (!this.outputFluidStackMap.isEmpty() && this.outputFluidStackMap.values().stream().noneMatch(s -> s != null && FluidRegistry.isFluidRegistered((String)s))) {
            return ImmutableList.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.inputFluidStackMap.forEach((machineSlotFluid, fluidStacks) -> {
            int amount = this.inputAmountMap.get(machineSlotFluid);
            builder.put(machineSlotFluid, fluidStacks.stream().map(t -> FluidRegistry.isFluidRegistered((String)t) ? FluidRegistry.getFluidStack((String)t, (int)amount) : null).collect(Collectors.toList()));
        });
        return ImmutableList.of((Object)Pair.of((Object)ImmutableMap.copyOf(this.inputItemStackMap), (Object)builder.build()));
    }

    @Override
    public boolean allowInputItem(MachineSlotItem slot, ItemStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        return this.checkForValidOutput() && this.matchesSlotItem(slot, stack) && this.checkExistingItems(existingItems, existingFluids);
    }

    public boolean checkExistingItems(Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        for (Map.Entry<MachineSlotItem, ItemStack> entry2 : existingItems.entrySet()) {
            if (this.matchesSlotItem(entry2.getKey(), entry2.getValue())) continue;
            return false;
        }
        for (Map.Entry<MachineSlot, Object> entry3 : existingFluids.entrySet()) {
            if (this.matchesSlotFluid((MachineSlotFluid)entry3.getKey(), (FluidStack)entry3.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean matchesSlotItem(MachineSlotItem slot, ItemStack stack) {
        for (ItemStack itemStack : this.inputItemStackMap.get(slot)) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)itemStack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowInputFluid(MachineSlotFluid slot, FluidStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        return this.checkForValidOutput() && this.matchesSlotFluid(slot, stack) && this.checkExistingItems(existingItems, existingFluids);
    }

    public boolean matchesSlotFluid(MachineSlotFluid slot, FluidStack stack) {
        if (stack != null) {
            for (String fluidName : this.inputFluidStackMap.get(slot)) {
                if (fluidName == null || !fluidName.matches(stack.getFluid().getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matches(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        ItemStack stack;
        if (!this.checkForValidOutput()) {
            return false;
        }
        for (MachineSlotItem slotItem : this.machine.itemInputs) {
            stack = inputItems.get(slotItem);
            if (!(StackHelper.isNull(stack) ? !slotItem.optional : !this.matchesSlotItem(slotItem, stack) || this.inputAmountMap.get((Object)slotItem) > StackHelper.getStacksize(stack))) continue;
            return false;
        }
        for (MachineSlotFluid slotFluid : this.machine.fluidInputs) {
            stack = inputFluids.get(slotFluid);
            if (!(stack == null ? !slotFluid.optional : !this.matchesSlotFluid(slotFluid, (FluidStack)stack) || this.inputAmountMap.get((Object)slotFluid) > stack.amount)) continue;
            return false;
        }
        return true;
    }

    private boolean checkForValidOutput() {
        return !(!this.outputItemStackMap.isEmpty() && this.outputItemStackMap.values().stream().noneMatch(itemStacks -> itemStacks != null && !itemStacks.isEmpty()) || !this.outputFluidStackMap.isEmpty() && this.outputFluidStackMap.values().stream().noneMatch(s -> s != null && FluidRegistry.isFluidRegistered((String)s)));
    }

    @Override
    public Map<MachineSlotItem, ItemStack> getItemOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        HashMap<MachineSlotItem, ItemStack> map = new HashMap<MachineSlotItem, ItemStack>();
        if (this.hasMultipleOutputs) {
            Set mods = inputItems.values().stream().filter(stack -> StackHelper.isNonNull(stack)).map(stack -> stack.func_77973_b().getRegistryName().func_110624_b()).collect(Collectors.toSet());
            this.outputItemStackMap.forEach((machineSlotItem, itemStacks) -> {
                int size = this.outputAmountMap.get(machineSlotItem);
                if (size < 0) {
                    size = 0;
                }
                ItemStack bestStack = StackHelper.empty();
                if (size > 0) {
                    for (ItemStack stack : itemStacks) {
                        if (StackHelper.isNull(bestStack)) {
                            bestStack = stack;
                            continue;
                        }
                        String resourceDomain = stack.func_77973_b().getRegistryName().func_110624_b();
                        if (!"minecraft".equals(resourceDomain) && !mods.contains(resourceDomain)) continue;
                        bestStack = stack;
                        break;
                    }
                }
                map.put((MachineSlotItem)machineSlotItem, this.makeSafe(ItemHandlerHelper.copyStackWithSize((ItemStack)bestStack, (int)size)));
            });
        } else {
            this.outputItemStackMap.forEach((machineSlotItem, stack) -> {
                int size = this.outputAmountMap.get(machineSlotItem);
                if (size < 0) {
                    size = 0;
                }
                map.put((MachineSlotItem)machineSlotItem, this.makeSafe(ItemHandlerHelper.copyStackWithSize((ItemStack)stack.stream().findAny().orElse(null), (int)size)));
            });
        }
        return map;
    }

    private ItemStack makeSafe(ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return StackHelper.empty();
        }
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        return stack;
    }

    @Override
    public Map<MachineSlotFluid, FluidStack> getFluidOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        HashMap<MachineSlotFluid, FluidStack> map = new HashMap<MachineSlotFluid, FluidStack>();
        this.outputFluidStackMap.forEach((machineSlotFluid, s) -> {
            FluidStack cfr_ignored_0 = map.put((MachineSlotFluid)machineSlotFluid, s != null && FluidRegistry.isFluidRegistered((String)s) ? FluidRegistry.getFluidStack((String)s, (int)this.outputAmountMap.get(machineSlotFluid)) : null);
        });
        return map;
    }

    @Override
    public int getEnergyOutput(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.energyOutput;
    }

    @Override
    public int getProcessingTime(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.processingTime;
    }

    @Override
    public TObjectIntMap<MachineSlot> getAmountToConsume(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.inputAmountMap;
    }

    @Override
    @Nullable
    public TObjectFloatMap<MachineSlot> getProbabilityModifier(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.outputProbabilities;
    }

    public static class Builder
    implements RecipeBuilder {
        protected final HashMap<MachineSlotItem, List<ItemStack>> inputItemStackMap = new HashMap();
        protected final HashMap<MachineSlotFluid, List<String>> inputFluidStackMap = new HashMap();
        protected final HashMap<MachineSlotItem, List<ItemStack>> outputItemStackMap = new HashMap();
        protected final HashMap<MachineSlotFluid, String> outputFluidStackMap = new HashMap();
        protected final TObjectIntHashMap<MachineSlot> inputAmountMap = new TObjectIntHashMap();
        protected final Machine machine;
        protected final TObjectIntMap<MachineSlot> outputAmountMap = new TObjectIntHashMap();
        protected final TObjectFloatHashMap<MachineSlot> outputProbabilities = new TObjectFloatHashMap();
        protected int energy;
        protected int processingTime;

        public Builder(Machine machine) {
            this.machine = machine;
            this.energy = machine.defaultEnergy;
            this.processingTime = machine.defaultProcessingTime;
        }

        @Override
        public RecipeBuilder setEnergy(int amount) {
            Validate.isTrue((amount >= 0 ? 1 : 0) != 0);
            this.energy = amount;
            return this;
        }

        @Override
        public RecipeBuilder setProcessingTime(int time) {
            Validate.isTrue((time > 0 ? 1 : 0) != 0, (String)"Negative/Zero processing times are not allowed %s", (long)time);
            this.processingTime = time;
            return this;
        }

        @Override
        public RecipeBuilder setRFRate(int energy, float rfRate) {
            this.setEnergy(energy);
            this.setProcessingTime((int)Math.ceil((float)energy / rfRate));
            return this;
        }

        @Override
        public RecipeBuilder setItemInput(@Nonnull MachineSlotItem slot, @Nonnull ItemStack input) {
            return this.setItemInput(slot, input, StackHelper.getStacksize(input));
        }

        @Override
        public RecipeBuilder setItemInput(@Nonnull MachineSlotItem slot, @Nonnull ItemStack input, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputItemStackMap.put(slot, (List<ItemStack>)ImmutableList.of((Object)input.func_77946_l()));
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setItemInput(@Nonnull MachineSlotItem slot, @Nonnull String string, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputItemStackMap.put(slot, OreDictionary.getOres((String)string));
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setItemInput(@Nonnull MachineSlotItem slot, @Nonnull List<ItemStack> stacks, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputItemStackMap.put(slot, stacks);
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setItemOutput(@Nonnull MachineSlotItem slot, ItemStack stack) {
            if (StackHelper.isNonNull(stack)) {
                this.outputItemStackMap.put(slot, (List<ItemStack>)ImmutableList.of((Object)stack));
                this.outputAmountMap.put((Object)slot, StackHelper.getStacksize(stack));
            } else {
                this.outputAmountMap.put((Object)slot, 0);
            }
            return this;
        }

        @Override
        public RecipeBuilder setItemOutput(MachineSlotItem slot, ItemStack stack, int amount) {
            if (StackHelper.isNonNull(stack)) {
                this.outputItemStackMap.put(slot, (List<ItemStack>)ImmutableList.of((Object)stack));
                this.outputAmountMap.put((Object)slot, amount);
            } else {
                this.outputAmountMap.put((Object)slot, 0);
            }
            return this;
        }

        @Override
        public RecipeBuilder setItemOutput(@Nonnull MachineSlotItem slot, @Nonnull String oreName, int amount) {
            this.outputItemStackMap.put(slot, OreDictionary.getOres((String)oreName));
            this.outputAmountMap.put((Object)slot, amount);
            return this;
        }

        @Override
        public RecipeBuilder setItemOutput(@Nonnull MachineSlotItem slot, @Nonnull List<ItemStack> ores, int amount) {
            this.outputItemStackMap.put(slot, ores);
            this.outputAmountMap.put((Object)slot, amount);
            return this;
        }

        @Override
        public RecipeBuilder setFluidInputFluidName(@Nonnull MachineSlotFluid slot, @Nonnull String fluidName, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputFluidStackMap.put(slot, (List<String>)ImmutableList.of((Object)fluidName));
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setFluidInputFluidStack(@Nonnull MachineSlotFluid slot, @Nonnull FluidStack input) {
            return this.setFluidInputFluidStack(slot, input, input.amount);
        }

        @Override
        public RecipeBuilder setFluidInputFluidStack(@Nonnull MachineSlotFluid slot, @Nonnull FluidStack input, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputFluidStackMap.put(slot, (List<String>)ImmutableList.of((Object)input.getFluid().getName()));
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setFluidInputFluidNameList(@Nonnull MachineSlotFluid slot, @Nonnull List<String> fluidNames, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputAmountMap.put((Object)slot, n);
            this.inputFluidStackMap.put(slot, (List<String>)ImmutableList.copyOf(fluidNames));
            return this;
        }

        @Override
        public RecipeBuilder setFluidInputFluidStackList(@Nonnull MachineSlotFluid slot, @Nonnull List<FluidStack> stacks, int n) {
            Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"n=%s must be positive", (long)n);
            this.inputFluidStackMap.put(slot, stacks.stream().map(t -> t.getFluid().getName()).collect(Collectors.toList()));
            this.inputAmountMap.put((Object)slot, n);
            return this;
        }

        @Override
        public RecipeBuilder setFluidOutput(@Nonnull MachineSlotFluid slot, FluidStack stack) {
            return this.setFluidOutput(slot, stack, stack.amount);
        }

        @Override
        public RecipeBuilder setFluidOutput(@Nonnull MachineSlotFluid slot, FluidStack stack, int amount) {
            return this.setFluidOutput(slot, stack.getFluid().getName(), amount);
        }

        @Override
        public RecipeBuilder setFluidOutput(@Nonnull MachineSlotFluid slot, String name, int amount) {
            this.outputFluidStackMap.put(slot, name);
            this.outputAmountMap.put((Object)slot, amount);
            return this;
        }

        @Override
        public RecipeBuilder setProbability(@Nonnull MachineSlot outputSlot, float probability) {
            this.outputProbabilities.put((Object)outputSlot, probability);
            return this;
        }

        @Override
        public IMachineRecipe build() {
            if (this.processingTime < 0) {
                throw new IllegalArgumentException("processing time not set and has no default");
            }
            if (this.energy < 0) {
                throw new IllegalArgumentException("energy not set and has no default");
            }
            for (MachineSlotItem slotItem : this.machine.itemInputs) {
                if (slotItem.optional) continue;
                Validate.isTrue((boolean)this.inputItemStackMap.containsKey(slotItem), (String)"Slot %s has no input", (Object[])new Object[]{slotItem});
                Validate.isTrue((boolean)this.inputAmountMap.containsKey((Object)slotItem), (String)"Slot %s was not assigned an amount", (Object[])new Object[]{slotItem});
            }
            for (MachineSlotFluid slotFluid : this.machine.fluidInputs) {
                if (slotFluid.optional) continue;
                Validate.isTrue((boolean)this.inputFluidStackMap.containsKey(slotFluid), (String)"Slot %s has no input", (Object[])new Object[]{slotFluid});
                Validate.isTrue((boolean)this.inputAmountMap.containsKey((Object)slotFluid), (String)"Slot %s was not assigned an amount", (Object[])new Object[]{slotFluid});
            }
            for (MachineSlotItem slotItem : this.machine.itemOutputs) {
                if (slotItem.optional) continue;
                Validate.isTrue((boolean)this.outputItemStackMap.containsKey(slotItem), (String)"Slot %s has no output", (Object[])new Object[]{slotItem});
            }
            for (MachineSlotFluid slotFluid : this.machine.fluidOutputs) {
                if (slotFluid.optional) continue;
                Validate.isTrue((boolean)this.outputFluidStackMap.containsKey(slotFluid), (String)"Slot %s has no output", (Object[])new Object[]{slotFluid});
            }
            return this.getGenericMachineRecipe(this.machine, this.inputItemStackMap, this.inputFluidStackMap, this.outputItemStackMap, this.outputFluidStackMap, this.inputAmountMap, this.processingTime, this.energy, this.outputAmountMap, this.outputProbabilities);
        }

        @Override
        @Nonnull
        public Machine getMachine() {
            return this.machine;
        }

        @Nonnull
        protected GenericMachineRecipe getGenericMachineRecipe(Machine machine, HashMap<MachineSlotItem, List<ItemStack>> inputItemStackMap, HashMap<MachineSlotFluid, List<String>> inputFluidStackMap, Map<MachineSlotItem, List<ItemStack>> outputItemStackMap, HashMap<MachineSlotFluid, String> outputFluidStackMap, TObjectIntHashMap<MachineSlot> amount, int processingTime, int energyOutput, TObjectIntMap<MachineSlot> outputAmountMap, TObjectFloatHashMap<MachineSlot> outputProbabilities) {
            return new GenericMachineRecipe(machine, (Map<MachineSlotItem, List<ItemStack>>)inputItemStackMap, (Map<MachineSlotFluid, List<String>>)inputFluidStackMap, outputItemStackMap, (Map<MachineSlotFluid, String>)outputFluidStackMap, (TObjectIntMap<MachineSlot>)amount, outputAmountMap, processingTime, energyOutput, outputProbabilities);
        }
    }
}

