/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.api.machine.RecipeBuilder;
import com.rwtema.extrautils2.api.machine.XUMachineCrusher;
import com.rwtema.extrautils2.api.machine.XUMachineFurnace;
import com.rwtema.extrautils2.api.machine.XUMachineGenerators;
import com.rwtema.extrautils2.crafting.XUShapedRecipe;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.items.itemmatching.IMatcherMaker;
import com.rwtema.extrautils2.machine.BrewingEnergyRecipe;
import com.rwtema.extrautils2.machine.DischantEnergyRecipe;
import com.rwtema.extrautils2.machine.EnergyBaseRecipe;
import com.rwtema.extrautils2.machine.FoodEnergyRecipe;
import com.rwtema.extrautils2.machine.FurnaceRecipe;
import com.rwtema.extrautils2.machine.PinkRecipe;
import com.rwtema.extrautils2.recipes.GenericMachineRecipe;
import com.rwtema.extrautils2.recipes.SingleInputStackToStackRecipeCached;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class MachineInit {
    static HashSet<String> registeredDusts = Sets.newHashSet((Object[])new String[]{"dustIron", "dustGold", "dustCopper", "dustTin", "dustLead", "dustSilver", "dustNickel", "dustPlatinum"});

    @SubscribeEvent
    public static void onOreRegister(OreDictionary.OreRegisterEvent event) {
        String name = event.getName();
        if (name.startsWith("ingot") || name.startsWith("ore") || name.startsWith("dust")) {
            HashSet oreNames = Sets.newHashSet((Object[])OreDictionary.getOreNames());
            for (String dust : oreNames) {
                if (!dust.startsWith("dust") || registeredDusts.contains(dust)) continue;
                String ore = Pattern.compile("dust", 16).matcher(dust).replaceFirst("ore");
                String ingot = Pattern.compile("dust", 16).matcher(dust).replaceFirst("ingot");
                if (!oreNames.contains(ore) || !oreNames.contains(ingot)) continue;
                MachineInit.addCrusherOreRecipe(ore, dust, 2);
                MachineInit.addCrusherOreRecipe(ingot, dust, 1);
                registeredDusts.add(dust);
            }
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register(MachineInit.class);
        RecipeBuilder.Builder.builder = GenericMachineRecipe.Builder::new;
        XUMachineGenerators.FURNACE_GENERATOR = new Machine("extrautils2:generator", 100000, 1000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 0xFFFFFF, null, null, null, null);
        XUMachineGenerators.SURVIVALIST_GENERATOR = new Machine("extrautils2:generator_survival", 10000, 1000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 0xFFFFFF, "minecraft:blocks/furnace_top", "minecraft:blocks/furnace_side", "minecraft:blocks/furnace_top", null);
        XUMachineGenerators.CULINARY_GENERATOR = new Machine("extrautils2:generator_culinary", 100000, 8000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 0xFFFFFF, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", "extrautils2:machine/generator/generator_culinary");
        XUMachineGenerators.POTION_GENERATOR = new Machine("extrautils2:generator_potion", 100000, 1000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 5509553, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", "extrautils2:machine/generator/generator_potion");
        XUMachineGenerators.TNT_GENERATOR = new Machine("extrautils2:generator_tnt", 100000, 1000, (List)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 14369818, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", "extrautils2:machine/generator/generator_tnt"){

            @Override
            public void processingTick(TileEntity tileMachine, IMachineRecipe curRecipe, int processTime, int n) {
                World world = tileMachine.func_145831_w();
                Random rand = world.field_73012_v;
                for (int j = 0; j < n; ++j) {
                    if (rand.nextInt(41) != 0) continue;
                    BlockPos pos = tileMachine.func_174877_v();
                    for (int i = 0; i < 10; ++i) {
                        double v = 1.5;
                        double x = (double)pos.func_177958_n() + 0.5 + v * rand.nextGaussian();
                        double y = (double)pos.func_177956_o() + 0.5 + v * rand.nextGaussian();
                        double z = (double)pos.func_177952_p() + 0.5 + v * rand.nextGaussian();
                        BlockPos otherPos = new BlockPos(x, y, z);
                        if (i != 9 && pos.equals((Object)otherPos)) continue;
                        IBlockState state = world.func_180495_p(otherPos);
                        if (i < 5 && state.func_177230_c().func_149638_a(null) != 0.0f) continue;
                        world.func_72885_a(null, x, y, z, 2.0f, false, false);
                        return;
                    }
                }
            }
        };
        XUMachineGenerators.LAVA_GENERATOR = new Machine("extrautils2:generator_lava", 100000, 1000, (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of((Object)XUMachineGenerators.INPUT_FLUID), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 10032418, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", null);
        XUMachineGenerators.PINK_GENERATOR = new Machine("extrautils2:generator_pink", 100000, 100, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 16729424, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", "extrautils2:machine/generator/generator_pink");
        XUMachineGenerators.NETHERSTAR_GENERATOR = new Machine("extrautils2:generator_netherstar", 400000, 400000, (List)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 0xFFFFFF, "extrautils2:machine/generator/machine_base_netherstar", "extrautils2:machine/generator/machine_base_netherstar_side", "extrautils2:machine/generator/machine_base_netherstar_bottom", "extrautils2:machine/generator/generator_netherstar"){

            @Override
            public void processingTick(TileEntity tileMachine, IMachineRecipe curRecipe, int processTime, int n) {
                World world = tileMachine.func_145831_w();
                BlockPos pos = tileMachine.func_174877_v();
                for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72314_b(5.0, 5.0, 5.0))) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 410, (int)Math.floor(Math.sqrt(5 + n)) - 1));
                }
            }
        };
        XUMachineGenerators.ENDER_GENERATOR = new Machine("extrautils2:generator_ender", 100000, 4000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 2458740, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", "extrautils2:machine/generator/generator_ender");
        XUMachineGenerators.REDSTONE_GENERATOR = new Machine("extrautils2:generator_redstone", 100000, 1600, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of((Object)XUMachineGenerators.INPUT_FLUID), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 11161091, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", "extrautils2:machine/generator/generator_redstone");
        XUMachineGenerators.OVERCLOCK_GENERATOR = new Machine("extrautils2:generator_overclock", 1000000, 1000000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 1773488, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", "extrautils2:machine/generator/generator_overclock");
        XUMachineGenerators.DRAGON_GENERATOR = new Machine("extrautils2:generator_dragonsbreath", 1000000, 8000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 0xA77AA7, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", null);
        XUMachineGenerators.ICE_GENERATOR = new Machine("extrautils2:generator_ice", 100000, 1000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator/generator_on_ice", Machine.EnergyMode.GENERATES_ENERGY, 5139615, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", null);
        XUMachineGenerators.DEATH_GENERATOR = new Machine("extrautils2:generator_death", 100000, 1000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 14208412, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", "extrautils2:machine/generator/generator_death");
        XUMachineGenerators.ENCHANT_GENERATOR = new Machine("extrautils2:generator_enchant", 100000, 1000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 3944534, "extrautils2:machine/machine_base_white", "extrautils2:machine/machine_base_white_side", "extrautils2:machine/machine_base_white_bottom", "extrautils2:machine/generator/generator_enchant");
        XUMachineGenerators.SLIME_GENERATOR = new Machine("extrautils2:generator_slime", 100000, 1000, (List<MachineSlotItem>)ImmutableList.of((Object)XUMachineGenerators.INPUT_ITEM), (List<MachineSlotFluid>)ImmutableList.of(), (List<MachineSlotItem>)ImmutableList.of(), (List<MachineSlotFluid>)ImmutableList.of(), "extrautils2:machine/generator_off", "extrautils2:machine/generator_on", Machine.EnergyMode.GENERATES_ENERGY, 0xFFFFFF, "extrautils2:machine/generator/machine_base_slime", "extrautils2:machine/generator/machine_base_slime_side", "extrautils2:machine/generator/machine_base_slime_bottom", null);
    }

    public static void addMachineRecipes() {
        XUMachineFurnace.INSTANCE.recipes_registry.addRecipe(new SingleInputStackToStackRecipeCached(XUMachineFurnace.INPUT, XUMachineFurnace.OUTPUT){

            @Override
            @Nonnull
            public Collection<ItemStack> getInputValues() {
                return FurnaceRecipes.func_77602_a().func_77599_b().keySet();
            }

            @Override
            public ItemStack getResult(@Nonnull ItemStack stack) {
                return FurnaceRecipes.func_77602_a().func_151395_a(stack);
            }

            @Override
            public int getEnergyOutput(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
                return 2000;
            }

            @Override
            public int getProcessingTime(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
                return 100;
            }
        });
        XUMachineGenerators.FURNACE_GENERATOR.recipes_registry.addRecipe(new FurnaceRecipe(){

            @Override
            protected float getEnergyRate(@Nonnull ItemStack itemStack) {
                return 40.0f;
            }
        });
        XUMachineGenerators.SURVIVALIST_GENERATOR.recipes_registry.addRecipe(new FurnaceRecipe(){

            @Override
            protected float getEnergyRate(@Nonnull ItemStack itemStack) {
                return 5.0f;
            }

            @Override
            public int getEnergyOutput(@Nonnull ItemStack itemStack) {
                return super.getEnergyOutput(itemStack) * 5;
            }
        });
        XUMachineGenerators.OVERCLOCK_GENERATOR.recipes_registry.addRecipe(new FurnaceRecipe(){

            @Override
            protected float getEnergyRate(@Nonnull ItemStack itemStack) {
                return 4000.0f;
            }

            @Override
            public int getEnergyOutput(@Nonnull ItemStack itemStack) {
                return super.getEnergyOutput(itemStack) / 10;
            }
        });
        XUMachineGenerators.NETHERSTAR_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Items.field_151156_bN), 9600000, 4000));
        XUMachineGenerators.ENDER_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Items.field_151079_bi), 64000, 40));
        XUMachineGenerators.ENDER_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Items.field_151061_bv), 256000, 80));
        XUMachineGenerators.TNT_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Blocks.field_150335_W), 512000, 160));
        XUMachineGenerators.TNT_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Items.field_151016_H), 64000, 160));
        XUMachineGenerators.PINK_GENERATOR.recipes_registry.addRecipe(new PinkRecipe());
        XUMachineGenerators.PINK_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b())), 400, 40));
        XUMachineGenerators.DRAGON_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Items.field_185157_bK), 480000, 40));
        XUMachineGenerators.ICE_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Blocks.field_150432_aD), 16000));
        XUMachineGenerators.ICE_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Blocks.field_150403_cj), 16000));
        XUMachineGenerators.ICE_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Items.field_151126_ay), 2000));
        XUMachineGenerators.ICE_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Blocks.field_150433_aE), 8000));
        XUMachineGenerators.ICE_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Blocks.field_150431_aC), 1000));
        XUMachineGenerators.DEATH_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Items.field_151103_aS), 16000));
        XUMachineGenerators.DEATH_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Blocks.field_189880_di), 48000));
        XUMachineGenerators.DEATH_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(Items.field_151078_bh), 8000));
        XUMachineGenerators.DEATH_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(ItemRef.wrap(new ItemStack(Items.field_151144_bL, 1, 1)), 60000));
        XUMachineGenerators.LAVA_GENERATOR.recipes_registry.addRecipe(RecipeBuilder.newbuilder(XUMachineGenerators.LAVA_GENERATOR).setRFRate(5000, 40.0f).setFluidInputFluidStack(XUMachineGenerators.INPUT_FLUID, new FluidStack(FluidRegistry.LAVA, 50)).build());
        XUMachineGenerators.REDSTONE_GENERATOR.recipes_registry.addRecipe(RecipeBuilder.newbuilder(XUMachineGenerators.REDSTONE_GENERATOR).setRFRate(20000, 160.0f).setItemInput(XUMachineGenerators.INPUT_ITEM, "dustRedstone", 1).setFluidInputFluidStack(XUMachineGenerators.INPUT_FLUID, new FluidStack(FluidRegistry.LAVA, 50)).build());
        XUMachineGenerators.SLIME_GENERATOR.recipes_registry.addPriorityRecipe(new EnergyBaseRecipe.EnergyBaseItem(new IMatcherMaker.MatcherMakerOreDic("slimeballBlood"), 48000));
        XUMachineGenerators.SLIME_GENERATOR.recipes_registry.addPriorityRecipe(new EnergyBaseRecipe.EnergyBaseItem(new IMatcherMaker.MatcherMakerOreDic("slimeballPurple"), 48000));
        XUMachineGenerators.SLIME_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(new IMatcherMaker.MatcherMakerOreDic("slimeball").addExceptions("slimeballPurple", "slimeballBlood"), 16000));
        XUMachineGenerators.SLIME_GENERATOR.recipes_registry.addRecipe(new EnergyBaseRecipe.EnergyBaseItem(new IMatcherMaker.MatcherMakerOreDic("blockSlime"), 144000));
        XUMachineGenerators.POTION_GENERATOR.recipes_registry.addRecipe(new BrewingEnergyRecipe());
        XUMachineGenerators.ENCHANT_GENERATOR.recipes_registry.addRecipe(new DischantEnergyRecipe());
        XUMachineGenerators.CULINARY_GENERATOR.recipes_registry.addRecipe(new FoodEnergyRecipe());
        XUMachineCrusher.addRecipe(new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151065_br, 2), new ItemStack(Items.field_151065_br, 3), 0.4f);
        XUMachineCrusher.addRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.WHITE.func_176767_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.WHITE.func_176767_b()), 0.5f);
        for (int i = 0; i < 16; ++i) {
            ItemStack outputSecondary = 15 - i != 4 ? new ItemStack(Items.field_151100_aR, 1, 15 - i) : ItemIngredients.Type.DYE_POWDER_BLUE.newStack();
            XUMachineCrusher.addRecipe(new ItemStack(Blocks.field_150325_L, 1, i), new ItemStack(Items.field_151007_F, 3), outputSecondary, 0.05f);
            XUMachineCrusher.addRecipe(new ItemStack(Blocks.field_150404_cg, 1, i), new ItemStack(Items.field_151007_F, 2), outputSecondary, 0.05f);
        }
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150327_N, 1, BlockFlower.EnumFlowerType.DANDELION.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.YELLOW.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.RED.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.LIGHT_BLUE.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.MAGENTA.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.SILVER.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.RED.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ORANGE_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.ORANGE.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.SILVER.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.PINK.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.SILVER.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a()), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.YELLOW.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SYRINGA.func_176936_a()), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.MAGENTA.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.RED.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.PAEONIA.func_176936_a()), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.PINK.func_176767_b()));
        XUMachineCrusher.addRecipe(new ItemStack(Items.field_185164_cV, 1), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.RED.func_176767_b()));
        ImmutableList pairedOres = ImmutableList.of((Object)Pair.of((Object)"Iron", (Object)"Gold"), (Object)Pair.of((Object)"Gold", (Object)"Iron"), (Object)Pair.of((Object)"Copper", (Object)"Tin"), (Object)Pair.of((Object)"Tin", (Object)"Copper"), (Object)Pair.of((Object)"Lead", (Object)"Silver"), (Object)Pair.of((Object)"Silver", (Object)"Lead"), (Object)Pair.of((Object)"Nickel", (Object)"Platinum"), (Object)Pair.of((Object)"Platinum", (Object)"Nickel"));
        for (Pair pair : pairedOres) {
            String s = (String)pair.getLeft();
            MachineInit.addCrusherOreRecipe("ore" + s, "dust" + s, 2, "dust" + (String)pair.getRight(), 1, 0.1f);
            MachineInit.addCrusherOreRecipe("ingot" + s, "dust" + s, 1);
        }
        MachineInit.addCrusherOreRecipe("oreDiamond", "gemDiamond", 1, "gemDiamond", 3, 0.2f);
        MachineInit.addCrusherOreRecipe("oreEmerald", "gemEmerald", 1, "gemEmerald", 3, 0.2f);
        MachineInit.addCrusherOreRecipe("cobblestone", "gravel", 1, "sand", 1, 0.1f);
        MachineInit.addCrusherOreRecipe("gravel", "sand", 1);
        MachineInit.addCrusherOreRecipe("oreLapis", "gemLapis", 8);
        MachineInit.addCrusherOreRecipe("oreRedstone", "dustRedstone", 8);
        MachineInit.addCrusherOreRecipe("oreQuartz", "gemQuartz", 1, "gemQuartz", 3, 0.2f);
        MachineInit.addCrusherOreRecipe("glowstone", "dustGlowstone", 4);
        MachineInit.addCrusherOreRecipe("oreCoal", Items.field_151044_h, 4);
    }

    static void addCrusherOreRecipe(@Nonnull Object oreInput, @Nonnull Object dustOutput, int amount) {
        MachineInit.addCrusherOreRecipe(oreInput, dustOutput, amount, null, 0, 0.0f);
    }

    static void addCrusherOreRecipe(@Nonnull Object oreInput, @Nonnull Object dustOutput, int amount, @Nullable Object outputSecondary, int outputSecondaryAmount, float outputSecondaryProbability) {
        RecipeBuilder recipeBuilder = RecipeBuilder.newbuilder(XUMachineCrusher.INSTANCE);
        recipeBuilder.setItemInput(XUMachineCrusher.INPUT, XUShapedRecipe.getRecipeStackList(oreInput), 1);
        recipeBuilder.setItemOutput(XUMachineCrusher.OUTPUT, XUShapedRecipe.getRecipeStackList(dustOutput), amount);
        if (outputSecondary != null && outputSecondaryAmount > 0) {
            recipeBuilder.setItemOutput(XUMachineCrusher.OUTPUT_SECONDARY, XUShapedRecipe.getRecipeStackList(outputSecondary), outputSecondaryAmount);
            recipeBuilder.setProbability(XUMachineCrusher.OUTPUT_SECONDARY, outputSecondaryProbability);
        }
        recipeBuilder.setEnergy(4000);
        recipeBuilder.setProcessingTime(200);
        XUMachineCrusher.INSTANCE.recipes_registry.addRecipe(recipeBuilder.build());
    }
}

