/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineRegistry;
import com.rwtema.extrautils2.api.recipes.ICustomRecipeMatching;
import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.machine.TileMachine;
import com.rwtema.extrautils2.machine.TileMachineProvider;
import com.rwtema.extrautils2.machine.TileMachineReceiver;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;

public class BlockMachine
extends XUBlock
implements ICustomRecipeMatching {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyEnumSimple<Machine.EnergyMode> TYPE = new PropertyEnumSimple<Machine.EnergyMode>(Machine.EnergyMode.class, "energy");
    public HashMap<IBlockState, HashMap<String, BoxModel>> modelCache = new HashMap();

    public static String getDisplayName(Machine machine) {
        if (machine == null) {
            return Lang.translate("machine.blank", "Machine Block");
        }
        return Lang.translate("machine." + machine.name, StringHelper.capFirst(new ResourceLocation(machine.name).func_110623_a()));
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator.Builder(this).addWorldProperties(new IProperty[]{TYPE}).addWorldProperties(new IProperty[]{ACTIVE}).addWorldPropertyWithDefault(XUBlockStateCreator.ROTATION_HORIZONTAL, EnumFacing.SOUTH).build();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register("extrautils2:machine/machine_base_side", "extrautils2:machine/machine_base", "extrautils2:machine/machine_base_bottom", "extrautils2:machine/machine_err");
        for (Machine machine : MachineRegistry.getMachineValues()) {
            Textures.register(machine.frontTexture);
            Textures.register(machine.frontTextureActive);
            Textures.register(machine.textureBase, machine.textureBottom, machine.textureTop, machine.textureTopOverlay);
        }
    }

    @Override
    public void clearCaches() {
        this.modelCache.clear();
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        String type = "blank";
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileMachine) {
            type = ((TileMachine)tileEntity).type;
        }
        IBlockState foundState = state;
        return this.modelCache.computeIfAbsent(foundState, t -> new HashMap()).computeIfAbsent(type, machine -> this.buildBoxModel(foundState, (String)machine));
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        Machine.EnergyMode value = (Machine.EnergyMode)((Object)state.func_177229_b(TYPE));
        switch (value) {
            case USES_ENERGY: {
                return new TileMachineReceiver();
            }
            case GENERATES_ENERGY: {
                return new TileMachineProvider();
            }
        }
        throw new IllegalStateException((Object)((Object)value) + " not supported");
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, @Nonnull BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postTextureRegister() {
        BlockColors blockColors;
        Minecraft mc = Minecraft.func_71410_x();
        ItemColors itemColors = mc.getItemColors();
        if (itemColors != null) {
            itemColors.func_186731_a(new IItemColor(){

                public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
                    if (tintIndex == 1) {
                        Machine machine;
                        String type = "blank";
                        if (StackHelper.isNonNull(stack) && stack.func_77942_o()) {
                            type = ((NBTTagCompound)Validate.notNull((Object)stack.func_77978_p())).func_74779_i("Type");
                        }
                        if ((machine = MachineRegistry.getMachine(type)) != null) {
                            return machine.color | 0xFF000000;
                        }
                    }
                    return -1;
                }
            }, new Block[]{this});
        }
        if ((blockColors = mc.func_184125_al()) != null) {
            blockColors.func_186722_a((state, world, pos, tintIndex) -> {
                Machine machine;
                TileEntity te;
                if (tintIndex == 1 && world != null && pos != null && (te = world.func_175625_s(pos)) instanceof TileMachine && (machine = ((TileMachine)te).machine) != null) {
                    return machine.color | 0xFF000000;
                }
                return -1;
            }, new Block[]{this});
        }
    }

    private BoxModel buildBoxModel(IBlockState state, String machineKey) {
        BoxModel model = BoxModel.newStandardBlock("extrautils2:machine/machine_base_side");
        model.setLayer(BlockRenderLayer.SOLID);
        model.setTextures(EnumFacing.UP, "extrautils2:machine/machine_base");
        model.setTextures(EnumFacing.DOWN, "extrautils2:machine/machine_base_bottom");
        if (!"blank".equals(machineKey)) {
            String tex_top;
            String tex;
            Machine machine = MachineRegistry.getMachine(machineKey);
            EnumFacing value = ((EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL)).func_176734_d();
            Box baseBox = (Box)model.get(0);
            baseBox.setTextureSides(value, "extrautils2:machine/machine_base");
            if (machine != null) {
                String string = tex = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? machine.frontTextureActive : machine.frontTexture;
                if (machine.textureBase != null) {
                    baseBox.setTexture(machine.textureBase);
                    baseBox.setTextureSides(value, machine.textureTop);
                } else {
                    baseBox.setTextureSides(value, "extrautils2:machine/machine_base");
                }
                if (machine.textureTop != null) {
                    baseBox.setTextureSides(EnumFacing.UP, machine.textureTop);
                }
                if (machine.textureBottom != null) {
                    baseBox.setTextureSides(EnumFacing.DOWN, machine.textureBottom);
                }
                tex_top = machine.textureTopOverlay;
                baseBox.setTint(1);
            } else {
                tex = "extrautils2:machine/machine_err";
                tex_top = null;
            }
            Box box = model.addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            box.layer = BlockRenderLayer.TRANSLUCENT;
            box.setTexture(tex);
            for (EnumFacing facing : EnumFacing.values()) {
                if (facing == EnumFacing.UP && tex_top != null) {
                    box.setTextureSides(EnumFacing.UP, tex_top);
                    box.rotate[1] = value == EnumFacing.NORTH ? 2 : (value == EnumFacing.EAST ? 1 : (value == EnumFacing.WEST ? 3 : 0));
                    continue;
                }
                if (facing == value) continue;
                box.setInvisible(facing);
            }
        }
        return model;
    }

    @Override
    public void getSubBlocksBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn));
        for (Machine machine : MachineRegistry.getMachineValues()) {
            ItemStack stack = this.createStack(machine);
            list.add(stack);
        }
    }

    @Nonnull
    public ItemStack createStack(@Nullable Machine machine) {
        ItemStack stack = new ItemStack((Block)this);
        if (machine != null) {
            stack.func_77983_a("Type", (NBTBase)new NBTTagString(machine.name));
        }
        return stack;
    }

    @Override
    @Nonnull
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        String type = "blank";
        if (StackHelper.isNonNull(item) && item.func_77942_o()) {
            type = ((NBTTagCompound)Validate.notNull((Object)item.func_77978_p())).func_74779_i("Type");
        }
        if (ExtraUtils2.deobf_folder) {
            this.modelCache.clear();
        }
        IBlockState defaultState = this.xuBlockState.defaultState.func_177226_a((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL, (Comparable)EnumFacing.SOUTH);
        return this.modelCache.computeIfAbsent(defaultState, state -> new HashMap()).computeIfAbsent(type, machine -> this.buildBoxModel(defaultState, (String)machine));
    }

    @Override
    @Nonnull
    public IBlockState xuOnBlockPlacedBase(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.xuBlockState.getStateFromDropMeta(meta).func_177226_a((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tileEntity = (TileEntity)this.droppingTileEntity.get();
        if (tileEntity instanceof TileMachine) {
            return ImmutableList.of((Object)this.createStack(((TileMachine)tileEntity).machine));
        }
        return super.getDrops(world, pos, state, fortune);
    }

    @Override
    public boolean itemsMatch(ItemStack slot, @Nonnull ItemStack target) {
        if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)slot, (boolean)false)) {
            return false;
        }
        NBTTagCompound nbt = slot.func_77978_p();
        if (target.func_77942_o()) {
            return ICustomRecipeMatching.satisfies((NBTBase)target.func_77978_p(), (NBTBase)nbt);
        }
        return nbt == null || !nbt.func_74764_b("Type");
    }
}

