/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.interblock;

import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.BitSet;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.function.BiConsumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class BlockSet
implements INBTSerializable<NBTTagList> {
    public static final int ROW_BASE = 4;
    public static final int NUM_ROWS_PER_SET = 16;
    TIntObjectHashMap<BitSet> bitSets = new TIntObjectHashMap();
    TIntIntHashMap bitSetSizes = new TIntIntHashMap(10, 0.5f, 0, 0);
    int total_blocks = 0;

    public static int getBit(BlockPos pos) {
        return (pos.func_177956_o() & 0xF) << 8 | (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
    }

    public int getSize() {
        return this.total_blocks;
    }

    public boolean isEmpty() {
        return this.total_blocks == 0;
    }

    public void set(BlockPos pos) {
        int key = pos.func_177956_o() >> 4;
        BitSet subBitSet = (BitSet)this.bitSets.get(key);
        int bit = BlockSet.getBit(pos);
        if (subBitSet == null) {
            subBitSet = new BitSet();
            this.bitSets.put(key, (Object)subBitSet);
            this.bitSetSizes.put(key, 0);
        } else if (subBitSet.get(bit)) {
            return;
        }
        subBitSet.set(bit);
        this.bitSetSizes.adjustValue(bit, 1);
        ++this.total_blocks;
    }

    public void clear(BlockPos pos) {
        int key = pos.func_177956_o() >> 4;
        BitSet subBitSet = (BitSet)this.bitSets.get(key);
        if (subBitSet == null) {
            return;
        }
        int bit = BlockSet.getBit(pos);
        if (!subBitSet.get(bit)) {
            return;
        }
        subBitSet.clear(bit);
        this.bitSetSizes.adjustValue(bit, -1);
        --this.total_blocks;
        if (this.bitSetSizes.get(bit) == 0) {
            this.bitSets.remove(key);
            this.bitSetSizes.remove(key);
        }
    }

    public NBTTagList serializeNBT() {
        NBTTagList list = new NBTTagList();
        this.bitSets.forEachEntry((a, b) -> {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("y", a);
            compound.func_74773_a("bytes", b.toByteArray());
            list.func_74742_a((NBTBase)compound);
            return true;
        });
        return list;
    }

    public void deserializeNBT(NBTTagList nbt) {
        this.bitSets.clear();
        this.bitSetSizes.clear();
        this.total_blocks = 0;
        for (NBTTagCompound compound : NBTHelper.iterateNBTTagList(nbt)) {
            int y = compound.func_74762_e("y");
            byte[] bytes = compound.func_74770_j("bytes");
            BitSet bitSet = BitSet.valueOf(bytes);
            this.bitSets.put(y, (Object)bitSet);
            int cardinality = bitSet.cardinality();
            this.bitSetSizes.put(y, cardinality);
            this.total_blocks += cardinality;
        }
    }

    public void writeToPacket(XUPacketBuffer buffer) {
        buffer.writeVarInt(this.bitSets.size());
        this.bitSets.forEachEntry((a, b) -> {
            buffer.writeVarInt(a);
            byte[] bytes = b.toByteArray();
            buffer.writeVarInt(bytes.length);
            buffer.writeBytes(bytes);
            return true;
        });
    }

    public void readFromPacket(XUPacketBuffer buffer) {
        this.bitSets.clear();
        this.bitSetSizes.clear();
        this.total_blocks = 0;
        int n = buffer.readVarInt();
        for (int i = 0; i < n; ++i) {
            int y = buffer.readVarInt();
            int dn = buffer.readVarInt();
            byte[] bytes = new byte[dn];
            buffer.data.readBytes(bytes);
            BitSet bitSet = BitSet.valueOf(bytes);
            this.bitSets.put(y, (Object)bitSet);
            int cardinality = bitSet.cardinality();
            this.bitSetSizes.put(y, cardinality);
            this.total_blocks += cardinality;
        }
    }

    public void or(BlockSet other) {
        this.processOther(other, (b, bitSet) -> bitSet.or((BitSet)b));
    }

    public void and(BlockSet other) {
        this.processOther(other, (b, bitSet) -> bitSet.and((BitSet)b));
    }

    public void processOther(BlockSet other, BiConsumer<BitSet, BitSet> biConsumer) {
        other.bitSets.forEachEntry((a, b) -> {
            BitSet bitSet = (BitSet)this.bitSets.get(a);
            if (bitSet == null) {
                bitSet = new BitSet();
                this.bitSets.put(a, (Object)bitSet);
            }
            biConsumer.accept((BitSet)b, bitSet);
            return true;
        });
        this.recalcSizes();
    }

    private void recalcSizes() {
        this.total_blocks = 0;
        this.bitSetSizes.clear();
        this.bitSets.forEachEntry((a, b) -> {
            int cardinality = b.cardinality();
            this.total_blocks += cardinality;
            this.bitSetSizes.put(a, cardinality);
            return true;
        });
    }

    public Iterator<BlockPos.MutableBlockPos> getBlockPosIterator(int chunk_x, int chunk_z) {
        final int x0 = chunk_x << 4;
        final int z0 = chunk_z << 4;
        return new Iterator<BlockPos.MutableBlockPos>(){
            BlockPos.MutableBlockPos block = new BlockPos.MutableBlockPos();
            TIntObjectIterator<BitSet> iterator;
            int y;
            PrimitiveIterator.OfInt intStream;
            {
                this.iterator = BlockSet.this.bitSets.iterator();
                this.intStream = null;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || this.intStream != null && this.intStream.hasNext();
            }

            @Override
            public BlockPos.MutableBlockPos next() {
                if (this.intStream == null) {
                    this.iterator.advance();
                    this.y = this.iterator.key() << 4;
                    this.intStream = ((BitSet)this.iterator.value()).stream().iterator();
                }
                int bit = this.intStream.nextInt();
                int x = x0 | bit & 0xF;
                int z = z0 | bit >> 4 & 0xF;
                int y = this.y | bit >> 8;
                this.block.func_181079_c(x, y, z);
                return this.block;
            }
        };
    }
}

