/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrowBase;
import com.rwtema.extrautils2.gui.backend.WidgetSlot;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetCraftingMatrix {
    public InventoryCrafting crafter;
    public InventoryCraftResult craftResult;
    public WidgetSlot[][] slots;
    public WidgetSlotCrafting slotCrafting;
    public List<IWidget> widgets;

    public WidgetCraftingMatrix(EntityPlayer player, int grid_x, int grid_y, int grid_w, int grid_h) {
        this(player, grid_x, grid_y, grid_w, grid_h, grid_x + grid_w * 18 + 22 + 8, grid_y + (grid_h - 1) * 18 / 2, grid_x + grid_w * 18 + 4, grid_y + (grid_h - 1) * 18 / 2);
    }

    public WidgetCraftingMatrix(EntityPlayer player, int grid_x, int grid_y, int grid_w, int grid_h, int result_x, int result_y, int arrow_x, int arrow_y) {
        this.slots = new WidgetSlot[grid_w][grid_h];
        ImmutableList.Builder builder = ImmutableList.builder();
        this.craftResult = new InventoryCraftResult();
        this.crafter = new XUInventoryCrafting(this, player, 3, 3);
        for (int j = 0; j < grid_h; ++j) {
            for (int i = 0; i < grid_w; ++i) {
                WidgetSlotIngredients widgetSlotIngredients = new WidgetSlotIngredients(i, j, grid_x, grid_y, this.crafter);
                this.slots[i][j] = widgetSlotIngredients;
                builder.add((Object)widgetSlotIngredients);
            }
        }
        this.slotCrafting = new WidgetSlotCrafting(player, this.crafter, this.craftResult, result_x, result_y);
        builder.add((Object)this.slotCrafting);
        builder.add((Object)new WidgetProgressArrowBase(arrow_x, arrow_y));
        this.widgets = builder.build();
    }

    public static class XUInventoryCrafting
    extends InventoryCrafting {
        public EntityPlayer player;

        public XUInventoryCrafting(final WidgetCraftingMatrix widgetCraftingMatrix, final EntityPlayer player, int width, int height) {
            super(new Container(){

                public void func_75130_a(IInventory inventoryIn) {
                    widgetCraftingMatrix.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(widgetCraftingMatrix.crafter, player.field_70170_p));
                }

                public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
                    return false;
                }
            }, width, height);
            this.player = player;
        }
    }

    public static class WidgetSlotIngredients
    extends WidgetSlot {
        public final int index;
        public InventoryCrafting crafter;

        public WidgetSlotIngredients(int i, int j, int grid_x, int grid_y, InventoryCrafting crafter) {
            super((IInventory)crafter, i + j * 3, grid_x + i * 18, grid_y + j * 18);
            this.crafter = crafter;
            this.index = i + j * 3;
        }

        @Override
        public void onContainerClosed(DynamicContainer container, EntityPlayer playerIn) {
            ItemStack itemStack;
            if (!playerIn.field_70170_p.field_72995_K && StackHelper.isNonNull(itemStack = this.crafter.func_70304_b(this.getSlotIndex()))) {
                playerIn.func_71019_a(itemStack, false);
            }
        }

        @Override
        public void addToContainer(DynamicContainer container) {
            super.addToContainer(container);
        }
    }

    public static class WidgetSlotCrafting
    extends SlotCrafting
    implements IWidget {
        private final int x;
        private final int y;

        public WidgetSlotCrafting(EntityPlayer player, InventoryCrafting craftingInventory, InventoryCraftResult inventoryIn, int x, int y) {
            super(player, craftingInventory, (IInventory)inventoryIn, 0, x + 1, y + 1);
            this.x = x;
            this.y = y;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getW() {
            return 18;
        }

        @Override
        public int getH() {
            return 18;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 0, 0, 18, 18);
        }

        @Override
        public List<String> getToolTip() {
            return null;
        }

        @Override
        public void addToContainer(DynamicContainer container) {
            container.addSlot((Slot)this);
        }
    }
}

