/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.rwtema.extrautils2.backend.IMetaProperty;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MapPopulator;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.Validate;

public class XUBlockStateCreator
extends BlockStateContainer {
    public static final PropertyDirection ROTATION_HORIZONTAL = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection ROTATION_ALL = PropertyDirection.func_177713_a((String)"facing", Arrays.asList(EnumFacing.values()));
    public static final PropertyDirection ROTATION_HORIZONTAL_INC_DOWN = PropertyDirection.func_177713_a((String)"facing", Arrays.asList(EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH));
    public static final Map<EnumFacing, PropertyBool> FACING_BOOLEANS = XUBlockStateCreator.createDirectionBooleanMap(null, (name, side) -> PropertyBool.func_177716_a((String)name));
    public static final Comparator<IProperty> property_sorter = (a, b) -> a.func_177701_a().compareTo(b.func_177701_a());
    public final HashMap<IProperty, Comparable> defaultValues;
    public final XUBlockState defaultState;
    public final XUBlockState[] dropmeta2state;
    @Nonnull
    public final IMetaProperty<? extends Comparable>[] hiddenProperties;
    protected final TObjectIntHashMap<IBlockState> state2meta = new TObjectIntHashMap();
    protected final TObjectIntHashMap<IBlockState> state2dropMeta = new TObjectIntHashMap();
    final IBlockState[] meta2state;
    public XUBlock mainBlock;

    /*
     * WARNING - void declaration
     */
    protected XUBlockStateCreator(XUBlock block, @Nonnull IProperty<? extends Comparable>[] worldProperties, @Nonnull IProperty<? extends Comparable>[] dropProperties, @Nonnull IMetaProperty<? extends Comparable>[] hiddenProperties, HashMap<IProperty, Comparable> defaultValues) {
        super((Block)block, (IProperty[])Validate.noNullElements((Object[])XUBlockStateCreator.joinProperties(XUBlockStateCreator.joinProperties(worldProperties, dropProperties), hiddenProperties)), ImmutableMap.of());
        void var10_13;
        this.mainBlock = block;
        this.hiddenProperties = hiddenProperties;
        Arrays.sort(worldProperties, property_sorter);
        Arrays.sort(dropProperties, property_sorter);
        Arrays.sort(hiddenProperties, property_sorter);
        this.defaultValues = defaultValues == null ? new HashMap() : defaultValues;
        for (IProperty iProperty : this.func_177623_d()) {
            if (defaultValues != null && this.defaultValues.containsKey(iProperty)) continue;
            Collection allowedValues = iProperty.func_177700_c();
            this.defaultValues.put(iProperty, (Comparable)Collections.min(allowedValues));
        }
        ImmutableList validStates = super.func_177619_a();
        IBlockState defaultState = (IBlockState)validStates.get(0);
        for (Map.Entry entry2 : this.defaultValues.entrySet()) {
            defaultState = defaultState.func_177226_a((IProperty)entry2.getKey(), (Comparable)entry2.getValue());
        }
        this.defaultState = (XUBlockState)defaultState;
        Collection<IBlockState> myStates = this.getMyStates((ImmutableList<IBlockState>)validStates);
        LinkedHashSet<IBlockState> linkedHashSet = new LinkedHashSet<IBlockState>();
        for (IBlockState validState : myStates) {
            for (IMetaProperty<? extends Comparable> hiddenProperty : hiddenProperties) {
                Comparable comparable = this.defaultValues.get(hiddenProperty);
                validState = validState.func_177226_a(hiddenProperty, comparable);
            }
            linkedHashSet.add(validState);
        }
        this.meta2state = linkedHashSet.toArray(new IBlockState[linkedHashSet.size()]);
        boolean bl = false;
        while (var10_13 < this.meta2state.length) {
            this.state2meta.put((Object)this.meta2state[var10_13], (int)var10_13);
            ++var10_13;
        }
        UnmodifiableIterator unmodifiableIterator = validStates.iterator();
        while (unmodifiableIterator.hasNext()) {
            IBlockState validState;
            IBlockState significantState = validState = (IBlockState)unmodifiableIterator.next();
            for (IMetaProperty<? extends Comparable> hiddenProperty : hiddenProperties) {
                significantState = significantState.func_177226_a(hiddenProperty, this.defaultValues.get(hiddenProperty));
            }
            this.state2meta.putIfAbsent((Object)validState, this.state2meta.get((Object)significantState));
        }
        Validate.isTrue((this.meta2state.length <= 16 ? 1 : 0) != 0);
        for (int i2 : this.state2meta.values()) {
            Validate.isTrue((i2 >= 0 && i2 < 16 ? 1 : 0) != 0);
        }
        LinkedHashSet<IBlockState> linkedHashSet2 = new LinkedHashSet<IBlockState>();
        UnmodifiableIterator validState = validStates.iterator();
        while (validState.hasNext()) {
            IBlockState validState2;
            IBlockState metaState = validState2 = (IBlockState)validState.next();
            for (IProperty<? extends Comparable> iProperty : worldProperties) {
                metaState = metaState.func_177226_a(iProperty, this.defaultValues.get(iProperty));
            }
            for (IProperty<? extends Comparable> iProperty : hiddenProperties) {
                metaState = metaState.func_177226_a(iProperty, this.defaultValues.get(iProperty));
            }
            linkedHashSet2.add(metaState);
        }
        this.dropmeta2state = linkedHashSet2.toArray(new XUBlockState[linkedHashSet2.size()]);
        for (int i3 = 0; i3 < this.dropmeta2state.length; ++i3) {
            this.state2dropMeta.put((Object)this.dropmeta2state[i3], i3);
        }
        for (IBlockState validState3 : validStates) {
            if (this.state2dropMeta.containsKey((Object)validState3)) continue;
            IBlockState metaState = validState3;
            for (IProperty<? extends Comparable> iProperty : worldProperties) {
                metaState = metaState.func_177226_a(iProperty, this.defaultValues.get(iProperty));
            }
            for (IProperty<? extends Comparable> iProperty : hiddenProperties) {
                metaState = metaState.func_177226_a(iProperty, this.defaultValues.get(iProperty));
            }
            this.state2dropMeta.put((Object)validState3, this.state2dropMeta.get((Object)metaState));
        }
        for (IBlockState validState4 : validStates) {
            int n;
            StringBuilder builder = new StringBuilder();
            boolean flag = false;
            IProperty<? extends Comparable>[] iPropertyArray = dropProperties;
            int n2 = iPropertyArray.length;
            boolean bl2 = false;
            while (n < n2) {
                IProperty<? extends Comparable> iProperty = iPropertyArray[n];
                if (flag) {
                    builder.append(".");
                } else {
                    flag = true;
                }
                builder.append(validState4.func_177229_b(iProperty).toString().toLowerCase());
                ++n;
            }
            for (IProperty<? extends Comparable> iProperty : hiddenProperties) {
                if (!iProperty.addLocalization()) continue;
                if (flag) {
                    builder.append(".");
                } else {
                    flag = true;
                }
                builder.append(validState4.func_177229_b(iProperty).toString().toLowerCase());
            }
            ((XUBlockState)validState4).dropName = builder.toString();
        }
        for (IBlockState validState5 : validStates) {
            XUBlockState xuBlockState = (XUBlockState)validState5;
            xuBlockState.metadata = this.state2meta.get((Object)xuBlockState);
            xuBlockState.dropMeta = this.state2dropMeta.get((Object)xuBlockState);
        }
    }

    public XUBlockStateCreator(XUBlock xuBlock) {
        this(xuBlock, new IProperty[0]);
    }

    public XUBlockStateCreator(XUBlock xuBlock, IProperty<?> ... properties) {
        this(xuBlock, properties, (IProperty<?>[])new IProperty[0]);
    }

    public XUBlockStateCreator(XUBlock xuBlock, boolean dummy, IProperty<?> ... dropProperties) {
        this(xuBlock, (IProperty<?>[])new IProperty[0], dropProperties);
    }

    public XUBlockStateCreator(XUBlock xuBlock, IProperty<?>[] properties, IProperty<?>[] dropProperties) {
        this(xuBlock, (IProperty<? extends Comparable>[])properties, (IProperty<? extends Comparable>[])dropProperties, new IMetaProperty[0], (HashMap<IProperty, Comparable>)null);
    }

    @Nonnull
    public static <T extends IProperty<Boolean>> EnumMap<EnumFacing, T> createDirectionBooleanMap(final String name, final BiFunction<String, EnumFacing, T> function) {
        return new EnumMap(MapPopulator.func_179400_b((Iterable)Lists.newArrayList((Object[])EnumFacing.values()), (Iterable)Lists.transform((List)Lists.newArrayList((Object[])EnumFacing.values()), (Function)new Function<EnumFacing, T>(){

            @Nullable
            public T apply(EnumFacing input) {
                String dirName = input.func_176610_l().toLowerCase();
                if (name != null) {
                    dirName = name + "_" + dirName;
                }
                return (IProperty)function.apply(dirName, input);
            }
        })));
    }

    public static IProperty<?>[] joinProperties(IProperty[] a, IProperty[] b) {
        if (b == null || b.length == 0) {
            return a;
        }
        IProperty[] properties = new IProperty[a.length + b.length];
        System.arraycopy(a, 0, properties, 0, a.length);
        System.arraycopy(b, 0, properties, a.length, b.length);
        return properties;
    }

    public static Builder builder(XUBlock block) {
        return new Builder(block);
    }

    protected Collection<IBlockState> getMyStates(ImmutableList<IBlockState> validStates) {
        return validStates;
    }

    @Nonnull
    protected BlockStateContainer.StateImplementation createState(@Nonnull Block block, @Nonnull ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        return new XUBlockState(block, properties);
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta < 0 || meta >= this.meta2state.length) {
            return this.defaultState;
        }
        return this.meta2state[meta];
    }

    public int getMetaFromState(IBlockState state) {
        int i = this.state2meta.get((Object)state);
        return i >= 0 ? i : 0;
    }

    public XUBlockState getStateFromDropMeta(int meta) {
        if (meta < 0 || meta >= this.dropmeta2state.length) {
            return this.defaultState;
        }
        return this.dropmeta2state[meta];
    }

    public int getDropMetaFromState(IBlockState state) {
        int i = this.state2dropMeta.get((Object)state);
        return i >= 0 ? i : 0;
    }

    public XUBlockState getStateFromItemStack(ItemStack item) {
        return this.mainBlock.getStateFromItemStack(item);
    }

    public static class Builder {
        final List<IProperty<? extends Comparable>> worldProperties = Lists.newArrayList();
        final List<IProperty<? extends Comparable>> dropProperties = Lists.newArrayList();
        final List<IMetaProperty<? extends Comparable>> metaProperties = Lists.newArrayList();
        final HashMap<IProperty, Comparable> defaultValues = Maps.newHashMap();
        final XUBlock block;

        public Builder(XUBlock block) {
            this.block = block;
        }

        public <T extends Comparable<T>> Builder addMetaProperty(IMetaProperty<T> property) {
            this.metaProperties.add(property);
            this.defaultValues.put(property, (Comparable)property.getDefaultValue());
            return this;
        }

        public <T extends Comparable<T>> Builder addWorldPropertyWithDefault(IProperty<T> property, T value) {
            this.worldProperties.add(property);
            this.defaultValues.put(property, value);
            return this;
        }

        public <T extends Comparable<T>> Builder addDropPropertyWithDefault(IProperty<T> property, T value) {
            this.dropProperties.add(property);
            this.defaultValues.put(property, value);
            return this;
        }

        public Builder addWorldProperties(IProperty<?> ... properties) {
            Collections.addAll(this.worldProperties, properties);
            return this;
        }

        public Builder addDropProperties(IProperty<?> ... properties) {
            Collections.addAll(this.dropProperties, properties);
            return this;
        }

        public <T extends Comparable<T>> Builder setDefaultValue(IProperty<T> property, T value) {
            this.defaultValues.put(property, value);
            return this;
        }

        public Builder addWorldProperties(Collection<IProperty<?>> properties) {
            this.worldProperties.addAll(properties);
            return this;
        }

        public Builder addDropProperties(Collection<IProperty<?>> properties) {
            this.dropProperties.addAll(properties);
            return this;
        }

        public XUBlockStateCreator build() {
            IProperty[] worldProperties = this.worldProperties.toArray(new IProperty[this.worldProperties.size()]);
            IProperty[] dropProperties = this.dropProperties.toArray(new IProperty[this.dropProperties.size()]);
            IMetaProperty[] hiddenProperties = this.metaProperties.toArray(new IMetaProperty[this.metaProperties.size()]);
            return new XUBlockStateCreator(this.block, worldProperties, dropProperties, hiddenProperties, this.defaultValues.isEmpty() ? null : this.defaultValues);
        }
    }
}

