/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.api.recipes;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.compatibility.StackHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public interface IRecipeInfoWrapper<T extends IRecipe>
extends IRecipe {
    public static List<List<ItemStack>> getInputList(IRecipe recipe) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        if (recipe instanceof ShapedRecipes) {
            for (ItemStack recipeItem : ((ShapedRecipes)recipe).field_77574_d) {
                if (StackHelper.isNonNull(recipeItem)) {
                    inputs.add(Collections.singletonList(recipeItem));
                    continue;
                }
                inputs.add((List<ItemStack>)ImmutableList.of());
            }
            return inputs;
        }
        if (recipe instanceof ShapedOreRecipe) {
            for (Object o : ((ShapedOreRecipe)recipe).getInput()) {
                if (o instanceof List) {
                    inputs.add((List)o);
                    continue;
                }
                if (o instanceof ItemStack) {
                    inputs.add(Collections.singletonList((ItemStack)o));
                    continue;
                }
                inputs.add((List<ItemStack>)ImmutableList.of());
            }
            return inputs;
        }
        if (recipe instanceof ShapelessRecipes) {
            for (ItemStack recipeItem : ((ShapelessRecipes)recipe).field_77579_b) {
                if (StackHelper.isNonNull(recipeItem)) {
                    inputs.add(Collections.singletonList(recipeItem));
                    continue;
                }
                inputs.add((List<ItemStack>)ImmutableList.of());
            }
            return inputs;
        }
        if (recipe instanceof ShapelessOreRecipe) {
            for (Object o : ((ShapelessOreRecipe)recipe).getInput()) {
                if (o instanceof List) {
                    inputs.add((List)o);
                    continue;
                }
                if (o instanceof ItemStack) {
                    inputs.add(Collections.singletonList((ItemStack)o));
                    continue;
                }
                inputs.add((List<ItemStack>)ImmutableList.of());
            }
            return inputs;
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public static int[] getDimensions(IRecipe recipe) {
        ArrayList inputs = new ArrayList();
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shapedRecipes = (ShapedRecipes)recipe;
            return new int[]{shapedRecipes.field_77576_b, shapedRecipes.field_77577_c};
        }
        if (recipe instanceof ShapedOreRecipe) {
            int width = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"width"});
            int height = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"height"});
            return new int[]{width, height};
        }
        return null;
    }

    public T getOriginalRecipe();

    public String info();
}

