/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.google.common.base.Predicate;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockController
extends BlockContainer
implements INetworked {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockController(String name) {
        super(Material.field_151576_e);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.field_149783_u = true;
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149713_g(255);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int func_149738_a(World world) {
        return 100;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState blockNorth = world.func_180495_p(pos.func_177978_c());
            IBlockState blockSouth = world.func_180495_p(pos.func_177968_d());
            IBlockState blockWest = world.func_180495_p(pos.func_177976_e());
            IBlockState blockEast = world.func_180495_p(pos.func_177974_f());
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH && blockNorth.func_185913_b() && !blockSouth.func_185913_b()) {
                facing = EnumFacing.SOUTH;
            }
            if (facing == EnumFacing.SOUTH && blockSouth.func_185913_b() && !blockNorth.func_185913_b()) {
                facing = EnumFacing.NORTH;
            }
            if (facing == EnumFacing.WEST && blockWest.func_185913_b() && !blockEast.func_185913_b()) {
                facing = EnumFacing.EAST;
            }
            if (facing == EnumFacing.EAST && blockEast.func_185913_b() && !blockWest.func_185913_b()) {
                facing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityController tile;
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)entity.func_174811_aO().func_176734_d()), 2);
        if (itemStack.func_82837_s() && (tile = this.getTileEntity((IBlockAccess)world, pos)) != null) {
            tile.setInventoryName(itemStack.func_82833_r());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumFacing blockDir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        TileEntityController te = this.getTileEntitySafe(world, pos);
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item != null && this.toggle(world, pos, player, item.func_77973_b())) {
            return true;
        }
        if (blockDir != side) {
            return false;
        }
        if (!world.field_72995_K) {
            te.interactPutItemsIntoInventory(player);
        }
        return true;
    }

    public boolean toggle(World world, BlockPos pos, EntityPlayer player, Item item) {
        if (world.field_72995_K || item == null) {
            return false;
        }
        if (item == ModItems.drawerKey) {
            this.toggle(world, pos, player, EnumKeyType.DRAWER);
        } else if (item == ModItems.shroudKey) {
            this.toggle(world, pos, player, EnumKeyType.CONCEALMENT);
        } else if (item == ModItems.quantifyKey) {
            this.toggle(world, pos, player, EnumKeyType.QUANTIFY);
        } else if (item == ModItems.personalKey) {
            this.toggle(world, pos, player, EnumKeyType.PERSONAL);
        } else {
            return false;
        }
        return true;
    }

    public void toggle(World world, BlockPos pos, EntityPlayer player, EnumKeyType keyType) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityController te = this.getTileEntitySafe(world, pos);
        if (te == null) {
            return;
        }
        switch (keyType) {
            case DRAWER: {
                te.toggleLock(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED, player.func_146103_bH());
                break;
            }
            case CONCEALMENT: {
                te.toggleShroud(player.func_146103_bH());
                break;
            }
            case QUANTIFY: {
                te.toggleQuantified(player.func_146103_bH());
                break;
            }
            case PERSONAL: {
                String securityKey = ModItems.personalKey.getSecurityProviderKey(0);
                ISecurityProvider provider = StorageDrawers.securityRegistry.getProvider(securityKey);
                te.toggleProtection(player.func_146103_bH(), provider);
            }
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state == null || state.func_177229_b((IProperty)FACING) != side;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityController te = this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        te.updateCache();
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public TileEntityController createNewTileEntity(World world, int meta) {
        return new TileEntityController();
    }

    public TileEntityController getTileEntity(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        return tile instanceof TileEntityController ? (TileEntityController)tile : null;
    }

    public TileEntityController getTileEntitySafe(World world, BlockPos pos) {
        TileEntityController tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            tile = this.createNewTileEntity(world, 0);
            world.func_175690_a(pos, (TileEntity)tile);
        }
        return tile;
    }
}

