/*
 * Decompiled with CFR 0.152.
 */
package zairus.weaponcaseloot.item;

import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import zairus.weaponcaseloot.WCLConfig;
import zairus.weaponcaseloot.WCLConstants;
import zairus.weaponcaseloot.WeaponCaseLoot;
import zairus.weaponcaseloot.item.WCLItemWeapon;
import zairus.weaponcaseloot.item.WCLItems;
import zairus.weaponcaseloot.sound.WCLSoundEvents;
import zairus.weaponcaseloot.stats.WCLAchievementList;

public class WeaponSword
extends WCLItemWeapon {
    private float swordDamage;
    private final Item.ToolMaterial swordMaterial;
    private final String name = "weaponsword";

    public WeaponSword() {
        this.setUnlocalizedName("weaponsword");
        this.func_77637_a(WeaponCaseLoot.weaponCaseLootTab);
        this.swordMaterial = Item.ToolMaterial.DIAMOND;
        this.field_77777_bU = 1;
    }

    public String getName() {
        return "weaponsword";
    }

    public WeaponSword setDurability(int durability) {
        this.func_77656_e(durability);
        return this;
    }

    public WeaponSword setAttackDamage(float damage) {
        this.swordDamage = damage;
        return this;
    }

    public String func_77658_a() {
        return super.func_77658_a();
    }

    public int getMetadata(ItemStack stack) {
        int meta = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("weapon_index")) {
            meta = stack.func_77978_p().func_74762_e("weapon_index");
        }
        return meta;
    }

    public int func_77612_l() {
        return super.func_77612_l();
    }

    public int getMaxDamage(ItemStack stack) {
        int maxDamage = this.func_77612_l();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("weapon_durability")) {
            maxDamage = stack.func_77978_p().func_74762_e("weapon_durability");
        }
        return maxDamage;
    }

    public float func_150931_i() {
        return this.swordMaterial.func_78000_c();
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase enemy, EntityLivingBase holder) {
        int j;
        float attackDamage = this.swordDamage;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("weapon_damage")) {
            attackDamage = stack.func_77978_p().func_74760_g("weapon_damage");
        }
        boolean isCrit = holder.field_70143_R > 0.2f;
        attackDamage += EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)enemy.func_70668_bt());
        if (isCrit) {
            attackDamage = (float)((double)attackDamage * 1.2);
        }
        int i = 0;
        boolean flag = enemy.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)holder)), attackDamage);
        if ((i += EnchantmentHelper.func_77501_a((EntityLivingBase)holder)) > 0) {
            enemy.func_70024_g((double)(-MathHelper.func_76126_a((float)(holder.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(holder.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
        }
        if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)holder)) > 0) {
            enemy.func_70015_d(j * 4);
        }
        if (holder instanceof EntityPlayer && !((EntityPlayer)holder).field_71075_bZ.field_75098_d) {
            stack.func_77972_a(1, enemy);
        }
        return flag;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase player) {
        if ((double)state.func_185887_b(world, pos) != 0.0) {
            stack.func_77972_a(2, player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return super.func_77661_b(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        return super.func_77659_a(itemStack, world, player, hand);
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150321_G;
    }

    public int func_77619_b() {
        return Item.ToolMaterial.GOLD.func_77995_e();
    }

    public String func_150932_j() {
        return this.swordMaterial.toString();
    }

    public boolean func_82789_a(ItemStack stack, ItemStack source) {
        ItemStack mat = this.swordMaterial.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)source, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(stack, source);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i1, boolean b1) {
        NBTTagCompound tag;
        String name;
        char fChar;
        if (stack.func_82837_s() && (fChar = (name = stack.func_82833_r()).charAt(0)) != '\u00a7' && (fChar == 'b' || fChar == 'a' || fChar == 'e' || fChar == '6')) {
            stack.func_151001_c('\u00a7' + name);
        }
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("weapon_looptimer")) {
            tag.func_74768_a("temp_looping", 1);
            float t = tag.func_74760_g("weapon_looptimer");
            int iconIndex = tag.func_74762_e("weapon_index");
            if (!tag.func_74764_b("temp_index")) {
                tag.func_74768_a("temp_index", iconIndex);
                tag.func_74778_a("temp_name", stack.func_82833_r());
                stack.func_151001_c("Weapon Sword");
            }
            if (t < 95.0f) {
                world.func_184148_a((EntityPlayer)null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, WCLSoundEvents.weapon_loop, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
            }
            tag.func_74776_a("weapon_looptimer", t -= 1.0f);
            tag.func_74768_a("weapon_index", field_77697_d.nextInt(24));
            if (t <= 10.0f) {
                int rarity = WCLConfig.sword_rarity[tag.func_74762_e("temp_index")];
                if (rarity == 3) {
                    ((EntityPlayer)entity).func_71029_a((StatBase)WCLAchievementList.legendary);
                }
                tag.func_82580_o("weapon_looptimer");
                tag.func_74768_a("weapon_index", tag.func_74762_e("temp_index"));
                tag.func_82580_o("temp_index");
                stack.func_151001_c(tag.func_74779_i("temp_name"));
                tag.func_82580_o("temp_name");
                tag.func_82580_o("temp_looping");
                world.func_184148_a((EntityPlayer)null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, WCLSoundEvents.blade, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < 24; ++i) {
            for (int q = 0; q < 5; ++q) {
                list.add(this.getSwordFromId(i, q));
            }
        }
    }

    public ItemStack getSwordFromId(int swordId, int quality) {
        ItemStack sword = new ItemStack(WCLItems.sword, 1);
        int rarity = WCLConfig.sword_rarity[swordId];
        NBTTagCompound weaponData = new NBTTagCompound();
        weaponData.func_74778_a("weapon_state", WCLConstants.weapon_quality[quality]);
        weaponData.func_74778_a("weapon_rarity", WCLConstants.weapon_rarity[rarity]);
        weaponData.func_74776_a("weapon_looptimer", 100.0f);
        weaponData.func_74768_a("weapon_index", swordId);
        weaponData.func_74768_a("weapon_durability", WeaponSword.getWeaponDurability(quality, rarity));
        weaponData.func_74776_a("weapon_damage", WeaponSword.getWeaponDamage(quality, rarity));
        sword.func_77982_d(weaponData);
        sword.func_151001_c(this.getNameFromSwordId(swordId));
        return sword;
    }

    public String getNameFromSwordId(int swordId) {
        int rarity = WCLConfig.sword_rarity[swordId];
        String[] levels_colors = new String[]{"\u00a7b", "\u00a7a", "\u00a7e", "\u00a76"};
        String name = levels_colors[rarity] + WCLConfig.sword_names[swordId];
        return name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b1) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && !tag.func_74764_b("temp_looping")) {
            if (tag.func_74764_b("weapon_state")) {
                list.add("Quality: " + tag.func_74779_i("weapon_state"));
            }
            if (tag.func_74764_b("weapon_rarity")) {
                list.add("Rarity: " + tag.func_74779_i("weapon_rarity"));
            }
            if (tag.func_74764_b("weapon_damage")) {
                float attackDamage = tag.func_74760_g("weapon_damage");
                int sLev = 1;
                if (sLev > 0) {
                    attackDamage += (float)(sLev + 1);
                }
                list.add("Attack Damage: " + attackDamage);
            }
        }
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            float attackDamage = this.swordDamage;
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public static int getWeaponDurability(int wState, int wRarity) {
        int durability = 0;
        if (wRarity == 0) {
            switch (wState) {
                case 0: {
                    durability = WCLConfig.durability_common_broken;
                    break;
                }
                case 1: {
                    durability = WCLConfig.durability_common_crude;
                    break;
                }
                case 2: {
                    durability = WCLConfig.durability_common_good;
                    break;
                }
                case 3: {
                    durability = WCLConfig.durability_common_flawless;
                    break;
                }
                case 4: {
                    durability = WCLConfig.durability_common_perfect;
                }
            }
        } else if (wRarity == 1) {
            switch (wState) {
                case 0: {
                    durability = WCLConfig.durability_uncommon_broken;
                    break;
                }
                case 1: {
                    durability = WCLConfig.durability_uncommon_crude;
                    break;
                }
                case 2: {
                    durability = WCLConfig.durability_uncommon_good;
                    break;
                }
                case 3: {
                    durability = WCLConfig.durability_uncommon_flawless;
                    break;
                }
                case 4: {
                    durability = WCLConfig.durability_uncommon_perfect;
                }
            }
        } else if (wRarity == 2) {
            switch (wState) {
                case 0: {
                    durability = WCLConfig.durability_rare_broken;
                    break;
                }
                case 1: {
                    durability = WCLConfig.durability_rare_crude;
                    break;
                }
                case 2: {
                    durability = WCLConfig.durability_rare_good;
                    break;
                }
                case 3: {
                    durability = WCLConfig.durability_rare_flawless;
                    break;
                }
                case 4: {
                    durability = WCLConfig.durability_rare_perfect;
                }
            }
        } else if (wRarity == 3) {
            switch (wState) {
                case 0: {
                    durability = WCLConfig.durability_legendary_broken;
                    break;
                }
                case 1: {
                    durability = WCLConfig.durability_legendary_crude;
                    break;
                }
                case 2: {
                    durability = WCLConfig.durability_legendary_good;
                    break;
                }
                case 3: {
                    durability = WCLConfig.durability_legendary_flawless;
                    break;
                }
                case 4: {
                    durability = WCLConfig.durability_legendary_perfect;
                }
            }
        }
        return durability;
    }

    public static float getWeaponDamage(int wState, int wRarity) {
        float damage = 0.0f;
        if (wRarity == 0) {
            switch (wState) {
                case 0: {
                    damage = WCLConfig.damage_common_broken;
                    break;
                }
                case 1: {
                    damage = WCLConfig.damage_common_crude;
                    break;
                }
                case 2: {
                    damage = WCLConfig.damage_common_good;
                    break;
                }
                case 3: {
                    damage = WCLConfig.damage_common_flawless;
                    break;
                }
                case 4: {
                    damage = WCLConfig.damage_common_perfect;
                }
            }
        } else if (wRarity == 1) {
            switch (wState) {
                case 0: {
                    damage = WCLConfig.damage_uncommon_broken;
                    break;
                }
                case 1: {
                    damage = WCLConfig.damage_uncommon_crude;
                    break;
                }
                case 2: {
                    damage = WCLConfig.damage_uncommon_good;
                    break;
                }
                case 3: {
                    damage = WCLConfig.damage_uncommon_flawless;
                    break;
                }
                case 4: {
                    damage = WCLConfig.damage_uncommon_perfect;
                }
            }
        } else if (wRarity == 2) {
            switch (wState) {
                case 0: {
                    damage = WCLConfig.damage_rare_broken;
                    break;
                }
                case 1: {
                    damage = WCLConfig.damage_rare_crude;
                    break;
                }
                case 2: {
                    damage = WCLConfig.damage_rare_good;
                    break;
                }
                case 3: {
                    damage = WCLConfig.damage_rare_flawless;
                    break;
                }
                case 4: {
                    damage = WCLConfig.damage_rare_perfect;
                }
            }
        } else if (wRarity == 3) {
            switch (wState) {
                case 0: {
                    damage = WCLConfig.damage_legendary_broken;
                    break;
                }
                case 1: {
                    damage = WCLConfig.damage_legendary_crude;
                    break;
                }
                case 2: {
                    damage = WCLConfig.damage_legendary_good;
                    break;
                }
                case 3: {
                    damage = WCLConfig.damage_legendary_flawless;
                    break;
                }
                case 4: {
                    damage = WCLConfig.damage_legendary_perfect;
                }
            }
        }
        return damage;
    }
}

