/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.commands;

import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.commands.AbstractDRCommand;
import mcjty.lib.tools.ChatTools;
import mcjty.lib.tools.ItemStackTools;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CmdInfoCrystal
extends AbstractDRCommand {
    @Override
    public String getHelp() {
        return "";
    }

    @Override
    public String getCommand() {
        return "info";
    }

    @Override
    public int getPermissionLevel() {
        return 1;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length > 1) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "Too many parameters!"));
            return;
        }
        if (!(sender instanceof EntityPlayer)) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "This command only works as a player!"));
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (ItemStackTools.isEmpty((ItemStack)heldItem)) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "You must hold a crystal in your hand!"));
            return;
        }
        if (heldItem.func_77973_b() instanceof ItemBlock && ((ItemBlock)heldItem.func_77973_b()).func_179223_d() == ModBlocks.resonatingCrystalBlock) {
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            float strength = tagCompound.func_74760_g("strength");
            float efficiency = tagCompound.func_74760_g("efficiency");
            float purity = tagCompound.func_74760_g("purity");
            float totalPower = ResonatingCrystalTileEntity.getTotalPower(strength, purity);
            int rfPerTick = ResonatingCrystalTileEntity.getRfPerTick(efficiency, purity);
            int totalSeconds = (int)(totalPower / (float)rfPerTick / 20.0f);
            int totalMinutes = (int)(totalPower / (float)rfPerTick / 1200.0f);
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.GREEN + "Total power: " + (int)totalPower + " RF"));
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.GREEN + "RF per tick: " + rfPerTick));
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.GREEN + "Lifetime: " + totalSeconds + " seconds or " + totalMinutes + " minutes"));
        } else {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "You must hold a crystal in your hand!"));
        }
    }
}

