/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.BookTransformer;
import slimeknights.mantle.client.book.data.AppearanceData;
import slimeknights.mantle.client.book.data.IDataItem;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentError;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.gui.book.GuiBook;

@SideOnly(value=Side.CLIENT)
public class BookData
implements IDataItem {
    public transient int unnamedSectionCounter = 0;
    public transient ArrayList<SectionData> sections = new ArrayList();
    public transient AppearanceData appearance = new AppearanceData();
    public transient ArrayList<ItemStackData.ItemLink> itemLinks = new ArrayList();
    public transient HashMap<String, String> strings = new HashMap();
    public transient FontRenderer fontRenderer;
    protected final transient ArrayList<BookTransformer> transformers = new ArrayList();
    private ArrayList<BookRepository> repositories;

    public BookData(BookRepository ... repositories) {
        this.repositories = new ArrayList<BookRepository>(Arrays.asList(repositories));
    }

    @Override
    public void load() {
        this.sections.clear();
        this.appearance = new AppearanceData();
        this.itemLinks.clear();
        for (BookRepository repo : this.repositories) {
            ResourceLocation languageLocation;
            try {
                List<SectionData> repoContents = repo.getSections();
                this.sections.addAll(repoContents);
                for (SectionData section : repoContents) {
                    section.source = repo;
                }
            }
            catch (Exception e) {
                SectionData error = new SectionData();
                error.name = "errorenous";
                PageData page = new PageData(true);
                page.name = "errorenous";
                page.content = new ContentError("Failed to load repository " + repo.toString() + ".", e);
                error.pages.add(page);
                this.sections.add(error);
            }
            ResourceLocation appearanceLocation = repo.getResourceLocation("appearance.json");
            if (repo.resourceExists(appearanceLocation)) {
                try {
                    this.appearance = (AppearanceData)BookLoader.GSON.fromJson(repo.resourceToString(repo.getResource(appearanceLocation)), AppearanceData.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.appearance.load();
            ResourceLocation itemLinkLocation = repo.getResourceLocation("items.json");
            if (repo.resourceExists(itemLinkLocation)) {
                try {
                    this.itemLinks = new ArrayList<Object>(Arrays.asList((Object[])BookLoader.GSON.fromJson(repo.resourceToString(repo.getResource(itemLinkLocation)), ItemStackData.ItemLink[].class)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!repo.resourceExists(languageLocation = repo.getResourceLocation("language.lang"))) continue;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(repo.getResource(languageLocation).func_110527_b(), "UTF-8"));
                String next = br.readLine();
                while (next != null) {
                    if (!next.startsWith("//") && next.contains("=")) {
                        String key = next.substring(0, next.indexOf(61));
                        String value = next.substring(next.indexOf(61) + 1);
                        this.strings.put(key, value);
                    }
                    next = br.readLine();
                }
            }
            catch (Exception exception) {
            }
        }
        for (SectionData section : this.sections) {
            if (section.source == null) {
                section.source = BookRepository.DUMMY;
            }
            section.parent = this;
            section.load();
        }
        for (BookTransformer transformer : this.transformers) {
            transformer.transform(this);
        }
        for (SectionData section : this.sections) {
            if (section.source == null) {
                section.source = BookRepository.DUMMY;
            }
            if (section.parent != null) continue;
            section.parent = this;
            section.load();
        }
    }

    public SectionData findSection(String name) {
        return this.findSection(name, null);
    }

    public SectionData findSection(String name, @Nullable StatisticsManager statisticsManager) {
        for (SectionData section : this.sections) {
            section.update(statisticsManager);
            if (!section.name.equals(name.toLowerCase())) continue;
            return section.isUnlocked(statisticsManager) ? section : null;
        }
        return null;
    }

    public int getFirstPageNumber(SectionData section) {
        return this.getFirstPageNumber(section, null);
    }

    public int getFirstPageNumber(SectionData section, @Nullable StatisticsManager statisticsManager) {
        int pages = 0;
        for (SectionData sect : this.sections) {
            sect.update(statisticsManager);
            if (section == sect) {
                return section.isUnlocked(statisticsManager) ? pages + 1 : -1;
            }
            if (!sect.isUnlocked(statisticsManager)) continue;
            pages += sect.getPageCount();
        }
        return -1;
    }

    public PageData findPage(int number) {
        return this.findPage(number, null);
    }

    public PageData findPage(int number, @Nullable StatisticsManager statisticsManager) {
        if (number < 0) {
            return null;
        }
        int pages = 0;
        for (SectionData section : this.sections) {
            section.update(statisticsManager);
            if (!section.isUnlocked(statisticsManager)) continue;
            if (pages + section.getPageCount() > number) {
                return section.pages.get(number - pages);
            }
            pages += section.getPageCount();
        }
        return null;
    }

    public PageData findPage(String location) {
        return this.findPage(location, null);
    }

    public PageData findPage(String location, @Nullable StatisticsManager statisticsManager) {
        return this.findPage(this.findPageNumber(location, statisticsManager));
    }

    public int findPageNumber(String location) {
        return this.findPageNumber(location, null);
    }

    public int findPageNumber(String location, @Nullable StatisticsManager statisticsManager) {
        location = location.toLowerCase();
        int pages = 0;
        if (!location.contains(".")) {
            return -1;
        }
        String sectionName = location.substring(0, location.indexOf(46));
        String pageName = location.substring(location.indexOf(46) + 1);
        for (SectionData section : this.sections) {
            section.update(statisticsManager);
            if (!section.isUnlocked(statisticsManager)) continue;
            if (!sectionName.equals(section.name)) {
                pages += section.getPageCount();
                continue;
            }
            for (PageData page : section.pages) {
                if (!pageName.equals(page.name)) {
                    ++pages;
                    continue;
                }
                return pages + 1;
            }
        }
        return -1;
    }

    public int getPageCount() {
        return this.getPageCount(null);
    }

    public int getPageCount(@Nullable StatisticsManager statisticsManager) {
        int pages = 0;
        for (SectionData section : this.sections) {
            section.update(statisticsManager);
            pages += section.isUnlocked(statisticsManager) ? section.getPageCount() : 0;
        }
        return pages;
    }

    public int getFullPageCount() {
        return this.getFullPageCount(null);
    }

    public int getFullPageCount(@Nullable StatisticsManager statisticsManager) {
        return (int)Math.ceil((float)(this.getPageCount(statisticsManager) - 1) / 2.0f) + 1;
    }

    public String getItemAction(ItemStackData item) {
        for (ItemStackData.ItemLink link : this.itemLinks) {
            if (!item.id.equals(link.item.id) || link.damageSensitive && item.damage != link.item.damage) continue;
            return link.action;
        }
        return "";
    }

    public List<SectionData> getVisibleSections(StatisticsManager statisticsManager) {
        ArrayList<SectionData> visible = new ArrayList<SectionData>();
        for (SectionData section : this.sections) {
            if (!section.isUnlocked(statisticsManager) && section.hideWhenLocked) continue;
            visible.add(section);
        }
        return visible;
    }

    public String translate(String string) {
        String out = this.strings.get(string);
        return out != null ? out : string;
    }

    public void openGui(@Nullable ItemStack item) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiBook(this, Minecraft.func_71410_x().field_71439_g.func_146107_m(), item));
        }
    }

    public void addRepository(BookRepository repository) {
        if (repository != null && !this.repositories.contains(repository)) {
            this.repositories.add(repository);
        }
    }

    public void addTransformer(BookTransformer transformer) {
        if (transformer != null && !this.transformers.contains(transformer)) {
            this.transformers.add(transformer);
        }
    }
}

