/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.tconstruct.actions;

import minetweaker.IUndoableAction;
import modtweaker.brackets.util.IMaterial;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class SetModifierAction
implements IUndoableAction {
    private final IMaterial material;
    private final String stat;
    private final float newValue;
    private final float oldValue;

    public SetModifierAction(IMaterial material, String stat, float newValue) {
        this.material = material;
        this.stat = stat;
        this.newValue = newValue;
        this.oldValue = ((HandleMaterialStats)((Material)material.getInternal()).getStats((String)"handle")).modifier;
    }

    private static void set(Material material, String stat, float modifier) {
        IMaterialStats oldStat = material.getStats(stat);
        if (oldStat instanceof HandleMaterialStats) {
            HandleMaterialStats handleStat = (HandleMaterialStats)oldStat;
            HandleMaterialStats newHandle = new HandleMaterialStats(modifier, handleStat.durability);
            material.addStats((IMaterialStats)newHandle);
        }
    }

    public void apply() {
        SetModifierAction.set((Material)this.material.getInternal(), this.stat, this.newValue);
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        SetModifierAction.set((Material)this.material.getInternal(), this.stat, this.oldValue);
    }

    public String describe() {
        return "Setting Modifier of " + this.material.getName() + " to " + this.newValue + " for " + this.stat;
    }

    public String describeUndo() {
        return "Reverting Modifier of " + this.material.getName() + " to " + this.oldValue + " for " + this.stat;
    }

    public Object getOverrideKey() {
        return null;
    }
}

